/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.policies;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.archiva.policies.PolicyConfigurationException;
import org.apache.archiva.policies.PolicyViolationException;
import org.apache.archiva.policies.PreDownloadPolicy;
import org.apache.archiva.policies.urlcache.UrlFailureCache;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="preDownloadPolicy#cache-failures")
public class CachedFailuresPolicy
implements PreDownloadPolicy {
    private Logger log = LoggerFactory.getLogger(CachedFailuresPolicy.class);
    public static final String NO = "no";
    public static final String YES = "yes";
    @Inject
    private UrlFailureCache urlFailureCache;
    private List<String> options = new ArrayList<String>(2);

    public CachedFailuresPolicy() {
        this.options.add(NO);
        this.options.add(YES);
    }

    @Override
    public void applyPolicy(String policySetting, Properties request, File localFile) throws PolicyViolationException, PolicyConfigurationException {
        if (!this.options.contains(policySetting)) {
            throw new PolicyConfigurationException("Unknown cache-failues policy setting [" + policySetting + "], valid settings are [" + StringUtils.join(this.options.iterator(), (String)",") + "]");
        }
        if (NO.equals(policySetting)) {
            this.log.debug("OK to fetch, check-failures policy set to NO.");
            return;
        }
        String url = request.getProperty("url");
        if (StringUtils.isNotBlank((String)url) && this.urlFailureCache.hasFailedBefore(url)) {
            throw new PolicyViolationException("NO to fetch, check-failures detected previous failure on url: " + url);
        }
        this.log.debug("OK to fetch, check-failures detected no issues.");
    }

    @Override
    public String getDefaultOption() {
        return NO;
    }

    @Override
    public String getId() {
        return "cache-failures";
    }

    @Override
    public String getName() {
        return "Cache failures";
    }

    @Override
    public List<String> getOptions() {
        return this.options;
    }
}

