/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.admin.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.archiva.admin.model.beans.PropertyEntry;

public abstract class AbstractRepositoryConnector
implements Serializable {
    private String sourceRepoId;
    private String targetRepoId;
    private String proxyId;
    private List<String> blackListPatterns;
    private List<String> whiteListPatterns;
    private Map<String, String> policies;
    private List<PropertyEntry> policiesEntries;
    private Map<String, String> properties;
    private List<PropertyEntry> propertiesEntries;
    private boolean disabled = false;

    public void addBlackListPattern(String string) {
        this.getBlackListPatterns().add(string);
    }

    public void addPolicy(String key, String value) {
        this.getPolicies().put(key, value);
    }

    public void addProperty(String key, String value) {
        this.getProperties().put(key, value);
    }

    public void addWhiteListPattern(String string) {
        this.getWhiteListPatterns().add(string);
    }

    public List<String> getBlackListPatterns() {
        if (this.blackListPatterns == null) {
            this.blackListPatterns = new ArrayList<String>(0);
        }
        return this.blackListPatterns;
    }

    public Map<String, String> getPolicies() {
        if (this.policies == null) {
            this.policies = new HashMap<String, String>();
        }
        return this.policies;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    public String getProxyId() {
        return this.proxyId;
    }

    public String getSourceRepoId() {
        return this.sourceRepoId;
    }

    public String getTargetRepoId() {
        return this.targetRepoId;
    }

    public List<String> getWhiteListPatterns() {
        if (this.whiteListPatterns == null) {
            this.whiteListPatterns = new ArrayList<String>(0);
        }
        return this.whiteListPatterns;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void removeBlackListPattern(String string) {
        this.getBlackListPatterns().remove(string);
    }

    public void removeWhiteListPattern(String string) {
        this.getWhiteListPatterns().remove(string);
    }

    public void setBlackListPatterns(List<String> blackListPatterns) {
        this.blackListPatterns = blackListPatterns;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setPolicies(Map<String, String> policies) {
        this.policies = policies;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setProxyId(String proxyId) {
        this.proxyId = proxyId;
    }

    public void setSourceRepoId(String sourceRepoId) {
        this.sourceRepoId = sourceRepoId;
    }

    public void setTargetRepoId(String targetRepoId) {
        this.targetRepoId = targetRepoId;
    }

    public void setWhiteListPatterns(List<String> whiteListPatterns) {
        this.whiteListPatterns = whiteListPatterns;
    }

    public String getPolicy(String policyId, String defaultValue) {
        if (this.getPolicies() == null) {
            return null;
        }
        String value = this.getPolicies().get(policyId);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public List<PropertyEntry> getPoliciesEntries() {
        this.policiesEntries = new ArrayList<PropertyEntry>(this.getPolicies().size());
        for (Map.Entry<String, String> entry : this.getPolicies().entrySet()) {
            this.policiesEntries.add(new PropertyEntry(entry.getKey(), entry.getValue()));
        }
        return this.policiesEntries;
    }

    public void setPoliciesEntries(List<PropertyEntry> policiesEntries) {
        for (PropertyEntry propertyEntry : policiesEntries) {
            this.addPolicy(propertyEntry.getKey(), propertyEntry.getValue());
        }
    }

    public List<PropertyEntry> getPropertiesEntries() {
        this.propertiesEntries = new ArrayList<PropertyEntry>(this.getProperties().size());
        for (Map.Entry<String, String> entry : this.getProperties().entrySet()) {
            this.propertiesEntries.add(new PropertyEntry(entry.getKey(), entry.getValue()));
        }
        return this.propertiesEntries;
    }

    public void setPropertiesEntries(List<PropertyEntry> propertiesEntries) {
        for (PropertyEntry propertyEntry : propertiesEntries) {
            this.addProperty(propertyEntry.getKey(), propertyEntry.getValue());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractRepositoryConnector that = (AbstractRepositoryConnector)o;
        if (this.sourceRepoId != null ? !this.sourceRepoId.equals(that.sourceRepoId) : that.sourceRepoId != null) {
            return false;
        }
        return !(this.targetRepoId != null ? !this.targetRepoId.equals(that.targetRepoId) : that.targetRepoId != null);
    }

    public int hashCode() {
        int result = this.sourceRepoId != null ? this.sourceRepoId.hashCode() : 0;
        result = 31 * result + (this.targetRepoId != null ? this.targetRepoId.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AbstractRepositoryConnector");
        sb.append("{sourceRepoId='").append(this.sourceRepoId).append('\'');
        sb.append(", targetRepoId='").append(this.targetRepoId).append('\'');
        sb.append(", proxyId='").append(this.proxyId).append('\'');
        sb.append(", blackListPatterns=").append(this.blackListPatterns);
        sb.append(", whiteListPatterns=").append(this.whiteListPatterns);
        sb.append(", policies=").append(this.policies);
        sb.append(", properties=").append(this.properties);
        sb.append(", disabled=").append(this.disabled);
        sb.append('}');
        return sb.toString();
    }
}

