package org.apache.archiva.admin.model.beans;
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.io.Serializable;

/**
 * @author Olivier Lamy
 * @since 1.4-M1
 */
public class AbstractRepository
    implements Serializable
{

    private String id;

    private String name;

    private String layout = "default";

    private String indexDirectory;

    /**
     * @since 1.4-M3
     */
    private String description;

    public AbstractRepository()
    {
        // no op
    }

    public AbstractRepository( String id, String name, String layout )
    {
        this.id = id;
        this.name = name;
        this.layout = layout;
    }

    public String getId()
    {
        return id;
    }

    public void setId( String id )
    {
        this.id = id;
    }

    public String getName()
    {
        return name;
    }

    public void setName( String name )
    {
        this.name = name;
    }

    public String getLayout()
    {
        return layout;
    }

    public void setLayout( String layout )
    {
        this.layout = layout;
    }



    public String getIndexDirectory()
    {
        return indexDirectory;
    }

    public void setIndexDirectory( String indexDirectory )
    {
        this.indexDirectory = indexDirectory;
    }

    public String getDescription()
    {
        return description;
    }

    public void setDescription( String description )
    {
        this.description = description;
    }

    @Override
    public int hashCode()
    {
        int result = 17;
        result = 37 * result + ( id != null ? id.hashCode() : 0 );
        return result;
    }

    @Override
    public boolean equals( Object other )
    {
        if ( this == other )
        {
            return true;
        }

        if ( !( other instanceof AbstractRepository ) )
        {
            return false;
        }

        AbstractRepository that = (AbstractRepository) other;
        boolean result = true;
        result = result && ( getId() == null ? that.getId() == null : getId().equals( that.getId() ) );
        return result;
    }

    @Override
    public String toString()
    {
        final StringBuilder sb = new StringBuilder();
        sb.append( "AbstractRepository" );
        sb.append( "{id='" ).append( id ).append( '\'' );
        sb.append( ", name='" ).append( name ).append( '\'' );
        sb.append( ", layout='" ).append( layout ).append( '\'' );
        sb.append( ", indexDirectory='" ).append( indexDirectory ).append( '\'' );
        sb.append( ", description='" ).append( description ).append( '\'' );
        sb.append( '}' );
        return sb.toString();
    }
}
