/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.admin.model.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.archiva.admin.model.beans.AbstractRepository;
import org.apache.archiva.admin.model.beans.PropertyEntry;
import org.apache.commons.lang.StringUtils;

@XmlRootElement(name="remoteRepository")
public class RemoteRepository
extends AbstractRepository
implements Serializable {
    private String url;
    private String userName;
    private String password;
    private int timeout = 60;
    private String checkPath;
    private boolean downloadRemoteIndex = false;
    private String remoteIndexUrl = ".index";
    private String remoteDownloadNetworkProxyId;
    private String cronExpression = "0 0 08 ? * SUN";
    private int remoteDownloadTimeout = 300;
    private boolean downloadRemoteIndexOnStartup = false;
    private Map<String, String> extraParameters;
    private List<PropertyEntry> extraParametersEntries;
    private Map<String, String> extraHeaders;
    private List<PropertyEntry> extraHeadersEntries;

    public RemoteRepository() {
    }

    public RemoteRepository(String id, String name, String url, String layout) {
        super(id, name, layout);
        this.url = url;
    }

    public RemoteRepository(String id, String name, String url, String layout, String userName, String password, int timeout) {
        super(id, name, layout);
        this.url = StringUtils.stripEnd((String)url, (String)"/");
        this.userName = userName;
        this.password = password;
        this.timeout = timeout;
    }

    public RemoteRepository(String id, String name, String url, String layout, String userName, String password, int timeout, String description) {
        this(id, name, url, layout, userName, password, timeout);
        this.setDescription(description);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = StringUtils.stripEnd((String)url, (String)"/");
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isDownloadRemoteIndex() {
        return this.downloadRemoteIndex;
    }

    public void setDownloadRemoteIndex(boolean downloadRemoteIndex) {
        this.downloadRemoteIndex = downloadRemoteIndex;
    }

    public String getRemoteIndexUrl() {
        return this.remoteIndexUrl;
    }

    public void setRemoteIndexUrl(String remoteIndexUrl) {
        this.remoteIndexUrl = remoteIndexUrl;
    }

    public String getRemoteDownloadNetworkProxyId() {
        return this.remoteDownloadNetworkProxyId;
    }

    public void setRemoteDownloadNetworkProxyId(String remoteDownloadNetworkProxyId) {
        this.remoteDownloadNetworkProxyId = remoteDownloadNetworkProxyId;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public int getRemoteDownloadTimeout() {
        return this.remoteDownloadTimeout;
    }

    public void setRemoteDownloadTimeout(int remoteDownloadTimeout) {
        this.remoteDownloadTimeout = remoteDownloadTimeout;
    }

    public boolean isDownloadRemoteIndexOnStartup() {
        return this.downloadRemoteIndexOnStartup;
    }

    public void setDownloadRemoteIndexOnStartup(boolean downloadRemoteIndexOnStartup) {
        this.downloadRemoteIndexOnStartup = downloadRemoteIndexOnStartup;
    }

    public Map<String, String> getExtraParameters() {
        if (this.extraParameters == null) {
            this.extraParameters = new HashMap<String, String>();
        }
        return this.extraParameters;
    }

    public void setExtraParameters(Map<String, String> extraParameters) {
        this.extraParameters = extraParameters;
    }

    public void addExtraParameter(String key, String value) {
        this.getExtraParameters().put(key, value);
    }

    public List<PropertyEntry> getExtraParametersEntries() {
        this.extraParametersEntries = new ArrayList<PropertyEntry>();
        for (Map.Entry<String, String> entry : this.getExtraParameters().entrySet()) {
            this.extraParametersEntries.add(new PropertyEntry(entry.getKey(), entry.getValue()));
        }
        return this.extraParametersEntries;
    }

    public void setExtraParametersEntries(List<PropertyEntry> extraParametersEntries) {
        if (extraParametersEntries == null) {
            return;
        }
        this.extraParametersEntries = extraParametersEntries;
        for (PropertyEntry propertyEntry : extraParametersEntries) {
            this.addExtraParameter(propertyEntry.getKey(), propertyEntry.getValue());
        }
    }

    public Map<String, String> getExtraHeaders() {
        if (this.extraHeaders == null) {
            this.extraHeaders = new HashMap<String, String>();
        }
        return this.extraHeaders;
    }

    public void setExtraHeaders(Map<String, String> extraHeaders) {
        this.extraHeaders = extraHeaders;
    }

    public void addExtraHeader(String key, String value) {
        this.getExtraHeaders().put(key, value);
    }

    public List<PropertyEntry> getExtraHeadersEntries() {
        this.extraHeadersEntries = new ArrayList<PropertyEntry>();
        for (Map.Entry<String, String> entry : this.getExtraHeaders().entrySet()) {
            this.extraHeadersEntries.add(new PropertyEntry(entry.getKey(), entry.getValue()));
        }
        return this.extraHeadersEntries;
    }

    public void setExtraHeadersEntries(List<PropertyEntry> extraHeadersEntries) {
        if (extraHeadersEntries == null) {
            return;
        }
        this.extraHeadersEntries = extraHeadersEntries;
        for (PropertyEntry propertyEntry : extraHeadersEntries) {
            this.addExtraHeader(propertyEntry.getKey(), propertyEntry.getValue());
        }
    }

    public void setCheckPath(String checkPath) {
        if (checkPath == null) {
            this.checkPath = "";
        } else if (checkPath.startsWith("/")) {
            this.checkPath = StringUtils.removeStart((String)checkPath, (String)"/");
            while (this.checkPath.startsWith("/")) {
                this.checkPath = StringUtils.removeStart((String)checkPath, (String)"/");
            }
        } else {
            this.checkPath = checkPath;
        }
    }

    public String getCheckPath() {
        return this.checkPath;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("RemoteRepository");
        sb.append("{url='").append(this.url).append('\'');
        sb.append(", userName='").append(this.userName).append('\'');
        sb.append(", password='").append(this.password).append('\'');
        sb.append(", timeout=").append(this.timeout);
        sb.append(", downloadRemoteIndex=").append(this.downloadRemoteIndex);
        sb.append(", remoteIndexUrl='").append(this.remoteIndexUrl).append('\'');
        sb.append(", remoteDownloadNetworkProxyId='").append(this.remoteDownloadNetworkProxyId).append('\'');
        sb.append(", cronExpression='").append(this.cronExpression).append('\'');
        sb.append(", remoteDownloadTimeout=").append(this.remoteDownloadTimeout);
        sb.append(", downloadRemoteIndexOnStartup=").append(this.downloadRemoteIndexOnStartup);
        sb.append(", extraParameters=").append(this.extraParameters);
        sb.append(", extraHeaders=").append(this.extraHeaders);
        sb.append(", checkPath=").append(this.checkPath);
        sb.append('}');
        return sb.toString();
    }
}

