/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.repository.content;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.archiva.common.utils.VersionUtil;

public class FilenameParser {
    private String name;
    private String extension;
    private int offset;
    private static final Pattern mavenPluginPattern = Pattern.compile("(maven-.*-plugin)|(.*-maven-plugin)");
    private static final Pattern extensionPattern = Pattern.compile("(\\.tar\\.gz$)|(\\.tar\\.bz2$)|(\\.[\\-a-z0-9]*$)", 2);
    private static final Pattern SNAPSHOT_PATTERN = Pattern.compile("^([0-9]{8}\\.[0-9]{6}-[0-9]+)(.*)$");
    private static final Pattern section = Pattern.compile("([^-]*)");
    private Matcher matcher;

    protected FilenameParser(String filename) {
        this.name = filename;
        Matcher mat = extensionPattern.matcher(this.name);
        if (mat.find()) {
            this.extension = filename.substring(mat.start() + 1);
            this.name = this.name.substring(0, this.name.length() - this.extension.length() - 1);
        }
        this.matcher = section.matcher(this.name);
        this.reset();
    }

    protected void reset() {
        this.offset = 0;
    }

    protected String next() {
        if (this.offset > this.name.length()) {
            return null;
        }
        if (this.matcher.find(this.offset)) {
            this.offset = this.matcher.end() + 1;
            return this.matcher.group();
        }
        return null;
    }

    protected String expect(String expected) {
        String value = null;
        if (this.name.startsWith(expected, this.offset)) {
            value = expected;
        } else if (VersionUtil.isGenericSnapshot((String)expected)) {
            Matcher m;
            String version = this.name.substring(this.offset);
            int leadingLength = expected.length() - 9;
            if (leadingLength > 0 && version.startsWith(expected.substring(0, leadingLength)) && version.length() > leadingLength && (m = SNAPSHOT_PATTERN.matcher(version.substring(leadingLength + 1))).matches()) {
                value = version.substring(0, leadingLength + 1) + m.group(1);
            }
        }
        if (value != null) {
            int seperatorOffset = this.offset + value.length();
            if (seperatorOffset >= this.name.length()) {
                this.offset = this.name.length();
                return value;
            }
            char seperatorChar = this.name.charAt(seperatorOffset);
            if (seperatorChar == '-' || seperatorChar == '.') {
                this.offset = seperatorOffset + 1;
                return value;
            }
        }
        return null;
    }

    protected char seperator() {
        if (this.offset >= this.name.length()) {
            return '\u0000';
        }
        if (this.offset <= 0) {
            return '\u0000';
        }
        return this.name.charAt(this.offset - 1);
    }

    protected String getName() {
        return this.name;
    }

    protected String getExtension() {
        return this.extension;
    }

    protected String remaining() {
        if (this.offset >= this.name.length()) {
            return null;
        }
        String end = this.name.substring(this.offset);
        this.offset = this.name.length();
        return end;
    }

    protected String nextNonVersion() {
        boolean done = false;
        StringBuilder ver = new StringBuilder();
        Matcher specialMat = mavenPluginPattern.matcher(this.name);
        if (specialMat.find()) {
            ver.append(this.name.substring(this.offset, specialMat.end()));
            this.offset = specialMat.end() + 1;
        }
        while (!done) {
            int initialOffset = this.offset;
            String section = this.next();
            if (section == null) {
                done = true;
                continue;
            }
            if (!VersionUtil.isVersion((String)section)) {
                if (ver.length() > 0) {
                    ver.append('-');
                }
                ver.append(section);
                continue;
            }
            this.offset = initialOffset;
            done = true;
        }
        return ver.toString();
    }

    protected String nextVersion() {
        boolean done = false;
        StringBuilder ver = new StringBuilder();
        while (!done) {
            int initialOffset = this.offset;
            String section = this.next();
            if (section == null) {
                done = true;
                continue;
            }
            if (VersionUtil.isVersion((String)section)) {
                if (ver.length() > 0) {
                    ver.append('-');
                }
                ver.append(section);
                continue;
            }
            this.offset = initialOffset;
            done = true;
        }
        return ver.toString();
    }
}

