/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.repository.content;

import java.util.List;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.LegacyArtifactPath;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.repository.content.ArtifactClassifierMapping;
import org.apache.archiva.repository.content.ArtifactExtensionMapping;
import org.apache.archiva.repository.content.FilenameParser;
import org.apache.archiva.repository.content.PathParser;
import org.apache.archiva.repository.layout.LayoutException;
import org.apache.commons.lang.StringUtils;

public class LegacyPathParser
implements PathParser {
    private static final String INVALID_ARTIFACT_PATH = "Invalid path to Artifact: ";
    protected ArchivaConfiguration configuration;

    public LegacyPathParser(ArchivaConfiguration configuration) {
        this.configuration = configuration;
    }

    public ArtifactReference toArtifactReference(String path) throws LayoutException {
        String classifier;
        ArtifactReference artifact = new ArtifactReference();
        List legacy = this.configuration.getConfiguration().getLegacyArtifactPaths();
        for (LegacyArtifactPath legacyPath : legacy) {
            if (!legacyPath.match(path)) continue;
            artifact.setGroupId(legacyPath.getGroupId());
            artifact.setArtifactId(legacyPath.getArtifactId());
            artifact.setClassifier(legacyPath.getClassifier());
            artifact.setVersion(legacyPath.getVersion());
            artifact.setType(legacyPath.getType());
            return artifact;
        }
        String normalizedPath = StringUtils.replace((String)path, (String)"\\", (String)"/");
        String[] pathParts = StringUtils.split((String)normalizedPath, (char)'/');
        if (pathParts.length != 3) {
            throw new LayoutException("Invalid path to Artifact: legacy paths should only have 3 parts [groupId]/[type]s/[artifactId]-[version].[type], found " + pathParts.length + " instead.");
        }
        artifact.setGroupId(pathParts[0]);
        String expectedType = pathParts[1];
        if (!expectedType.endsWith("s")) {
            throw new LayoutException("Invalid path to Artifact: legacy paths should have an expected type ending in [s] in the second part of the path.");
        }
        String filename = pathParts[2];
        FilenameParser parser = new FilenameParser(filename);
        artifact.setArtifactId(parser.nextNonVersion());
        if (StringUtils.isEmpty((String)artifact.getArtifactId())) {
            int idx = filename.indexOf(45);
            if (idx > 0) {
                parser.reset();
                String artifactId = parser.next();
                String moreArtifactId = parser.nextNonVersion();
                if (StringUtils.isNotBlank((String)moreArtifactId)) {
                    artifact.setArtifactId(artifactId + "-" + moreArtifactId);
                } else {
                    artifact.setArtifactId(artifactId);
                }
            }
            if (StringUtils.isEmpty((String)artifact.getArtifactId())) {
                throw new LayoutException("Invalid path to Artifact: no artifact id present.");
            }
        }
        artifact.setVersion(parser.remaining());
        if (StringUtils.isEmpty((String)artifact.getVersion())) {
            String artifactId = artifact.getArtifactId();
            int idx = artifactId.lastIndexOf(45);
            if (idx > 0) {
                artifact.setVersion(artifactId.substring(idx + 1));
                artifact.setArtifactId(artifactId.substring(0, idx));
            } else {
                throw new LayoutException("Invalid path to Artifact: no version found.");
            }
        }
        if ((classifier = ArtifactClassifierMapping.getClassifier(expectedType)) != null) {
            String version = artifact.getVersion();
            if (!version.endsWith("-" + classifier)) {
                throw new LayoutException(INVALID_ARTIFACT_PATH + expectedType + " artifacts must use the classifier " + classifier);
            }
            version = version.substring(0, version.length() - classifier.length() - 1);
            artifact.setVersion(version);
            artifact.setClassifier(classifier);
        }
        String extension = parser.getExtension();
        String defaultExtension = expectedType.substring(0, expectedType.length() - 1);
        artifact.setType(ArtifactExtensionMapping.mapExtensionAndClassifierToType(classifier, extension, defaultExtension));
        if (StringUtils.isEmpty((String)artifact.getType())) {
            throw new LayoutException("Invalid path to Artifact: no extension found.");
        }
        if (StringUtils.equals((String)"jar", (String)extension) && StringUtils.equals((String)"plugins", (String)expectedType)) {
            artifact.setType("maven-one-plugin");
        } else {
            String expectedExtension = ArtifactExtensionMapping.getExtension(artifact.getType());
            if (!expectedExtension.equals(extension)) {
                throw new LayoutException("Invalid path to Artifact: mismatch on extension [" + extension + "] and layout specified type [" + artifact.getType() + "] (which maps to extension: [" + expectedExtension + "]) on path [" + path + "]");
            }
        }
        return artifact;
    }
}

