/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.repository.content;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.common.utils.PathUtil;
import org.apache.archiva.configuration.FileTypes;
import org.apache.archiva.metadata.repository.storage.maven2.DefaultArtifactMappingProvider;
import org.apache.archiva.model.ArchivaArtifact;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.model.ProjectReference;
import org.apache.archiva.model.VersionedReference;
import org.apache.archiva.repository.ContentNotFoundException;
import org.apache.archiva.repository.ManagedRepositoryContent;
import org.apache.archiva.repository.content.AbstractDefaultRepositoryContent;
import org.apache.archiva.repository.layout.LayoutException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="managedRepositoryContent#default")
@Scope(value="prototype")
public class ManagedDefaultRepositoryContent
extends AbstractDefaultRepositoryContent
implements ManagedRepositoryContent {
    @Inject
    @Named(value="fileTypes")
    private FileTypes filetypes;
    private ManagedRepository repository;

    public ManagedDefaultRepositoryContent() {
        this.artifactMappingProviders = Collections.singletonList(new DefaultArtifactMappingProvider());
    }

    @Override
    public void deleteVersion(VersionedReference reference) {
        String path = this.toMetadataPath(reference);
        File projectPath = new File(this.getRepoRoot(), path);
        File projectDir = projectPath.getParentFile();
        if (projectDir.exists() && projectDir.isDirectory()) {
            FileUtils.deleteQuietly((File)projectDir);
        }
    }

    @Override
    public void deleteArtifact(ArtifactReference artifactReference) {
        File filePathsha1;
        File filePathmd5;
        String path = this.toPath(artifactReference);
        File filePath = new File(this.getRepoRoot(), path);
        if (filePath.exists()) {
            FileUtils.deleteQuietly((File)filePath);
        }
        if ((filePathmd5 = new File(this.getRepoRoot(), path + ".md5")).exists()) {
            FileUtils.deleteQuietly((File)filePathmd5);
        }
        if ((filePathsha1 = new File(this.getRepoRoot(), path + ".sha1")).exists()) {
            FileUtils.deleteQuietly((File)filePathsha1);
        }
    }

    @Override
    public void deleteGroupId(String groupId) throws ContentNotFoundException {
        String path = StringUtils.replaceChars((String)groupId, (char)'.', (char)'/');
        File directory = new File(this.getRepoRoot(), path);
        if (directory.exists()) {
            try {
                FileUtils.deleteDirectory((File)directory);
            }
            catch (IOException e) {
                this.log.warn("skip error deleting directory {}:", (Object)directory.getPath(), (Object)e);
            }
        }
    }

    @Override
    public String getId() {
        return this.repository.getId();
    }

    @Override
    public Set<ArtifactReference> getRelatedArtifacts(ArtifactReference reference) throws ContentNotFoundException {
        File artifactFile = this.toFile(reference);
        File repoDir = artifactFile.getParentFile();
        if (!repoDir.exists()) {
            throw new ContentNotFoundException("Unable to get related artifacts using a non-existant directory: " + repoDir.getAbsolutePath());
        }
        if (!repoDir.isDirectory()) {
            throw new ContentNotFoundException("Unable to get related artifacts using a non-directory: " + repoDir.getAbsolutePath());
        }
        HashSet<ArtifactReference> foundArtifacts = new HashSet<ArtifactReference>();
        File[] repoFiles = repoDir.listFiles();
        for (int i = 0; i < repoFiles.length; ++i) {
            String relativePath;
            if (repoFiles[i].isDirectory() || !this.filetypes.matchesArtifactPattern(relativePath = PathUtil.getRelative((String)this.repository.getLocation(), (File)repoFiles[i]))) continue;
            try {
                ArtifactReference artifact = this.toArtifactReference(relativePath);
                if (!artifact.getGroupId().equals(reference.getGroupId()) || !artifact.getArtifactId().equals(reference.getArtifactId()) || !artifact.getVersion().equals(reference.getVersion())) continue;
                foundArtifacts.add(artifact);
                continue;
            }
            catch (LayoutException e) {
                this.log.debug("Not processing file that is not an artifact: {}", (Object)e.getMessage());
            }
        }
        return foundArtifacts;
    }

    @Override
    public String getRepoRoot() {
        return this.repository.getLocation();
    }

    @Override
    public ManagedRepository getRepository() {
        return this.repository;
    }

    @Override
    public Set<String> getVersions(ProjectReference reference) throws ContentNotFoundException, LayoutException {
        File repoDir;
        String path = this.toMetadataPath(reference);
        int idx = path.lastIndexOf(47);
        if (idx > 0) {
            path = path.substring(0, idx);
        }
        if (!(repoDir = new File(this.repository.getLocation(), path)).exists()) {
            throw new ContentNotFoundException("Unable to get Versions on a non-existant directory: " + repoDir.getAbsolutePath());
        }
        if (!repoDir.isDirectory()) {
            throw new ContentNotFoundException("Unable to get Versions on a non-directory: " + repoDir.getAbsolutePath());
        }
        HashSet<String> foundVersions = new HashSet<String>();
        VersionedReference versionRef = new VersionedReference();
        versionRef.setGroupId(reference.getGroupId());
        versionRef.setArtifactId(reference.getArtifactId());
        File[] repoFiles = repoDir.listFiles();
        for (int i = 0; i < repoFiles.length; ++i) {
            if (!repoFiles[i].isDirectory()) continue;
            String version = repoFiles[i].getName();
            versionRef.setVersion(version);
            if (!this.hasArtifact(versionRef)) continue;
            foundVersions.add(version);
        }
        return foundVersions;
    }

    @Override
    public Set<String> getVersions(VersionedReference reference) throws ContentNotFoundException {
        File repoDir;
        String path = this.toMetadataPath(reference);
        int idx = path.lastIndexOf(47);
        if (idx > 0) {
            path = path.substring(0, idx);
        }
        if (!(repoDir = new File(this.repository.getLocation(), path)).exists()) {
            throw new ContentNotFoundException("Unable to get versions on a non-existant directory: " + repoDir.getAbsolutePath());
        }
        if (!repoDir.isDirectory()) {
            throw new ContentNotFoundException("Unable to get versions on a non-directory: " + repoDir.getAbsolutePath());
        }
        HashSet<String> foundVersions = new HashSet<String>();
        File[] repoFiles = repoDir.listFiles();
        for (int i = 0; i < repoFiles.length; ++i) {
            String relativePath;
            if (repoFiles[i].isDirectory() || this.filetypes.matchesDefaultExclusions(relativePath = PathUtil.getRelative((String)this.repository.getLocation(), (File)repoFiles[i])) || !this.filetypes.matchesArtifactPattern(relativePath)) continue;
            try {
                ArtifactReference artifact = this.toArtifactReference(relativePath);
                foundVersions.add(artifact.getVersion());
                continue;
            }
            catch (LayoutException e) {
                this.log.debug("Not processing file that is not an artifact: {}", (Object)e.getMessage());
            }
        }
        return foundVersions;
    }

    @Override
    public boolean hasContent(ArtifactReference reference) {
        File artifactFile = this.toFile(reference);
        return artifactFile.exists() && artifactFile.isFile();
    }

    @Override
    public boolean hasContent(ProjectReference reference) {
        try {
            Set<String> versions = this.getVersions(reference);
            return !versions.isEmpty();
        }
        catch (ContentNotFoundException e) {
            return false;
        }
        catch (LayoutException e) {
            return false;
        }
    }

    @Override
    public boolean hasContent(VersionedReference reference) {
        try {
            return this.getFirstArtifact(reference) != null;
        }
        catch (IOException e) {
            return false;
        }
        catch (LayoutException e) {
            return false;
        }
    }

    @Override
    public void setRepository(ManagedRepository repository) {
        this.repository = repository;
    }

    @Override
    public ArtifactReference toArtifactReference(String path) throws LayoutException {
        if (path != null && path.startsWith(this.repository.getLocation()) && this.repository.getLocation().length() > 0) {
            return super.toArtifactReference(path.substring(this.repository.getLocation().length() + 1));
        }
        return super.toArtifactReference(path);
    }

    @Override
    public File toFile(ArtifactReference reference) {
        return new File(this.repository.getLocation(), this.toPath(reference));
    }

    @Override
    public File toFile(ArchivaArtifact reference) {
        return new File(this.repository.getLocation(), this.toPath(reference));
    }

    private ArtifactReference getFirstArtifact(VersionedReference reference) throws LayoutException, IOException {
        File repoDir;
        String path = this.toMetadataPath(reference);
        int idx = path.lastIndexOf(47);
        if (idx > 0) {
            path = path.substring(0, idx);
        }
        if (!(repoDir = new File(this.repository.getLocation(), path)).exists()) {
            throw new IOException("Unable to gather the list of snapshot versions on a non-existant directory: " + repoDir.getAbsolutePath());
        }
        if (!repoDir.isDirectory()) {
            throw new IOException("Unable to gather the list of snapshot versions on a non-directory: " + repoDir.getAbsolutePath());
        }
        File[] repoFiles = repoDir.listFiles();
        for (int i = 0; i < repoFiles.length; ++i) {
            String relativePath;
            if (repoFiles[i].isDirectory() || !this.filetypes.matchesArtifactPattern(relativePath = PathUtil.getRelative((String)this.repository.getLocation(), (File)repoFiles[i]))) continue;
            ArtifactReference artifact = this.toArtifactReference(relativePath);
            return artifact;
        }
        return null;
    }

    private boolean hasArtifact(VersionedReference reference) throws LayoutException {
        try {
            return this.getFirstArtifact(reference) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void setFiletypes(FileTypes filetypes) {
        this.filetypes = filetypes;
    }
}

