/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.repository.content;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.common.utils.PathUtil;
import org.apache.archiva.configuration.FileTypes;
import org.apache.archiva.model.ArchivaArtifact;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.model.ProjectReference;
import org.apache.archiva.model.VersionedReference;
import org.apache.archiva.repository.ContentNotFoundException;
import org.apache.archiva.repository.ManagedRepositoryContent;
import org.apache.archiva.repository.content.AbstractLegacyRepositoryContent;
import org.apache.archiva.repository.layout.LayoutException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="managedRepositoryContent#legacy")
@Scope(value="prototype")
public class ManagedLegacyRepositoryContent
extends AbstractLegacyRepositoryContent
implements ManagedRepositoryContent {
    @Inject
    private FileTypes filetypes;
    private ManagedRepository repository;

    @Override
    public void deleteVersion(VersionedReference reference) throws ContentNotFoundException {
        File[] typeDirs;
        File groupDir = new File(this.repository.getLocation(), reference.getGroupId());
        if (!groupDir.exists()) {
            throw new ContentNotFoundException("Unable to get versions using a non-existant groupId directory: " + groupDir.getAbsolutePath());
        }
        if (!groupDir.isDirectory()) {
            throw new ContentNotFoundException("Unable to get versions using a non-directory: " + groupDir.getAbsolutePath());
        }
        for (File typeDir : typeDirs = groupDir.listFiles()) {
            if (!typeDir.isDirectory()) continue;
            if (!typeDir.getName().endsWith("s")) {
                // empty if block
            }
            this.deleteVersions(typeDir, reference);
        }
    }

    private void deleteVersions(File typeDir, VersionedReference reference) {
        File[] repoFiles;
        for (File repoFile : repoFiles = typeDir.listFiles()) {
            String relativePath;
            if (repoFile.isDirectory() || !this.filetypes.matchesArtifactPattern(relativePath = PathUtil.getRelative((String)this.repository.getLocation(), (File)repoFile))) continue;
            try {
                ArtifactReference artifact = this.toArtifactReference(relativePath);
                if (!StringUtils.equals((String)artifact.getArtifactId(), (String)reference.getArtifactId()) || !StringUtils.equals((String)artifact.getVersion(), (String)reference.getVersion())) continue;
                repoFile.delete();
                this.deleteSupportFiles(repoFile);
            }
            catch (LayoutException e) {
                // empty catch block
            }
        }
    }

    private void deleteSupportFiles(File repoFile) {
        this.deleteSupportFile(repoFile, ".sha1");
        this.deleteSupportFile(repoFile, ".md5");
        this.deleteSupportFile(repoFile, ".asc");
        this.deleteSupportFile(repoFile, ".gpg");
    }

    private void deleteSupportFile(File repoFile, String supportExtension) {
        File supportFile = new File(repoFile.getAbsolutePath() + supportExtension);
        if (supportFile.exists() && supportFile.isFile()) {
            supportFile.delete();
        }
    }

    @Override
    public String getId() {
        return this.repository.getId();
    }

    @Override
    public Set<ArtifactReference> getRelatedArtifacts(ArtifactReference reference) throws ContentNotFoundException {
        File[] typeDirs;
        File artifactFile = this.toFile(reference);
        File repoDir = artifactFile.getParentFile();
        if (!repoDir.exists()) {
            throw new ContentNotFoundException("Unable to get related artifacts using a non-existant directory: " + repoDir.getAbsolutePath());
        }
        if (!repoDir.isDirectory()) {
            throw new ContentNotFoundException("Unable to get related artifacts using a non-directory: " + repoDir.getAbsolutePath());
        }
        HashSet<ArtifactReference> foundArtifacts = new HashSet<ArtifactReference>();
        File projectParentDir = repoDir.getParentFile();
        for (File typeDir : typeDirs = projectParentDir.listFiles()) {
            if (!typeDir.isDirectory()) continue;
            if (!typeDir.getName().endsWith("s")) {
                // empty if block
            }
            this.getRelatedArtifacts(typeDir, reference, foundArtifacts);
        }
        return foundArtifacts;
    }

    @Override
    public String getRepoRoot() {
        return this.repository.getLocation();
    }

    @Override
    public ManagedRepository getRepository() {
        return this.repository;
    }

    @Override
    public Set<String> getVersions(ProjectReference reference) throws ContentNotFoundException {
        File[] typeDirs;
        File groupDir = new File(this.repository.getLocation(), reference.getGroupId());
        if (!groupDir.exists()) {
            throw new ContentNotFoundException("Unable to get versions using a non-existant groupId directory: " + groupDir.getAbsolutePath());
        }
        if (!groupDir.isDirectory()) {
            throw new ContentNotFoundException("Unable to get versions using a non-directory: " + groupDir.getAbsolutePath());
        }
        HashSet<String> foundVersions = new HashSet<String>();
        for (File typeDir : typeDirs = groupDir.listFiles()) {
            if (!typeDir.isDirectory()) continue;
            if (!typeDir.getName().endsWith("s")) {
                // empty if block
            }
            this.getProjectVersions(typeDir, reference, foundVersions);
        }
        return foundVersions;
    }

    @Override
    public Set<String> getVersions(VersionedReference reference) throws ContentNotFoundException {
        File[] typeDirs;
        File groupDir = new File(this.repository.getLocation(), reference.getGroupId());
        if (!groupDir.exists()) {
            throw new ContentNotFoundException("Unable to get versions using a non-existant groupId directory: " + groupDir.getAbsolutePath());
        }
        if (!groupDir.isDirectory()) {
            throw new ContentNotFoundException("Unable to get versions using a non-directory: " + groupDir.getAbsolutePath());
        }
        HashSet<String> foundVersions = new HashSet<String>();
        for (File typeDir : typeDirs = groupDir.listFiles()) {
            if (!typeDir.isDirectory()) continue;
            if (!typeDir.getName().endsWith("s")) {
                // empty if block
            }
            this.getVersionedVersions(typeDir, reference, foundVersions);
        }
        return foundVersions;
    }

    @Override
    public boolean hasContent(ArtifactReference reference) {
        File artifactFile = this.toFile(reference);
        return artifactFile.exists() && artifactFile.isFile();
    }

    @Override
    public boolean hasContent(ProjectReference reference) {
        try {
            Set<String> versions = this.getVersions(reference);
            return CollectionUtils.isNotEmpty(versions);
        }
        catch (ContentNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean hasContent(VersionedReference reference) {
        try {
            Set<String> versions = this.getVersions(reference);
            return CollectionUtils.isNotEmpty(versions);
        }
        catch (ContentNotFoundException e) {
            return false;
        }
    }

    @Override
    public void setRepository(ManagedRepository repository) {
        this.repository = repository;
    }

    @Override
    public ArtifactReference toArtifactReference(String path) throws LayoutException {
        if (path != null && path.startsWith(this.repository.getLocation())) {
            return super.toArtifactReference(path.substring(this.repository.getLocation().length()));
        }
        return super.toArtifactReference(path);
    }

    @Override
    public File toFile(ArchivaArtifact reference) {
        return new File(this.repository.getLocation(), this.toPath(reference));
    }

    @Override
    public File toFile(ArtifactReference reference) {
        return new File(this.repository.getLocation(), this.toPath(reference));
    }

    @Override
    public String toMetadataPath(ProjectReference reference) {
        return null;
    }

    @Override
    public String toMetadataPath(VersionedReference reference) {
        return null;
    }

    private void getProjectVersions(File typeDir, ProjectReference reference, Set<String> foundVersions) {
        File[] repoFiles;
        for (File repoFile : repoFiles = typeDir.listFiles()) {
            String relativePath;
            if (repoFile.isDirectory() || !this.filetypes.matchesArtifactPattern(relativePath = PathUtil.getRelative((String)this.repository.getLocation(), (File)repoFile))) continue;
            try {
                ArtifactReference artifact = this.toArtifactReference(relativePath);
                if (!StringUtils.equals((String)artifact.getArtifactId(), (String)reference.getArtifactId())) continue;
                foundVersions.add(artifact.getVersion());
            }
            catch (LayoutException e) {
                // empty catch block
            }
        }
    }

    private void getRelatedArtifacts(File typeDir, ArtifactReference reference, Set<ArtifactReference> foundArtifacts) {
        File[] repoFiles = typeDir.listFiles();
        for (int i = 0; i < repoFiles.length; ++i) {
            String relativePath;
            if (repoFiles[i].isDirectory() || !this.filetypes.matchesArtifactPattern(relativePath = PathUtil.getRelative((String)this.repository.getLocation(), (File)repoFiles[i]))) continue;
            try {
                ArtifactReference artifact = this.toArtifactReference(relativePath);
                if (!StringUtils.equals((String)artifact.getArtifactId(), (String)reference.getArtifactId()) || !artifact.getVersion().startsWith(reference.getVersion())) continue;
                foundArtifacts.add(artifact);
                continue;
            }
            catch (LayoutException e) {
                // empty catch block
            }
        }
    }

    private void getVersionedVersions(File typeDir, VersionedReference reference, Set<String> foundVersions) {
        File[] repoFiles = typeDir.listFiles();
        for (int i = 0; i < repoFiles.length; ++i) {
            String relativePath;
            if (repoFiles[i].isDirectory() || !this.filetypes.matchesArtifactPattern(relativePath = PathUtil.getRelative((String)this.repository.getLocation(), (File)repoFiles[i]))) continue;
            try {
                ArtifactReference artifact = this.toArtifactReference(relativePath);
                if (!StringUtils.equals((String)artifact.getArtifactId(), (String)reference.getArtifactId()) || !artifact.getVersion().startsWith(reference.getVersion())) continue;
                foundVersions.add(artifact.getVersion());
                continue;
            }
            catch (LayoutException e) {
                // empty catch block
            }
        }
    }

    public void setFileTypes(FileTypes fileTypes) {
        this.filetypes = fileTypes;
    }

    @Override
    public void deleteArtifact(ArtifactReference artifactReference) throws ContentNotFoundException {
    }

    @Override
    public void deleteGroupId(String groupId) throws ContentNotFoundException {
    }
}

