/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.repository.content;

import org.apache.archiva.admin.model.beans.RemoteRepository;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.model.RepositoryURL;
import org.apache.archiva.repository.RemoteRepositoryContent;
import org.apache.archiva.repository.content.AbstractLegacyRepositoryContent;
import org.apache.archiva.repository.layout.LayoutException;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="remoteRepositoryContent#legacy")
@Scope(value="prototype")
public class RemoteLegacyRepositoryContent
extends AbstractLegacyRepositoryContent
implements RemoteRepositoryContent {
    private RemoteRepository repository;

    public String getId() {
        return this.repository.getId();
    }

    public RemoteRepository getRepository() {
        return this.repository;
    }

    public RepositoryURL getURL() {
        return new RepositoryURL(this.repository.getUrl());
    }

    public void setRepository(RemoteRepository repository) {
        this.repository = repository;
    }

    public ArtifactReference toArtifactReference(String path) throws LayoutException {
        if (path.startsWith(this.repository.getUrl())) {
            return super.toArtifactReference(path.substring(this.repository.getUrl().length()));
        }
        return super.toArtifactReference(path);
    }

    public RepositoryURL toURL(ArtifactReference reference) {
        String url = this.repository.getUrl() + this.toPath(reference);
        return new RepositoryURL(url);
    }
}

