/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.repository.metadata;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import org.apache.archiva.model.ArchivaRepositoryMetadata;
import org.apache.archiva.model.Plugin;
import org.apache.archiva.repository.metadata.RepositoryMetadataException;
import org.apache.archiva.xml.XMLException;
import org.apache.archiva.xml.XMLWriter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class RepositoryMetadataWriter {
    public static void write(ArchivaRepositoryMetadata metadata, File outputFile) throws RepositoryMetadataException {
        boolean thrown = false;
        FileWriter writer = null;
        try {
            writer = new FileWriter(outputFile);
            RepositoryMetadataWriter.write(metadata, writer);
            writer.flush();
        }
        catch (IOException e) {
            try {
                thrown = true;
                throw new RepositoryMetadataException("Unable to write metadata file: " + outputFile.getAbsolutePath() + " - " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                if (thrown) {
                    FileUtils.deleteQuietly((File)outputFile);
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        if (thrown) {
            FileUtils.deleteQuietly((File)outputFile);
        }
    }

    public static void write(ArchivaRepositoryMetadata metadata, Writer writer) throws RepositoryMetadataException {
        Document doc = DocumentHelper.createDocument();
        Element root = DocumentHelper.createElement((String)"metadata");
        doc.setRootElement(root);
        RepositoryMetadataWriter.addOptionalElementText(root, "groupId", metadata.getGroupId());
        RepositoryMetadataWriter.addOptionalElementText(root, "artifactId", metadata.getArtifactId());
        RepositoryMetadataWriter.addOptionalElementText(root, "version", metadata.getVersion());
        if (CollectionUtils.isNotEmpty((Collection)metadata.getPlugins())) {
            Element plugins = root.addElement("plugins");
            for (Plugin plugin : metadata.getPlugins()) {
                Element p = plugins.addElement("plugin");
                p.addElement("prefix").setText(plugin.getPrefix());
                p.addElement("artifactId").setText(plugin.getArtifactId());
                RepositoryMetadataWriter.addOptionalElementText(p, "name", plugin.getName());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)metadata.getAvailableVersions()) || StringUtils.isNotBlank((String)metadata.getReleasedVersion()) || StringUtils.isNotBlank((String)metadata.getLatestVersion()) || StringUtils.isNotBlank((String)metadata.getLastUpdated()) || metadata.getSnapshotVersion() != null) {
            Element versioning = root.addElement("versioning");
            RepositoryMetadataWriter.addOptionalElementText(versioning, "latest", metadata.getLatestVersion());
            RepositoryMetadataWriter.addOptionalElementText(versioning, "release", metadata.getReleasedVersion());
            if (metadata.getSnapshotVersion() != null) {
                Element snapshot = versioning.addElement("snapshot");
                String bnum = String.valueOf(metadata.getSnapshotVersion().getBuildNumber());
                RepositoryMetadataWriter.addOptionalElementText(snapshot, "buildNumber", bnum);
                RepositoryMetadataWriter.addOptionalElementText(snapshot, "timestamp", metadata.getSnapshotVersion().getTimestamp());
            }
            if (CollectionUtils.isNotEmpty((Collection)metadata.getAvailableVersions())) {
                Element versions = versioning.addElement("versions");
                for (String version : metadata.getAvailableVersions()) {
                    versions.addElement("version").setText(version);
                }
            }
            RepositoryMetadataWriter.addOptionalElementText(versioning, "lastUpdated", metadata.getLastUpdated());
        }
        try {
            XMLWriter.write((Document)doc, (Writer)writer);
        }
        catch (XMLException e) {
            throw new RepositoryMetadataException("Unable to write xml contents to writer: " + e.getMessage(), e);
        }
    }

    private static void addOptionalElementText(Element elem, String elemName, String text) {
        if (StringUtils.isBlank((String)text)) {
            return;
        }
        elem.addElement(elemName).setText(text);
    }
}

