/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.repository.scanner;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.admin.ArchivaAdministration;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.common.utils.BaseFile;
import org.apache.archiva.consumers.InvalidRepositoryContentConsumer;
import org.apache.archiva.consumers.KnownRepositoryContentConsumer;
import org.apache.archiva.consumers.functors.ConsumerWantsFilePredicate;
import org.apache.archiva.repository.scanner.functors.ConsumerProcessFileClosure;
import org.apache.archiva.repository.scanner.functors.TriggerBeginScanClosure;
import org.apache.archiva.repository.scanner.functors.TriggerScanCompletedClosure;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.IfClosure;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="repositoryContentConsumers")
public class RepositoryContentConsumers
implements ApplicationContextAware {
    @Inject
    private ApplicationContext applicationContext;
    private ArchivaAdministration archivaAdministration;
    private List<KnownRepositoryContentConsumer> selectedKnownConsumers;
    private List<InvalidRepositoryContentConsumer> selectedInvalidConsumers;

    @Inject
    public RepositoryContentConsumers(ArchivaAdministration archivaAdministration) {
        this.archivaAdministration = archivaAdministration;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public List<String> getSelectedKnownConsumerIds() throws RepositoryAdminException {
        return this.archivaAdministration.getKnownContentConsumers();
    }

    public List<String> getSelectedInvalidConsumerIds() throws RepositoryAdminException {
        return this.archivaAdministration.getInvalidContentConsumers();
    }

    public Map<String, KnownRepositoryContentConsumer> getSelectedKnownConsumersMap() throws RepositoryAdminException {
        HashMap<String, KnownRepositoryContentConsumer> consumerMap = new HashMap<String, KnownRepositoryContentConsumer>();
        for (KnownRepositoryContentConsumer consumer : this.getSelectedKnownConsumers()) {
            consumerMap.put(consumer.getId(), consumer);
        }
        return consumerMap;
    }

    public Map<String, InvalidRepositoryContentConsumer> getSelectedInvalidConsumersMap() throws RepositoryAdminException {
        HashMap<String, InvalidRepositoryContentConsumer> consumerMap = new HashMap<String, InvalidRepositoryContentConsumer>();
        for (InvalidRepositoryContentConsumer consumer : this.getSelectedInvalidConsumers()) {
            consumerMap.put(consumer.getId(), consumer);
        }
        return consumerMap;
    }

    public synchronized List<KnownRepositoryContentConsumer> getSelectedKnownConsumers() throws RepositoryAdminException {
        if (this.selectedKnownConsumers != null) {
            return this.selectedKnownConsumers;
        }
        ArrayList<KnownRepositoryContentConsumer> ret = new ArrayList<KnownRepositoryContentConsumer>();
        List<String> knownSelected = this.getSelectedKnownConsumerIds();
        for (KnownRepositoryContentConsumer consumer : this.getAvailableKnownConsumers()) {
            if (!knownSelected.contains(consumer.getId()) && !consumer.isPermanent()) continue;
            ret.add(consumer);
        }
        return ret;
    }

    public synchronized List<InvalidRepositoryContentConsumer> getSelectedInvalidConsumers() throws RepositoryAdminException {
        if (this.selectedInvalidConsumers != null) {
            return this.selectedInvalidConsumers;
        }
        ArrayList<InvalidRepositoryContentConsumer> ret = new ArrayList<InvalidRepositoryContentConsumer>();
        List<String> invalidSelected = this.getSelectedInvalidConsumerIds();
        for (InvalidRepositoryContentConsumer consumer : this.getAvailableInvalidConsumers()) {
            if (!invalidSelected.contains(consumer.getId()) && !consumer.isPermanent()) continue;
            ret.add(consumer);
        }
        return ret;
    }

    public List<KnownRepositoryContentConsumer> getAvailableKnownConsumers() {
        return new ArrayList<KnownRepositoryContentConsumer>(this.applicationContext.getBeansOfType(KnownRepositoryContentConsumer.class).values());
    }

    public List<InvalidRepositoryContentConsumer> getAvailableInvalidConsumers() {
        return new ArrayList<InvalidRepositoryContentConsumer>(this.applicationContext.getBeansOfType(InvalidRepositoryContentConsumer.class).values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeConsumers(ManagedRepository repository, File localFile, boolean updateRelatedArtifacts) throws RepositoryAdminException {
        TriggerBeginScanClosure triggerBeginScan = new TriggerBeginScanClosure(repository, this.getStartTime(), false);
        List<KnownRepositoryContentConsumer> selectedKnownConsumers = this.getSelectedKnownConsumers();
        if (!updateRelatedArtifacts) {
            ArrayList<KnownRepositoryContentConsumer> clone = new ArrayList<KnownRepositoryContentConsumer>();
            clone.addAll(selectedKnownConsumers);
            for (KnownRepositoryContentConsumer consumer : clone) {
                if (!consumer.getId().equals("create-missing-checksums") && !consumer.getId().equals("metadata-updater")) continue;
                selectedKnownConsumers.remove(consumer);
            }
        }
        List<InvalidRepositoryContentConsumer> selectedInvalidConsumers = this.getSelectedInvalidConsumers();
        CollectionUtils.forAllDo(selectedKnownConsumers, (Closure)triggerBeginScan);
        CollectionUtils.forAllDo(selectedInvalidConsumers, (Closure)triggerBeginScan);
        BaseFile baseFile = new BaseFile(repository.getLocation(), localFile);
        ConsumerWantsFilePredicate predicate = new ConsumerWantsFilePredicate();
        predicate.setBasefile(baseFile);
        predicate.setCaseSensitive(false);
        ConsumerProcessFileClosure closure = new ConsumerProcessFileClosure();
        closure.setBasefile(baseFile);
        closure.setExecuteOnEntireRepo(false);
        Closure processIfWanted = IfClosure.getInstance((Predicate)predicate, (Closure)closure);
        CollectionUtils.forAllDo(selectedKnownConsumers, (Closure)processIfWanted);
        if (predicate.getWantedFileCount() <= 0) {
            CollectionUtils.forAllDo(selectedInvalidConsumers, (Closure)closure);
        }
        TriggerScanCompletedClosure scanCompletedClosure = new TriggerScanCompletedClosure(repository, false);
        CollectionUtils.forAllDo(selectedKnownConsumers, (Closure)scanCompletedClosure);
    }

    public void setSelectedKnownConsumers(List<KnownRepositoryContentConsumer> selectedKnownConsumers) {
        this.selectedKnownConsumers = selectedKnownConsumers;
    }

    public void setSelectedInvalidConsumers(List<InvalidRepositoryContentConsumer> selectedInvalidConsumers) {
        this.selectedInvalidConsumers = selectedInvalidConsumers;
    }

    protected Date getStartTime() {
        return new Date(System.currentTimeMillis());
    }

    public void setArchivaAdministration(ArchivaAdministration archivaAdministration) {
        this.archivaAdministration = archivaAdministration;
    }
}

