/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.repository.scanner;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.configuration.FileTypes;
import org.apache.archiva.consumers.InvalidRepositoryContentConsumer;
import org.apache.archiva.consumers.KnownRepositoryContentConsumer;
import org.apache.archiva.consumers.RepositoryContentConsumer;
import org.apache.archiva.repository.scanner.RepositoryContentConsumers;
import org.apache.archiva.repository.scanner.RepositoryScanStatistics;
import org.apache.archiva.repository.scanner.RepositoryScanner;
import org.apache.archiva.repository.scanner.RepositoryScannerException;
import org.apache.archiva.repository.scanner.RepositoryScannerInstance;
import org.apache.commons.collections.CollectionUtils;
import org.codehaus.plexus.util.DirectoryWalkListener;
import org.codehaus.plexus.util.DirectoryWalker;
import org.springframework.stereotype.Service;

@Service(value="repositoryScanner#default")
public class DefaultRepositoryScanner
implements RepositoryScanner {
    @Inject
    private FileTypes filetypes;
    @Inject
    private RepositoryContentConsumers consumerUtil;
    private Set<RepositoryScannerInstance> inProgressScans = new LinkedHashSet<RepositoryScannerInstance>();

    @Override
    public RepositoryScanStatistics scan(ManagedRepository repository, long changesSince) throws RepositoryScannerException {
        try {
            List<KnownRepositoryContentConsumer> knownContentConsumers = this.consumerUtil.getSelectedKnownConsumers();
            List<InvalidRepositoryContentConsumer> invalidContentConsumers = this.consumerUtil.getSelectedInvalidConsumers();
            List ignoredPatterns = this.filetypes.getFileTypePatterns("ignored");
            return this.scan(repository, knownContentConsumers, invalidContentConsumers, ignoredPatterns, changesSince);
        }
        catch (RepositoryAdminException e) {
            throw new RepositoryScannerException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RepositoryScanStatistics scan(ManagedRepository repository, List<KnownRepositoryContentConsumer> knownContentConsumers, List<InvalidRepositoryContentConsumer> invalidContentConsumers, List<String> ignoredContentPatterns, long changesSince) throws RepositoryScannerException {
        RepositoryScanStatistics stats;
        if (repository == null) {
            throw new IllegalArgumentException("Unable to operate on a null repository.");
        }
        File repositoryBase = new File(repository.getLocation());
        if (!repositoryBase.exists() && !repositoryBase.mkdirs()) {
            throw new UnsupportedOperationException("Unable to scan a repository, directory " + repositoryBase.getPath() + " does not exist.");
        }
        if (!repositoryBase.isDirectory()) {
            throw new UnsupportedOperationException("Unable to scan a repository, path " + repositoryBase.getPath() + " is not a directory.");
        }
        ArrayList<String> allExcludes = new ArrayList<String>();
        ArrayList<String> allIncludes = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(ignoredContentPatterns)) {
            allExcludes.addAll(ignoredContentPatterns);
        }
        allIncludes.add("**/*");
        DirectoryWalker dirWalker = new DirectoryWalker();
        dirWalker.setBaseDir(repositoryBase);
        dirWalker.setIncludes(allIncludes);
        dirWalker.setExcludes(allExcludes);
        RepositoryScannerInstance scannerInstance = new RepositoryScannerInstance(repository, knownContentConsumers, invalidContentConsumers, changesSince);
        this.inProgressScans.add(scannerInstance);
        try {
            dirWalker.addDirectoryWalkListener((DirectoryWalkListener)scannerInstance);
            dirWalker.scan();
            stats = scannerInstance.getStatistics();
            stats.setKnownConsumers(this.gatherIds(knownContentConsumers));
            stats.setInvalidConsumers(this.gatherIds(invalidContentConsumers));
        }
        finally {
            this.inProgressScans.remove(scannerInstance);
        }
        return stats;
    }

    private List<String> gatherIds(List<? extends RepositoryContentConsumer> consumers) {
        ArrayList<String> ids = new ArrayList<String>();
        for (RepositoryContentConsumer repositoryContentConsumer : consumers) {
            ids.add(repositoryContentConsumer.getId());
        }
        return ids;
    }

    @Override
    public Set<RepositoryScannerInstance> getInProgressScans() {
        return this.inProgressScans;
    }
}

