/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.repository.scanner;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.common.utils.DateUtil;
import org.apache.commons.collections.CollectionUtils;

@XmlRootElement(name="repositoryScanStatistics")
public class RepositoryScanStatistics {
    private transient List<String> knownConsumers;
    private transient List<String> invalidConsumers;
    private transient long startTimestamp;
    private SimpleDateFormat df = new SimpleDateFormat();
    private String repositoryId;
    private Date whenGathered;
    private long duration = 0L;
    private long totalFileCount = 0L;
    private long newFileCount = 0L;
    private long totalSize = 0L;
    private Map<String, Long> consumerCounts;
    private Map<String, Long> consumerTimings;

    public void triggerStart() {
        this.startTimestamp = System.currentTimeMillis();
    }

    public Date getWhenGathered() {
        return this.whenGathered;
    }

    public void triggerFinished() {
        long finished = System.currentTimeMillis();
        this.duration = finished - this.startTimestamp;
        this.whenGathered = new Date(finished);
    }

    public void increaseFileCount() {
        long count = this.getTotalFileCount();
        this.totalFileCount = ++count;
    }

    public void increaseNewFileCount() {
        long count = this.getNewFileCount();
        this.newFileCount = ++count;
    }

    public void setKnownConsumers(List<String> consumers) {
        this.knownConsumers = consumers;
    }

    public void setInvalidConsumers(List<String> consumers) {
        this.invalidConsumers = consumers;
    }

    public String toDump(ManagedRepository repo) {
        long total;
        long time;
        StringBuilder buf = new StringBuilder();
        buf.append("\n.\\ Scan of ").append(this.getRepositoryId());
        buf.append(" \\.__________________________________________");
        buf.append("\n  Repository Dir    : ").append(repo.getLocation());
        buf.append("\n  Repository Name   : ").append(repo.getName());
        buf.append("\n  Repository Layout : ").append(repo.getLayout());
        buf.append("\n  Known Consumers   : ");
        if (CollectionUtils.isNotEmpty(this.knownConsumers)) {
            buf.append("(").append(this.knownConsumers.size()).append(" configured)");
            for (String id : this.knownConsumers) {
                buf.append("\n                      ").append(id);
                if (!this.consumerTimings.containsKey(id)) continue;
                time = this.consumerTimings.get(id);
                buf.append(" (Total: ").append(time).append("ms");
                if (this.consumerCounts.containsKey(id)) {
                    total = this.consumerCounts.get(id);
                    buf.append("; Avg.: " + time / total + "; Count: " + total);
                }
                buf.append(")");
            }
        } else {
            buf.append("<none>");
        }
        buf.append("\n  Invalid Consumers : ");
        if (CollectionUtils.isNotEmpty(this.invalidConsumers)) {
            buf.append("(").append(this.invalidConsumers.size()).append(" configured)");
            for (String id : this.invalidConsumers) {
                buf.append("\n                      ").append(id);
                if (!this.consumerTimings.containsKey(id)) continue;
                time = this.consumerTimings.get(id);
                buf.append(" (Total: ").append(time).append("ms");
                if (this.consumerCounts.containsKey(id)) {
                    total = this.consumerCounts.get(id);
                    buf.append("; Avg.: " + time / total + "ms; Count: " + total);
                }
                buf.append(")");
            }
        } else {
            buf.append("<none>");
        }
        buf.append("\n  Duration          : ");
        buf.append(DateUtil.getDuration((long)this.getDuration()));
        buf.append("\n  When Gathered     : ");
        if (this.getWhenGathered() == null) {
            buf.append("<null>");
        } else {
            buf.append(this.df.format(this.getWhenGathered()));
        }
        buf.append("\n  Total File Count  : ").append(this.getTotalFileCount());
        long averageMsPerFile = 0L;
        if (this.getTotalFileCount() != 0L) {
            averageMsPerFile = this.getDuration() / this.getTotalFileCount();
        }
        buf.append("\n  Avg Time Per File : ");
        buf.append(DateUtil.getDuration((long)averageMsPerFile));
        buf.append("\n______________________________________________________________");
        return buf.toString();
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getTotalFileCount() {
        return this.totalFileCount;
    }

    public long getNewFileCount() {
        return this.newFileCount;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public void setConsumerCounts(Map<String, Long> consumerCounts) {
        this.consumerCounts = consumerCounts;
    }

    public void setConsumerTimings(Map<String, Long> consumerTimings) {
        this.consumerTimings = consumerTimings;
    }
}

