/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.repository.scanner;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.common.utils.BaseFile;
import org.apache.archiva.consumers.InvalidRepositoryContentConsumer;
import org.apache.archiva.consumers.KnownRepositoryContentConsumer;
import org.apache.archiva.consumers.functors.ConsumerWantsFilePredicate;
import org.apache.archiva.repository.scanner.RepositoryScanStatistics;
import org.apache.archiva.repository.scanner.functors.ConsumerProcessFileClosure;
import org.apache.archiva.repository.scanner.functors.TriggerBeginScanClosure;
import org.apache.archiva.repository.scanner.functors.TriggerScanCompletedClosure;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.IfClosure;
import org.apache.commons.lang.SystemUtils;
import org.codehaus.plexus.util.DirectoryWalkListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryScannerInstance
implements DirectoryWalkListener {
    private Logger log = LoggerFactory.getLogger(RepositoryScannerInstance.class);
    private List<KnownRepositoryContentConsumer> knownConsumers;
    private List<InvalidRepositoryContentConsumer> invalidConsumers;
    private ManagedRepository repository;
    private RepositoryScanStatistics stats;
    private long changesSince = 0L;
    private ConsumerProcessFileClosure consumerProcessFile;
    private ConsumerWantsFilePredicate consumerWantsFile;
    private Map<String, Long> consumerTimings;
    private Map<String, Long> consumerCounts;

    public RepositoryScannerInstance(ManagedRepository repository, List<KnownRepositoryContentConsumer> knownConsumerList, List<InvalidRepositoryContentConsumer> invalidConsumerList) {
        this.repository = repository;
        this.knownConsumers = knownConsumerList;
        this.invalidConsumers = invalidConsumerList;
        this.consumerTimings = new HashMap<String, Long>();
        this.consumerCounts = new HashMap<String, Long>();
        this.consumerProcessFile = new ConsumerProcessFileClosure();
        this.consumerProcessFile.setExecuteOnEntireRepo(true);
        this.consumerProcessFile.setConsumerTimings(this.consumerTimings);
        this.consumerProcessFile.setConsumerCounts(this.consumerCounts);
        this.consumerWantsFile = new ConsumerWantsFilePredicate();
        this.stats = new RepositoryScanStatistics();
        this.stats.setRepositoryId(repository.getId());
        TriggerBeginScanClosure triggerBeginScan = new TriggerBeginScanClosure(repository, new Date(System.currentTimeMillis()), true);
        CollectionUtils.forAllDo(knownConsumerList, (Closure)triggerBeginScan);
        CollectionUtils.forAllDo(invalidConsumerList, (Closure)triggerBeginScan);
        if (SystemUtils.IS_OS_WINDOWS) {
            this.consumerWantsFile.setCaseSensitive(false);
        }
    }

    public RepositoryScannerInstance(ManagedRepository repository, List<KnownRepositoryContentConsumer> knownContentConsumers, List<InvalidRepositoryContentConsumer> invalidContentConsumers, long changesSince) {
        this(repository, knownContentConsumers, invalidContentConsumers);
        this.consumerWantsFile.setChangesSince(changesSince);
        this.changesSince = changesSince;
    }

    public RepositoryScanStatistics getStatistics() {
        return this.stats;
    }

    public Map<String, Long> getConsumerTimings() {
        return this.consumerTimings;
    }

    public Map<String, Long> getConsumerCounts() {
        return this.consumerCounts;
    }

    public void directoryWalkStarting(File basedir) {
        this.log.info("Walk Started: [{}] {}", (Object)this.repository.getId(), (Object)this.repository.getLocation());
        this.stats.triggerStart();
    }

    public void directoryWalkStep(int percentage, File file) {
        this.log.debug("Walk Step: {}, {}", (Object)percentage, (Object)file);
        this.stats.increaseFileCount();
        BaseFile basefile = new BaseFile(this.repository.getLocation(), file);
        if (file.lastModified() >= this.changesSince) {
            this.stats.increaseNewFileCount();
        }
        this.consumerProcessFile.setBasefile(basefile);
        this.consumerWantsFile.setBasefile(basefile);
        Closure processIfWanted = IfClosure.getInstance((Predicate)this.consumerWantsFile, (Closure)this.consumerProcessFile);
        CollectionUtils.forAllDo(this.knownConsumers, (Closure)processIfWanted);
        if (this.consumerWantsFile.getWantedFileCount() <= 0) {
            CollectionUtils.forAllDo(this.invalidConsumers, (Closure)this.consumerProcessFile);
        }
    }

    public void directoryWalkFinished() {
        TriggerScanCompletedClosure scanCompletedClosure = new TriggerScanCompletedClosure(this.repository, true);
        CollectionUtils.forAllDo(this.knownConsumers, (Closure)scanCompletedClosure);
        CollectionUtils.forAllDo(this.invalidConsumers, (Closure)scanCompletedClosure);
        this.stats.setConsumerTimings(this.consumerTimings);
        this.stats.setConsumerCounts(this.consumerCounts);
        this.log.info("Walk Finished: [{}] {}", (Object)this.repository.getId(), (Object)this.repository.getLocation());
        this.stats.triggerFinished();
    }

    public void debug(String message) {
        this.log.debug("Repository Scanner: {}", (Object)message);
    }

    public ManagedRepository getRepository() {
        return this.repository;
    }

    public RepositoryScanStatistics getStats() {
        return this.stats;
    }

    public long getChangesSince() {
        return this.changesSince;
    }
}

