/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.repository.scanner.functors;

import java.util.Date;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.consumers.ConsumerException;
import org.apache.archiva.consumers.RepositoryContentConsumer;
import org.apache.commons.collections.Closure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerBeginScanClosure
implements Closure {
    private Logger log = LoggerFactory.getLogger(TriggerBeginScanClosure.class);
    private ManagedRepository repository;
    private Date whenGathered;
    private boolean executeOnEntireRepo = true;

    public TriggerBeginScanClosure(ManagedRepository repository) {
        this.repository = repository;
    }

    public TriggerBeginScanClosure(ManagedRepository repository, Date whenGathered) {
        this(repository);
        this.whenGathered = whenGathered;
    }

    public TriggerBeginScanClosure(ManagedRepository repository, Date whenGathered, boolean executeOnEntireRepo) {
        this(repository, whenGathered);
        this.executeOnEntireRepo = executeOnEntireRepo;
    }

    public void execute(Object input) {
        if (input instanceof RepositoryContentConsumer) {
            RepositoryContentConsumer consumer = (RepositoryContentConsumer)input;
            try {
                consumer.beginScan(this.repository, this.whenGathered, this.executeOnEntireRepo);
            }
            catch (ConsumerException e) {
                this.log.warn("Consumer [" + consumer.getId() + "] cannot begin: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

