/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.repository.scanner.functors;

import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.consumers.RepositoryContentConsumer;
import org.apache.commons.collections.Closure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerScanCompletedClosure
implements Closure {
    private Logger log = LoggerFactory.getLogger(TriggerScanCompletedClosure.class);
    private final ManagedRepository repository;
    private boolean executeOnEntireRepo = true;

    public TriggerScanCompletedClosure(ManagedRepository repository) {
        this.repository = repository;
    }

    public TriggerScanCompletedClosure(ManagedRepository repository, boolean executeOnEntireRepo) {
        this(repository);
        this.executeOnEntireRepo = executeOnEntireRepo;
    }

    public void execute(Object input) {
        if (input instanceof RepositoryContentConsumer) {
            RepositoryContentConsumer consumer = (RepositoryContentConsumer)input;
            consumer.completeScan(this.executeOnEntireRepo);
            this.log.debug("Consumer [{}] completed for repository [{}]", (Object)consumer.getId(), (Object)this.repository.getId());
        }
    }
}

