/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.api.services;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.redback.authorization.RedbackAuthorization;
import org.apache.archiva.rest.api.model.ArchivaRepositoryStatistics;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;

@Path(value="/managedRepositoriesService/")
public interface ManagedRepositoriesService {
    @Path(value="getManagedRepositories")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public List<ManagedRepository> getManagedRepositories() throws ArchivaRestServiceException;

    @Path(value="getManagedRepository/{repositoryId}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public ManagedRepository getManagedRepository(@PathParam(value="repositoryId") String var1) throws ArchivaRestServiceException;

    @Path(value="deleteManagedRepository")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean deleteManagedRepository(@QueryParam(value="repositoryId") String var1, @QueryParam(value="deleteContent") boolean var2) throws ArchivaRestServiceException;

    @Path(value="addManagedRepository")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public ManagedRepository addManagedRepository(ManagedRepository var1) throws ArchivaRestServiceException;

    @Path(value="updateManagedRepository")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean updateManagedRepository(ManagedRepository var1) throws ArchivaRestServiceException;

    @Path(value="fileLocationExists")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean fileLocationExists(@QueryParam(value="fileLocation") String var1) throws ArchivaRestServiceException;

    @Path(value="getManagedRepositoryStatistics/{repositoryId}/{lang}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public ArchivaRepositoryStatistics getManagedRepositoryStatistics(@PathParam(value="repositoryId") String var1, @PathParam(value="lang") String var2) throws ArchivaRestServiceException;

    @Path(value="getPomSnippet/{repositoryId}")
    @GET
    @Produces(value={"text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public String getPomSnippet(@PathParam(value="repositoryId") String var1) throws ArchivaRestServiceException;
}

