/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.api.services;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.archiva.admin.model.beans.RepositoryGroup;
import org.apache.archiva.redback.authorization.RedbackAuthorization;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;

@Path(value="/repositoryGroupService/")
public interface RepositoryGroupService {
    @Path(value="getRepositoriesGroups")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public List<RepositoryGroup> getRepositoriesGroups() throws ArchivaRestServiceException;

    @Path(value="getRepositoryGroup/{repositoryGroupId}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public RepositoryGroup getRepositoryGroup(@PathParam(value="repositoryGroupId") String var1) throws ArchivaRestServiceException;

    @Path(value="addRepositoryGroup")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean addRepositoryGroup(RepositoryGroup var1) throws ArchivaRestServiceException;

    @Path(value="updateRepositoryGroup")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean updateRepositoryGroup(RepositoryGroup var1) throws ArchivaRestServiceException;

    @Path(value="deleteRepositoryGroup/{repositoryGroupId}")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean deleteRepositoryGroup(@PathParam(value="repositoryGroupId") String var1) throws ArchivaRestServiceException;

    @Path(value="addRepositoryToGroup")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean addRepositoryToGroup(@QueryParam(value="repositoryGroupId") String var1, @QueryParam(value="repositoryId") String var2) throws ArchivaRestServiceException;

    @Path(value="addRepositoryToGroup")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean deleteRepositoryFromGroup(@QueryParam(value="repositoryGroupId") String var1, @QueryParam(value="repositoryId") String var2) throws ArchivaRestServiceException;
}

