/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.api.services;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.archiva.maven2.model.Artifact;
import org.apache.archiva.redback.authorization.RedbackAuthorization;
import org.apache.archiva.rest.api.model.GroupIdList;
import org.apache.archiva.rest.api.model.SearchRequest;
import org.apache.archiva.rest.api.model.StringList;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;

@Path(value="/searchService/")
public interface SearchService {
    @Path(value="quickSearch")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public List<Artifact> quickSearch(@QueryParam(value="queryString") String var1) throws ArchivaRestServiceException;

    @Path(value="quickSearchWithRepositories")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public List<Artifact> quickSearchWithRepositories(SearchRequest var1) throws ArchivaRestServiceException;

    @Path(value="searchArtifacts")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public List<Artifact> searchArtifacts(SearchRequest var1) throws ArchivaRestServiceException;

    @Path(value="getArtifactVersions")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public List<Artifact> getArtifactVersions(@QueryParam(value="groupId") String var1, @QueryParam(value="artifactId") String var2, @QueryParam(value="packaging") String var3) throws ArchivaRestServiceException;

    @Path(value="getAllGroupIds")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=false)
    public GroupIdList getAllGroupIds(@QueryParam(value="selectedRepos") List<String> var1) throws ArchivaRestServiceException;

    @Path(value="observableRepoIds")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public StringList getObservablesRepoIds() throws ArchivaRestServiceException;

    @GET
    @Path(value="/artifact")
    @Produces(value={"text/html"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public Response redirectToArtifactFile(@QueryParam(value="r") String var1, @QueryParam(value="g") String var2, @QueryParam(value="a") String var3, @QueryParam(value="v") String var4, @QueryParam(value="p") String var5, @QueryParam(value="c") String var6) throws ArchivaRestServiceException;
}

