/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.api.services;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.archiva.redback.authorization.RedbackAuthorization;
import org.apache.archiva.rest.api.model.CacheEntry;
import org.apache.archiva.rest.api.model.QueueEntry;
import org.apache.archiva.rest.api.model.RepositoryScannerStatistics;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;

@Path(value="/systemStatusService/")
public interface SystemStatusService {
    @Path(value="memoryStatus")
    @GET
    @Produces(value={"text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public String getMemoryStatus() throws ArchivaRestServiceException;

    @Path(value="currentServerTime/{locale}")
    @GET
    @Produces(value={"text/plain"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public String getCurrentServerTime(@PathParam(value="locale") String var1) throws ArchivaRestServiceException;

    @Path(value="queueEntries")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public List<QueueEntry> getQueueEntries() throws ArchivaRestServiceException;

    @Path(value="cacheEntries")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public List<CacheEntry> getCacheEntries() throws ArchivaRestServiceException;

    @Path(value="clearCache/{key}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean clearCache(@PathParam(value="key") String var1) throws ArchivaRestServiceException;

    @Path(value="clearAllCaches")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public Boolean clearAllCaches() throws ArchivaRestServiceException;

    @Path(value="repositoryScannerStatistics")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"archiva-manage-configuration"})
    public List<RepositoryScannerStatistics> getRepositoryScannerStatistics() throws ArchivaRestServiceException;
}

