/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.archiva.admin.model.AuditInformation;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.admin.ArchivaAdministration;
import org.apache.archiva.admin.model.beans.ProxyConnector;
import org.apache.archiva.admin.model.managed.ManagedRepositoryAdmin;
import org.apache.archiva.admin.model.proxyconnector.ProxyConnectorAdmin;
import org.apache.archiva.common.utils.VersionUtil;
import org.apache.archiva.indexer.search.SearchResultHit;
import org.apache.archiva.maven2.model.Artifact;
import org.apache.archiva.metadata.model.ArtifactMetadata;
import org.apache.archiva.metadata.model.facets.AuditEvent;
import org.apache.archiva.metadata.repository.RepositorySessionFactory;
import org.apache.archiva.redback.components.taskqueue.TaskQueueException;
import org.apache.archiva.redback.configuration.UserConfiguration;
import org.apache.archiva.redback.rest.services.RedbackAuthenticationThreadLocal;
import org.apache.archiva.redback.rest.services.RedbackRequestInformation;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.repository.RepositoryContentFactory;
import org.apache.archiva.repository.RepositoryException;
import org.apache.archiva.repository.events.AuditListener;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.services.utils.ArtifactBuilder;
import org.apache.archiva.scheduler.repository.DefaultRepositoryArchivaTaskScheduler;
import org.apache.archiva.scheduler.repository.model.RepositoryTask;
import org.apache.archiva.security.AccessDeniedException;
import org.apache.archiva.security.ArchivaSecurityException;
import org.apache.archiva.security.PrincipalNotFoundException;
import org.apache.archiva.security.UserRepositories;
import org.apache.commons.lang.StringUtils;
import org.modelmapper.ModelMapper;
import org.modelmapper.PropertyMap;
import org.modelmapper.convention.MatchingStrategies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public abstract class AbstractRestService {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    private List<AuditListener> auditListeners = new ArrayList<AuditListener>();
    @Inject
    protected UserRepositories userRepositories;
    @Inject
    @Named(value="repositorySessionFactory")
    protected RepositorySessionFactory repositorySessionFactory;
    @Inject
    protected ArchivaAdministration archivaAdministration;
    @Inject
    protected ProxyConnectorAdmin proxyConnectorAdmin;
    @Inject
    protected ManagedRepositoryAdmin managedRepositoryAdmin;
    @Inject
    protected RepositoryContentFactory repositoryContentFactory;
    @Inject
    @Named(value="archivaTaskScheduler#repository")
    protected DefaultRepositoryArchivaTaskScheduler repositoryTaskScheduler;
    @Inject
    @Named(value="userConfiguration#default")
    protected UserConfiguration config;
    @Context
    protected HttpServletRequest httpServletRequest;
    @Context
    protected HttpServletResponse httpServletResponse;

    protected AuditInformation getAuditInformation() {
        RedbackRequestInformation redbackRequestInformation = RedbackAuthenticationThreadLocal.get();
        User user = redbackRequestInformation == null ? null : redbackRequestInformation.getUser();
        String remoteAddr = redbackRequestInformation == null ? null : redbackRequestInformation.getRemoteAddr();
        return new AuditInformation(user, remoteAddr);
    }

    public List<AuditListener> getAuditListeners() {
        return this.auditListeners;
    }

    public void setAuditListeners(List<AuditListener> auditListeners) {
        this.auditListeners = auditListeners;
    }

    protected List<String> getObservableRepos() {
        try {
            List ids = this.userRepositories.getObservableRepositoryIds(this.getPrincipal());
            return ids == null ? Collections.emptyList() : ids;
        }
        catch (PrincipalNotFoundException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        catch (AccessDeniedException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        catch (ArchivaSecurityException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    protected String getPrincipal() {
        RedbackRequestInformation redbackRequestInformation = RedbackAuthenticationThreadLocal.get();
        return redbackRequestInformation == null ? this.config.getString("redback.default.guest") : (redbackRequestInformation.getUser() == null ? this.config.getString("redback.default.guest") : redbackRequestInformation.getUser().getUsername());
    }

    protected String getBaseUrl() throws RepositoryAdminException {
        String applicationUrl = this.archivaAdministration.getUiConfiguration().getApplicationUrl();
        if (StringUtils.isNotBlank((String)applicationUrl)) {
            return applicationUrl;
        }
        return this.httpServletRequest.getScheme() + "://" + this.httpServletRequest.getServerName() + (this.httpServletRequest.getServerPort() == 80 ? "" : ":" + this.httpServletRequest.getServerPort()) + this.httpServletRequest.getContextPath();
    }

    protected <T> Map<String, T> getBeansOfType(ApplicationContext applicationContext, Class<T> clazz) {
        Map springBeans = applicationContext.getBeansOfType(clazz);
        HashMap beans = new HashMap(springBeans.size());
        for (Map.Entry entry : springBeans.entrySet()) {
            String key = StringUtils.contains((String)((String)entry.getKey()), (char)'#') ? StringUtils.substringAfterLast((String)((String)entry.getKey()), (String)"#") : (String)entry.getKey();
            beans.put(key, entry.getValue());
        }
        return beans;
    }

    protected void triggerAuditEvent(String repositoryId, String filePath, String action) {
        AuditEvent auditEvent = new AuditEvent(repositoryId, this.getPrincipal(), filePath, action);
        AuditInformation auditInformation = this.getAuditInformation();
        auditEvent.setUserId(auditInformation.getUser() == null ? "" : auditInformation.getUser().getUsername());
        auditEvent.setRemoteIP(auditInformation.getRemoteAddr());
        for (AuditListener auditListener : this.getAuditListeners()) {
            auditListener.auditEvent(auditEvent);
        }
    }

    protected String getArtifactUrl(Artifact artifact) throws ArchivaRestServiceException {
        return this.getArtifactUrl(artifact, null);
    }

    protected String getArtifactUrl(Artifact artifact, String repositoryId) throws ArchivaRestServiceException {
        try {
            if (this.httpServletRequest == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder(this.getBaseUrl());
            sb.append("/repository");
            if (StringUtils.isEmpty((String)repositoryId)) {
                List userRepos = this.userRepositories.getObservableRepositoryIds(this.getPrincipal());
                if (!userRepos.contains(artifact.getContext())) {
                    for (Map.Entry entry : this.proxyConnectorAdmin.getProxyConnectorAsMap().entrySet()) {
                        for (ProxyConnector proxyConnector : (List)entry.getValue()) {
                            if (!StringUtils.equals((String)("remote-" + proxyConnector.getTargetRepoId()), (String)artifact.getContext()) || !userRepos.contains(entry.getKey())) continue;
                            sb.append('/').append((String)entry.getKey());
                        }
                    }
                } else {
                    sb.append('/').append(artifact.getContext());
                }
            } else {
                sb.append('/').append(repositoryId);
            }
            sb.append('/').append(StringUtils.replaceChars((String)artifact.getGroupId(), (char)'.', (char)'/'));
            sb.append('/').append(artifact.getArtifactId());
            if (VersionUtil.isSnapshot((String)artifact.getVersion())) {
                sb.append('/').append(VersionUtil.getBaseVersion((String)artifact.getVersion()));
            } else {
                sb.append('/').append(artifact.getVersion());
            }
            sb.append('/').append(artifact.getArtifactId());
            sb.append('-').append(artifact.getVersion());
            if (StringUtils.isNotBlank((String)artifact.getClassifier())) {
                sb.append('-').append(artifact.getClassifier());
            }
            if (StringUtils.equals((String)"maven-plugin", (String)artifact.getPackaging())) {
                sb.append("jar");
            } else {
                sb.append('.').append(artifact.getFileExtension());
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new ArchivaRestServiceException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)e);
        }
    }

    protected List<Artifact> buildArtifacts(List<ArtifactMetadata> artifactMetadatas, String repositoryId) throws ArchivaRestServiceException {
        try {
            if (artifactMetadatas != null && !artifactMetadatas.isEmpty()) {
                ArrayList<Artifact> artifacts = new ArrayList<Artifact>(artifactMetadatas.size());
                for (ArtifactMetadata artifact : artifactMetadatas) {
                    ArtifactBuilder builder = new ArtifactBuilder().forArtifactMetadata(artifact).withManagedRepositoryContent(this.repositoryContentFactory.getManagedRepositoryContent(repositoryId));
                    Artifact art = builder.build();
                    art.setUrl(this.getArtifactUrl(art, repositoryId));
                    artifacts.add(art);
                }
                return artifacts;
            }
            return Collections.emptyList();
        }
        catch (RepositoryException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)e);
        }
    }

    protected Boolean doScanRepository(String repositoryId, boolean fullScan) {
        if (this.repositoryTaskScheduler.isProcessingRepositoryTask(repositoryId)) {
            this.log.info("scanning of repository with id {} already scheduled", (Object)repositoryId);
            return Boolean.FALSE;
        }
        RepositoryTask task = new RepositoryTask();
        task.setRepositoryId(repositoryId);
        task.setScanAll(fullScan);
        try {
            this.repositoryTaskScheduler.queueTask(task);
        }
        catch (TaskQueueException e) {
            this.log.error("failed to schedule scanning of repo with id {}", (Object)repositoryId, (Object)e);
            return false;
        }
        return true;
    }

    protected ModelMapper getModelMapper() {
        return ModelMapperHolder.MODEL_MAPPER;
    }

    private static class SearchResultHitMap
    extends PropertyMap<SearchResultHit, Artifact> {
        private SearchResultHitMap() {
        }

        protected void configure() {
            ((Artifact)this.skip()).setId(null);
        }
    }

    private static class ModelMapperHolder {
        private static ModelMapper MODEL_MAPPER = new ModelMapper();

        private ModelMapperHolder() {
        }

        static {
            MODEL_MAPPER.addMappings((PropertyMap)new SearchResultHitMap());
            MODEL_MAPPER.getConfiguration().setMatchingStrategy(MatchingStrategies.STRICT);
        }
    }
}

