/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.NetworkProxy;
import org.apache.archiva.admin.model.beans.RemoteRepository;
import org.apache.archiva.admin.model.networkproxy.NetworkProxyAdmin;
import org.apache.archiva.admin.model.remote.RemoteRepositoryAdmin;
import org.apache.archiva.proxy.common.WagonFactory;
import org.apache.archiva.proxy.common.WagonFactoryRequest;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.api.services.RemoteRepositoriesService;
import org.apache.archiva.rest.services.AbstractRestService;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.providers.http.AbstractHttpClientWagon;
import org.apache.maven.wagon.providers.http.HttpConfiguration;
import org.apache.maven.wagon.providers.http.HttpMethodConfiguration;
import org.apache.maven.wagon.repository.Repository;
import org.springframework.stereotype.Service;

@Service(value="remoteRepositoriesService#rest")
public class DefaultRemoteRepositoriesService
extends AbstractRestService
implements RemoteRepositoriesService {
    @Inject
    private RemoteRepositoryAdmin remoteRepositoryAdmin;
    @Inject
    private WagonFactory wagonFactory;
    @Inject
    private NetworkProxyAdmin networkProxyAdmin;

    public List<RemoteRepository> getRemoteRepositories() throws ArchivaRestServiceException {
        try {
            List remoteRepositories = this.remoteRepositoryAdmin.getRemoteRepositories();
            return remoteRepositories == null ? Collections.emptyList() : remoteRepositories;
        }
        catch (RepositoryAdminException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), e.getFieldName(), (Throwable)e);
        }
    }

    public RemoteRepository getRemoteRepository(String repositoryId) throws ArchivaRestServiceException {
        List<RemoteRepository> remoteRepositories = this.getRemoteRepositories();
        for (RemoteRepository repository : remoteRepositories) {
            if (!StringUtils.equals((String)repositoryId, (String)repository.getId())) continue;
            return repository;
        }
        return null;
    }

    public Boolean deleteRemoteRepository(String repositoryId) throws ArchivaRestServiceException {
        try {
            return this.remoteRepositoryAdmin.deleteRemoteRepository(repositoryId, this.getAuditInformation());
        }
        catch (RepositoryAdminException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), e.getFieldName(), (Throwable)e);
        }
    }

    public Boolean addRemoteRepository(RemoteRepository remoteRepository) throws ArchivaRestServiceException {
        try {
            return this.remoteRepositoryAdmin.addRemoteRepository(remoteRepository, this.getAuditInformation());
        }
        catch (RepositoryAdminException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), e.getFieldName(), (Throwable)e);
        }
    }

    public Boolean updateRemoteRepository(RemoteRepository remoteRepository) throws ArchivaRestServiceException {
        try {
            return this.remoteRepositoryAdmin.updateRemoteRepository(remoteRepository, this.getAuditInformation());
        }
        catch (RepositoryAdminException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), e.getFieldName(), (Throwable)e);
        }
    }

    public Boolean checkRemoteConnectivity(String repositoryId) throws ArchivaRestServiceException {
        try {
            RemoteRepository remoteRepository = this.remoteRepositoryAdmin.getRemoteRepository(repositoryId);
            if (remoteRepository == null) {
                this.log.warn("ignore scheduleDownloadRemote for repo with id {} as not exists", (Object)repositoryId);
                return Boolean.FALSE;
            }
            NetworkProxy networkProxy = null;
            if (StringUtils.isNotBlank((String)remoteRepository.getRemoteDownloadNetworkProxyId()) && (networkProxy = this.networkProxyAdmin.getNetworkProxy(remoteRepository.getRemoteDownloadNetworkProxyId())) == null) {
                this.log.warn("your remote repository is configured to download remote index trought a proxy we cannot find id:{}", (Object)remoteRepository.getRemoteDownloadNetworkProxyId());
            }
            String wagonProtocol = new URL(remoteRepository.getUrl()).getProtocol();
            Wagon wagon = this.wagonFactory.getWagon(new WagonFactoryRequest(wagonProtocol, remoteRepository.getExtraHeaders()).networkProxy(networkProxy));
            wagon.setReadTimeout(4000);
            wagon.setTimeout(3000);
            if (wagon instanceof AbstractHttpClientWagon) {
                HttpConfiguration httpConfiguration = new HttpConfiguration();
                HttpMethodConfiguration httpMethodConfiguration = new HttpMethodConfiguration();
                httpMethodConfiguration.setUsePreemptive(true);
                httpMethodConfiguration.setReadTimeout(4000);
                httpConfiguration.setGet(httpMethodConfiguration);
                ((AbstractHttpClientWagon)AbstractHttpClientWagon.class.cast(wagon)).setHttpConfiguration(httpConfiguration);
            }
            wagon.connect(new Repository(remoteRepository.getId(), remoteRepository.getUrl()));
            wagon.getFileList("/");
            return Boolean.TRUE;
        }
        catch (TransferFailedException e) {
            this.log.info("TransferFailedException :{}", (Object)e.getMessage());
            return Boolean.FALSE;
        }
        catch (Exception e) {
            throw new ArchivaRestServiceException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)e);
        }
    }
}

