/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.RepositoryGroup;
import org.apache.archiva.admin.model.group.RepositoryGroupAdmin;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.api.services.RepositoryGroupService;
import org.apache.archiva.rest.services.AbstractRestService;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="repositoryGroupService#rest")
public class DefaultRepositoryGroupService
extends AbstractRestService
implements RepositoryGroupService {
    @Inject
    private RepositoryGroupAdmin repositoryGroupAdmin;

    public List<RepositoryGroup> getRepositoriesGroups() throws ArchivaRestServiceException {
        try {
            ArrayList<RepositoryGroup> repositoriesGroups = new ArrayList<RepositoryGroup>(this.repositoryGroupAdmin.getRepositoriesGroups().size());
            for (RepositoryGroup repoGroup : this.repositoryGroupAdmin.getRepositoriesGroups()) {
                repositoriesGroups.add(new RepositoryGroup(repoGroup.getId(), new ArrayList(repoGroup.getRepositories())).mergedIndexPath(repoGroup.getMergedIndexPath()).mergedIndexTtl(repoGroup.getMergedIndexTtl()).cronExpression(repoGroup.getCronExpression()));
            }
            return repositoriesGroups;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public RepositoryGroup getRepositoryGroup(String repositoryGroupId) throws ArchivaRestServiceException {
        for (RepositoryGroup repositoryGroup : this.getRepositoriesGroups()) {
            if (!StringUtils.equals((String)repositoryGroupId, (String)repositoryGroup.getId())) continue;
            return repositoryGroup;
        }
        return null;
    }

    public Boolean addRepositoryGroup(RepositoryGroup repoGroup) throws ArchivaRestServiceException {
        try {
            return this.repositoryGroupAdmin.addRepositoryGroup(new RepositoryGroup(repoGroup.getId(), new ArrayList(repoGroup.getRepositories())).mergedIndexPath(repoGroup.getMergedIndexPath()).mergedIndexTtl(repoGroup.getMergedIndexTtl()).cronExpression(repoGroup.getCronExpression()), this.getAuditInformation());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean updateRepositoryGroup(RepositoryGroup repoGroup) throws ArchivaRestServiceException {
        try {
            return this.repositoryGroupAdmin.updateRepositoryGroup(new RepositoryGroup(repoGroup.getId(), new ArrayList(repoGroup.getRepositories())).mergedIndexPath(repoGroup.getMergedIndexPath()).mergedIndexTtl(repoGroup.getMergedIndexTtl()).cronExpression(repoGroup.getCronExpression()), this.getAuditInformation());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean deleteRepositoryGroup(String repositoryGroupId) throws ArchivaRestServiceException {
        try {
            return this.repositoryGroupAdmin.deleteRepositoryGroup(repositoryGroupId, this.getAuditInformation());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean addRepositoryToGroup(String repositoryGroupId, String repositoryId) throws ArchivaRestServiceException {
        try {
            return this.repositoryGroupAdmin.addRepositoryToGroup(repositoryGroupId, repositoryId, this.getAuditInformation());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean deleteRepositoryFromGroup(String repositoryGroupId, String repositoryId) throws ArchivaRestServiceException {
        try {
            return this.repositoryGroupAdmin.deleteRepositoryFromGroup(repositoryGroupId, repositoryId, this.getAuditInformation());
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }
}

