/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.api.services.PluginsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service(value="pluginsService#rest")
public class DefaultPluginsServices
implements PluginsService {
    private List<String> repositoryType = new ArrayList<String>();
    private List<String> adminFeatures = new ArrayList<String>();
    private ApplicationContext appCont;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private String adminPlugins;

    @Inject
    public DefaultPluginsServices(ApplicationContext applicationContext) throws IOException {
        this.appCont = applicationContext;
        this.feed(this.repositoryType, "repository");
        this.feed(this.adminFeatures, "features");
        StringBuilder sb = new StringBuilder();
        for (String repoType : this.repositoryType) {
            sb.append(repoType).append("|");
        }
        for (String repoType : this.adminFeatures) {
            sb.append(repoType).append("|");
        }
        this.log.debug("getAdminPlugins: {}", (Object)sb.toString());
        this.adminPlugins = sb.length() > 1 ? sb.substring(0, sb.length() - 1) : sb.toString();
    }

    private void feed(List<String> repository, String key) throws IOException {
        Resource[] xmlResources;
        this.log.info("Feeding: {}", (Object)key);
        repository.clear();
        for (Resource rc : xmlResources = this.appCont.getResources("/**/" + key + "/**/main.js")) {
            String tmp = rc.getURL().toString();
            tmp = tmp.substring(tmp.lastIndexOf(key) + key.length() + 1, tmp.length() - 8);
            repository.add("archiva/admin/" + key + "/" + tmp + "/main");
        }
    }

    public String getAdminPlugins() throws ArchivaRestServiceException {
        return this.adminPlugins;
    }
}

