/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.apache.archiva.redback.components.cache.Cache;
import org.apache.archiva.redback.components.cache.CacheStatistics;
import org.apache.archiva.redback.components.taskqueue.TaskQueue;
import org.apache.archiva.redback.components.taskqueue.TaskQueueException;
import org.apache.archiva.repository.scanner.RepositoryScanner;
import org.apache.archiva.repository.scanner.RepositoryScannerInstance;
import org.apache.archiva.rest.api.model.CacheEntry;
import org.apache.archiva.rest.api.model.ConsumerScanningStatistics;
import org.apache.archiva.rest.api.model.QueueEntry;
import org.apache.archiva.rest.api.model.RepositoryScannerStatistics;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.api.services.SystemStatusService;
import org.apache.archiva.rest.services.AbstractRestService;
import org.apache.archiva.rest.services.utils.ConsumerScanningStatisticsComparator;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="systemStatusService#rest")
public class DefaultSystemStatusService
extends AbstractRestService
implements SystemStatusService {
    private Map<String, TaskQueue> queues = null;
    private Map<String, Cache> caches = null;
    private RepositoryScanner scanner;

    @Inject
    public DefaultSystemStatusService(ApplicationContext applicationContext, RepositoryScanner scanner) {
        this.scanner = scanner;
        this.queues = this.getBeansOfType(applicationContext, TaskQueue.class);
        this.caches = this.getBeansOfType(applicationContext, Cache.class);
    }

    public String getMemoryStatus() throws ArchivaRestServiceException {
        Runtime runtime = Runtime.getRuntime();
        long total = runtime.totalMemory();
        long used = total - runtime.freeMemory();
        long max = runtime.maxMemory();
        return DefaultSystemStatusService.formatMemory(used) + "/" + DefaultSystemStatusService.formatMemory(total) + " (Max: " + DefaultSystemStatusService.formatMemory(max) + ")";
    }

    private static String formatMemory(long l) {
        return l / 0x100000L + "M";
    }

    public String getCurrentServerTime(String locale) throws ArchivaRestServiceException {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", new Locale(locale));
        return sdf.format(new Date());
    }

    public List<QueueEntry> getQueueEntries() throws ArchivaRestServiceException {
        try {
            ArrayList<QueueEntry> queueEntries = new ArrayList<QueueEntry>(this.queues.size());
            for (Map.Entry<String, TaskQueue> entry : this.queues.entrySet()) {
                queueEntries.add(new QueueEntry(entry.getKey(), entry.getValue().getQueueSnapshot().size()));
            }
            return queueEntries;
        }
        catch (TaskQueueException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new ArchivaRestServiceException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)e);
        }
    }

    public List<CacheEntry> getCacheEntries() throws ArchivaRestServiceException {
        ArrayList<CacheEntry> cacheEntries = new ArrayList<CacheEntry>(this.caches.size());
        DecimalFormat decimalFormat = new DecimalFormat("#%");
        for (Map.Entry<String, Cache> entry : this.caches.entrySet()) {
            CacheStatistics cacheStatistics = entry.getValue().getStatistics();
            cacheEntries.add(new CacheEntry(entry.getKey(), cacheStatistics.getSize(), cacheStatistics.getCacheHits(), cacheStatistics.getCacheMiss(), decimalFormat.format(cacheStatistics.getCacheHitRate()).toString(), cacheStatistics.getInMemorySize()));
        }
        Collections.sort(cacheEntries);
        return cacheEntries;
    }

    public Boolean clearCache(String cacheKey) throws ArchivaRestServiceException {
        Cache cache = this.caches.get(cacheKey);
        if (cache == null) {
            throw new ArchivaRestServiceException("no cache for key: " + cacheKey, Response.Status.BAD_REQUEST.getStatusCode(), null);
        }
        cache.clear();
        return Boolean.TRUE;
    }

    public Boolean clearAllCaches() throws ArchivaRestServiceException {
        for (Cache cache : this.caches.values()) {
            cache.clear();
        }
        return Boolean.TRUE;
    }

    public List<RepositoryScannerStatistics> getRepositoryScannerStatistics() throws ArchivaRestServiceException {
        Set repositoryScannerInstances = this.scanner.getInProgressScans();
        if (repositoryScannerInstances.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RepositoryScannerStatistics> repositoryScannerStatisticsList = new ArrayList<RepositoryScannerStatistics>(repositoryScannerInstances.size());
        for (RepositoryScannerInstance instance : repositoryScannerInstances) {
            RepositoryScannerStatistics repositoryScannerStatistics = new RepositoryScannerStatistics();
            repositoryScannerStatisticsList.add(repositoryScannerStatistics);
            repositoryScannerStatistics.setManagedRepository(instance.getRepository());
            repositoryScannerStatistics.setNewFileCount(instance.getStats().getNewFileCount());
            repositoryScannerStatistics.setTotalFileCount(instance.getStats().getTotalFileCount());
            repositoryScannerStatistics.setConsumerScanningStatistics(this.mapConsumerScanningStatistics(instance));
        }
        return repositoryScannerStatisticsList;
    }

    private List<ConsumerScanningStatistics> mapConsumerScanningStatistics(RepositoryScannerInstance instance) {
        DecimalFormat decimalFormat = new DecimalFormat("###.##");
        if (instance.getConsumerCounts() == null) {
            return Collections.emptyList();
        }
        ArrayList<ConsumerScanningStatistics> ret = new ArrayList<ConsumerScanningStatistics>(instance.getConsumerCounts().size());
        for (Map.Entry entry : instance.getConsumerCounts().entrySet()) {
            ConsumerScanningStatistics consumerScanningStatistics = new ConsumerScanningStatistics();
            consumerScanningStatistics.setConsumerKey((String)entry.getKey());
            consumerScanningStatistics.setCount(((Long)entry.getValue()).longValue());
            consumerScanningStatistics.setTime(((Long)instance.getConsumerTimings().get(entry.getKey())).longValue());
            if (consumerScanningStatistics.getCount() > 0L) {
                consumerScanningStatistics.setAverage(decimalFormat.format(consumerScanningStatistics.getTime() / consumerScanningStatistics.getCount()));
            }
            ret.add(consumerScanningStatistics);
        }
        Collections.sort(ret, ConsumerScanningStatisticsComparator.INSTANCE);
        return ret;
    }
}

