/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rss.processor;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.inject.Inject;
import org.apache.archiva.metadata.model.ArtifactMetadata;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataRepositoryException;
import org.apache.archiva.metadata.repository.MetadataResolutionException;
import org.apache.archiva.rss.RssFeedEntry;
import org.apache.archiva.rss.RssFeedGenerator;
import org.apache.archiva.rss.processor.AbstractArtifactsRssFeedProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="rssFeedProcessor#new-versions")
public class NewVersionsOfArtifactRssFeedProcessor
extends AbstractArtifactsRssFeedProcessor {
    private Logger log = LoggerFactory.getLogger(NewVersionsOfArtifactRssFeedProcessor.class);
    private static final String title = "New Versions of Artifact ";
    private static final String desc = "These are the new versions of artifact ";
    @Inject
    private RssFeedGenerator generator;

    @Override
    public SyndFeed process(Map<String, String> reqParams, MetadataRepository metadataRepository) throws FeedException {
        String groupId = reqParams.get("groupId");
        String artifactId = reqParams.get("artifactId");
        if (groupId != null && artifactId != null) {
            return this.processNewVersionsOfArtifact(groupId, artifactId, metadataRepository);
        }
        return null;
    }

    private SyndFeed processNewVersionsOfArtifact(String groupId, String artifactId, MetadataRepository metadataRepository) throws FeedException {
        ArrayList artifacts = new ArrayList();
        try {
            for (String repoId : metadataRepository.getRepositories()) {
                Collection versions = metadataRepository.getProjectVersions(repoId, groupId, artifactId);
                for (String version : versions) {
                    artifacts.addAll(metadataRepository.getArtifacts(repoId, groupId, artifactId, version));
                }
            }
        }
        catch (MetadataRepositoryException e) {
            throw new FeedException("Unable to construct feed, metadata could not be retrieved: " + e.getMessage(), (Throwable)e);
        }
        catch (MetadataResolutionException e) {
            throw new FeedException("Unable to construct feed, metadata could not be retrieved: " + e.getMessage(), (Throwable)e);
        }
        long tmp = 0L;
        RssFeedEntry entry = null;
        ArrayList<RssFeedEntry> entries = new ArrayList<RssFeedEntry>();
        String description = "";
        int idx = 0;
        for (ArtifactMetadata artifact : artifacts) {
            long whenGathered = artifact.getWhenGathered().getTime();
            if (tmp != whenGathered) {
                if (entry != null) {
                    entry.setDescription(description);
                    entries.add(entry);
                    entry = null;
                }
                entry = new RssFeedEntry(this.getTitle() + "'" + groupId + ":" + artifactId + "'" + " as of " + new Date(whenGathered));
                entry.setPublishedDate(artifact.getWhenGathered());
                description = this.getDescription() + "'" + groupId + ":" + artifactId + "'" + ": \n" + artifact.getId() + " | ";
            } else {
                description = description + artifact.getId() + " | ";
            }
            if (idx == artifacts.size() - 1) {
                entry.setDescription(description);
                entries.add(entry);
            }
            tmp = whenGathered;
            ++idx;
        }
        String key = groupId + ":" + artifactId;
        return this.generator.generateFeed(this.getTitle() + "'" + key + "'", "New versions of artifact '" + key + "' found during repository scan.", entries);
    }

    @Override
    public String getTitle() {
        return title;
    }

    @Override
    public String getDescription() {
        return desc;
    }

    public RssFeedGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(RssFeedGenerator generator) {
        this.generator = generator;
    }
}

