/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rss;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.archiva.rss.RssFeedEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="rssFeedGenerator#default")
@Scope(value="prototype")
public class RssFeedGenerator {
    private Logger log = LoggerFactory.getLogger(RssFeedGenerator.class);
    public static String DEFAULT_FEEDTYPE = "rss_2.0";
    public static String DEFAULT_LANGUAGE = "en-us";

    public SyndFeed generateFeed(String title, String description, List<RssFeedEntry> dataEntries) {
        if (dataEntries.size() == 0) {
            this.log.debug("No updates found, feed not generated.");
            return null;
        }
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setTitle(title);
        feed.setDescription(description);
        feed.setLanguage(DEFAULT_LANGUAGE);
        feed.setPublishedDate(dataEntries.get(dataEntries.size() - 1).getPublishedDate());
        feed.setFeedType(DEFAULT_FEEDTYPE);
        feed.setEntries(this.getEntries(dataEntries));
        this.log.debug("Finished generating the feed '{}'.", (Object)title);
        return feed;
    }

    private List<SyndEntry> getEntries(List<RssFeedEntry> dataEntries) {
        ArrayList<SyndEntry> entries = new ArrayList<SyndEntry>();
        for (RssFeedEntry dataEntry : dataEntries) {
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle(dataEntry.getTitle());
            entry.setPublishedDate(dataEntry.getPublishedDate());
            SyndContentImpl description = new SyndContentImpl();
            description.setType("text/plain");
            description.setValue(dataEntry.getDescription());
            entry.setDescription((SyndContent)description);
            entries.add((SyndEntry)entry);
        }
        return entries;
    }
}

