/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.scheduler.indexing;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.NetworkProxy;
import org.apache.archiva.admin.model.beans.RemoteRepository;
import org.apache.archiva.admin.model.networkproxy.NetworkProxyAdmin;
import org.apache.archiva.admin.model.proxyconnector.ProxyConnectorAdmin;
import org.apache.archiva.admin.model.remote.RemoteRepositoryAdmin;
import org.apache.archiva.common.ArchivaException;
import org.apache.archiva.common.plexusbridge.MavenIndexerUtils;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridge;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridgeException;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.ConfigurationEvent;
import org.apache.archiva.configuration.ConfigurationListener;
import org.apache.archiva.proxy.common.WagonFactory;
import org.apache.archiva.scheduler.indexing.DownloadRemoteIndexException;
import org.apache.archiva.scheduler.indexing.DownloadRemoteIndexScheduler;
import org.apache.archiva.scheduler.indexing.DownloadRemoteIndexTask;
import org.apache.archiva.scheduler.indexing.DownloadRemoteIndexTaskRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.context.UnsupportedExistingLuceneIndexException;
import org.apache.maven.index.packer.IndexPacker;
import org.apache.maven.index.updater.IndexUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;

@Service(value="downloadRemoteIndexScheduler#default")
public class DefaultDownloadRemoteIndexScheduler
implements ConfigurationListener,
DownloadRemoteIndexScheduler {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    @Named(value="taskScheduler#indexDownloadRemote")
    private TaskScheduler taskScheduler;
    @Inject
    private ArchivaConfiguration archivaConfiguration;
    @Inject
    private WagonFactory wagonFactory;
    @Inject
    private RemoteRepositoryAdmin remoteRepositoryAdmin;
    @Inject
    private ProxyConnectorAdmin proxyConnectorAdmin;
    @Inject
    private NetworkProxyAdmin networkProxyAdmin;
    @Inject
    private PlexusSisuBridge plexusSisuBridge;
    @Inject
    private MavenIndexerUtils mavenIndexerUtils;
    private NexusIndexer nexusIndexer;
    private IndexUpdater indexUpdater;
    private IndexPacker indexPacker;
    private List<String> runningRemoteDownloadIds = new CopyOnWriteArrayList<String>();

    @PostConstruct
    public void startup() throws ArchivaException, RepositoryAdminException, PlexusSisuBridgeException, IOException, UnsupportedExistingLuceneIndexException, DownloadRemoteIndexException {
        this.archivaConfiguration.addListener((ConfigurationListener)this);
        this.nexusIndexer = (NexusIndexer)this.plexusSisuBridge.lookup(NexusIndexer.class);
        this.indexUpdater = (IndexUpdater)this.plexusSisuBridge.lookup(IndexUpdater.class);
        this.indexPacker = (IndexPacker)this.plexusSisuBridge.lookup(IndexPacker.class);
        for (RemoteRepository remoteRepository : this.remoteRepositoryAdmin.getRemoteRepositories()) {
            String contextKey = "remote-" + remoteRepository.getId();
            IndexingContext context = (IndexingContext)this.nexusIndexer.getIndexingContexts().get(contextKey);
            if (context == null || !remoteRepository.isDownloadRemoteIndex() || !StringUtils.isNotEmpty((String)remoteRepository.getCronExpression())) continue;
            boolean fullDownload = context.getIndexDirectoryFile().list().length == 0;
            this.scheduleDownloadRemote(remoteRepository.getId(), false, fullDownload);
        }
    }

    @PreDestroy
    public void shutdown() throws RepositoryAdminException, IOException {
        for (RemoteRepository remoteRepository : this.remoteRepositoryAdmin.getRemoteRepositories()) {
            String contextKey = "remote-" + remoteRepository.getId();
            IndexingContext context = (IndexingContext)this.nexusIndexer.getIndexingContexts().get(contextKey);
            if (context == null) continue;
            this.nexusIndexer.removeIndexingContext(context, false);
        }
    }

    public void configurationEvent(ConfigurationEvent event) {
    }

    @Override
    public void scheduleDownloadRemote(String repositoryId, boolean now, boolean fullDownload) throws DownloadRemoteIndexException {
        block8: {
            try {
                RemoteRepository remoteRepository = this.remoteRepositoryAdmin.getRemoteRepository(repositoryId);
                if (remoteRepository == null) {
                    this.log.warn("ignore scheduleDownloadRemote for repo with id {} as not exists", (Object)repositoryId);
                    return;
                }
                NetworkProxy networkProxy = null;
                if (StringUtils.isNotBlank((String)remoteRepository.getRemoteDownloadNetworkProxyId()) && (networkProxy = this.networkProxyAdmin.getNetworkProxy(remoteRepository.getRemoteDownloadNetworkProxyId())) == null) {
                    this.log.warn("your remote repository is configured to download remote index trought a proxy we cannot find id:{}", (Object)remoteRepository.getRemoteDownloadNetworkProxyId());
                }
                DownloadRemoteIndexTaskRequest downloadRemoteIndexTaskRequest = new DownloadRemoteIndexTaskRequest().setRemoteRepository(remoteRepository).setNetworkProxy(networkProxy).setFullDownload(fullDownload).setWagonFactory(this.wagonFactory).setRemoteRepositoryAdmin(this.remoteRepositoryAdmin).setIndexUpdater(this.indexUpdater).setIndexPacker(this.indexPacker);
                if (now) {
                    this.log.info("schedule download remote index for repository {}", (Object)remoteRepository.getId());
                    this.taskScheduler.schedule((Runnable)new DownloadRemoteIndexTask(downloadRemoteIndexTaskRequest, this.runningRemoteDownloadIds), new Date());
                    break block8;
                }
                this.log.info("schedule download remote index for repository {} with cron expression {}", (Object)remoteRepository.getId(), (Object)remoteRepository.getCronExpression());
                try {
                    CronTrigger cronTrigger = new CronTrigger(remoteRepository.getCronExpression());
                    this.taskScheduler.schedule((Runnable)new DownloadRemoteIndexTask(downloadRemoteIndexTaskRequest, this.runningRemoteDownloadIds), (Trigger)cronTrigger);
                }
                catch (IllegalArgumentException e) {
                    this.log.warn("Unable to schedule remote index download: {}", (Object)e.getLocalizedMessage());
                }
                if (remoteRepository.isDownloadRemoteIndexOnStartup()) {
                    this.log.info("remote repository {} configured with downloadRemoteIndexOnStartup schedule now a download", (Object)remoteRepository.getId());
                    this.taskScheduler.schedule((Runnable)new DownloadRemoteIndexTask(downloadRemoteIndexTaskRequest, this.runningRemoteDownloadIds), new Date());
                }
            }
            catch (RepositoryAdminException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new DownloadRemoteIndexException(e.getMessage(), e);
            }
        }
    }

    public TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    @Override
    public List<String> getRunningRemoteDownloadIds() {
        return this.runningRemoteDownloadIds;
    }
}

