/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.webdav.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="mimeTpes")
public class MimeTypes {
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private String resource = "org/apache/archiva/webdav/util/mime.types";
    private Map<String, String> mimeMap = new HashMap<String, String>();
    private Logger log = LoggerFactory.getLogger(MimeTypes.class);

    public String getMimeType(String filename) {
        int index;
        String value = null;
        if (!StringUtils.isEmpty((String)filename) && (index = filename.lastIndexOf(46)) >= 0) {
            value = this.mimeMap.get(filename.substring(index + 1).toLowerCase());
        }
        if (value == null) {
            value = DEFAULT_MIME_TYPE;
        }
        return value;
    }

    @PostConstruct
    public void initialize() {
        this.load(this.resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) {
        if (!(file.exists() && file.isFile() && file.canRead())) {
            this.log.error("Unable to load mime types from file " + file.getAbsolutePath() + " : not a readable file.");
            return;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            try {
                this.log.error("Unable to load mime types from file " + file.getAbsolutePath() + " : " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fis);
        }
        IOUtils.closeQuietly((InputStream)fis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String resourceName) {
        ClassLoader cloader = this.getClass().getClassLoader();
        URL mimeURL = cloader.getResource(resourceName);
        if (mimeURL == null) {
            throw new IllegalStateException("Unable to find resource " + resourceName);
        }
        InputStream mimeStream = null;
        try {
            mimeStream = mimeURL.openStream();
            this.load(mimeStream);
        }
        catch (IOException e) {
            this.log.error("Unable to load mime map " + resourceName + " : " + e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)mimeStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream mimeStream) {
        this.mimeMap.clear();
        InputStreamReader reader = null;
        BufferedReader buf = null;
        try {
            reader = new InputStreamReader(mimeStream);
            buf = new BufferedReader(reader);
            String line = null;
            while ((line = buf.readLine()) != null) {
                StringTokenizer tokenizer;
                if ((line = line.trim()).length() == 0 || line.startsWith("#") || (tokenizer = new StringTokenizer(line)).countTokens() <= 1) continue;
                String type = tokenizer.nextToken();
                while (tokenizer.hasMoreTokens()) {
                    String extension = tokenizer.nextToken().toLowerCase();
                    this.mimeMap.put(extension, type);
                }
            }
        }
        catch (IOException e) {
            try {
                this.log.error("Unable to read mime types from input stream : " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(buf);
                IOUtils.closeQuietly((Reader)reader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)buf);
            IOUtils.closeQuietly((Reader)reader);
        }
        IOUtils.closeQuietly((Reader)buf);
        IOUtils.closeQuietly((Reader)reader);
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }
}

