/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.webdav;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.admin.model.beans.RemoteRepository;
import org.apache.archiva.admin.model.managed.ManagedRepositoryAdmin;
import org.apache.archiva.admin.model.remote.RemoteRepositoryAdmin;
import org.apache.archiva.audit.Auditable;
import org.apache.archiva.common.filelock.FileLockManager;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridge;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridgeException;
import org.apache.archiva.common.utils.PathUtil;
import org.apache.archiva.common.utils.VersionUtil;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.RepositoryGroupConfiguration;
import org.apache.archiva.indexer.merger.IndexMerger;
import org.apache.archiva.indexer.merger.IndexMergerException;
import org.apache.archiva.indexer.merger.IndexMergerRequest;
import org.apache.archiva.indexer.merger.MergedRemoteIndexesTask;
import org.apache.archiva.indexer.merger.MergedRemoteIndexesTaskRequest;
import org.apache.archiva.indexer.merger.TemporaryGroupIndex;
import org.apache.archiva.indexer.search.RepositorySearch;
import org.apache.archiva.maven2.metadata.MavenMetadataReader;
import org.apache.archiva.metadata.model.facets.AuditEvent;
import org.apache.archiva.metadata.repository.storage.RelocationException;
import org.apache.archiva.metadata.repository.storage.RepositoryStorage;
import org.apache.archiva.model.ArchivaRepositoryMetadata;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.policies.ProxyDownloadException;
import org.apache.archiva.proxy.model.RepositoryProxyConnectors;
import org.apache.archiva.redback.authentication.AuthenticationException;
import org.apache.archiva.redback.authentication.AuthenticationResult;
import org.apache.archiva.redback.authorization.AuthorizationException;
import org.apache.archiva.redback.authorization.UnauthorizedException;
import org.apache.archiva.redback.integration.filter.authentication.HttpAuthenticator;
import org.apache.archiva.redback.policy.AccountLockedException;
import org.apache.archiva.redback.policy.MustChangePasswordException;
import org.apache.archiva.redback.system.SecuritySession;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.repository.ManagedRepositoryContent;
import org.apache.archiva.repository.RepositoryContentFactory;
import org.apache.archiva.repository.RepositoryException;
import org.apache.archiva.repository.RepositoryNotFoundException;
import org.apache.archiva.repository.content.legacy.LegacyPathParser;
import org.apache.archiva.repository.content.maven2.RepositoryRequest;
import org.apache.archiva.repository.events.AuditListener;
import org.apache.archiva.repository.layout.LayoutException;
import org.apache.archiva.repository.metadata.MetadataTools;
import org.apache.archiva.repository.metadata.RepositoryMetadataException;
import org.apache.archiva.repository.metadata.RepositoryMetadataMerge;
import org.apache.archiva.repository.metadata.RepositoryMetadataWriter;
import org.apache.archiva.scheduler.repository.model.RepositoryArchivaTaskScheduler;
import org.apache.archiva.security.ServletAuthenticator;
import org.apache.archiva.webdav.ArchivaDavResource;
import org.apache.archiva.webdav.ArchivaDavResourceLocator;
import org.apache.archiva.webdav.ArchivaVirtualDavResource;
import org.apache.archiva.webdav.BrowserRedirectException;
import org.apache.archiva.webdav.UnauthorizedDavException;
import org.apache.archiva.webdav.util.MimeTypes;
import org.apache.archiva.webdav.util.TemporaryGroupIndexSessionCleaner;
import org.apache.archiva.webdav.util.WebdavMethodUtil;
import org.apache.archiva.xml.XMLException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.DavServletResponse;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.SimpleLockManager;
import org.apache.maven.index.context.IndexingContext;
import org.codehaus.plexus.digest.ChecksumFile;
import org.codehaus.plexus.digest.Digester;
import org.codehaus.plexus.digest.DigesterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="davResourceFactory#archiva")
public class ArchivaDavResourceFactory
implements DavResourceFactory,
Auditable {
    private static final String PROXIED_SUFFIX = " (proxied)";
    private static final String HTTP_PUT_METHOD = "PUT";
    private Logger log = LoggerFactory.getLogger(ArchivaDavResourceFactory.class);
    @Inject
    private List<AuditListener> auditListeners = new ArrayList<AuditListener>();
    @Inject
    private RepositoryContentFactory repositoryFactory;
    private RepositoryRequest repositoryRequest;
    @Inject
    @Named(value="repositoryProxyConnectors#default")
    private RepositoryProxyConnectors connectors;
    @Inject
    private MetadataTools metadataTools;
    @Inject
    private MimeTypes mimeTypes;
    private ArchivaConfiguration archivaConfiguration;
    @Inject
    private ServletAuthenticator servletAuth;
    @Inject
    @Named(value="httpAuthenticator#basic")
    private HttpAuthenticator httpAuth;
    @Inject
    private RemoteRepositoryAdmin remoteRepositoryAdmin;
    @Inject
    private ManagedRepositoryAdmin managedRepositoryAdmin;
    @Inject
    private IndexMerger indexMerger;
    @Inject
    private RepositorySearch repositorySearch;
    private final LockManager lockManager = new SimpleLockManager();
    private ChecksumFile checksum;
    private Digester digestSha1;
    private Digester digestMd5;
    @Inject
    @Named(value="archivaTaskScheduler#repository")
    private RepositoryArchivaTaskScheduler scheduler;
    @Inject
    @Named(value="fileLockManager#default")
    private FileLockManager fileLockManager;
    private ApplicationContext applicationContext;

    @Inject
    public ArchivaDavResourceFactory(ApplicationContext applicationContext, PlexusSisuBridge plexusSisuBridge, ArchivaConfiguration archivaConfiguration) throws PlexusSisuBridgeException {
        this.archivaConfiguration = archivaConfiguration;
        this.applicationContext = applicationContext;
        this.checksum = (ChecksumFile)plexusSisuBridge.lookup(ChecksumFile.class);
        this.digestMd5 = (Digester)plexusSisuBridge.lookup(Digester.class, "md5");
        this.digestSha1 = (Digester)plexusSisuBridge.lookup(Digester.class, "sha1");
        this.repositoryRequest = new RepositoryRequest(new LegacyPathParser(archivaConfiguration));
    }

    @PostConstruct
    public void initialize() {
    }

    public DavResource createResource(DavResourceLocator locator, DavServletRequest request, DavServletResponse response) throws DavException {
        DavResource resource;
        ArchivaDavResourceLocator archivaLocator = this.checkLocatorIsInstanceOfRepositoryLocator(locator);
        RepositoryGroupConfiguration repoGroupConfig = (RepositoryGroupConfiguration)this.archivaConfiguration.getConfiguration().getRepositoryGroupsAsMap().get(archivaLocator.getRepositoryId());
        String activePrincipal = this.getActivePrincipal(request);
        ArrayList<String> resourcesInAbsolutePath = new ArrayList<String>();
        boolean readMethod = WebdavMethodUtil.isReadMethod(request.getMethod());
        if (repoGroupConfig != null) {
            if (!readMethod) {
                throw new DavException(405, "Write method not allowed for repository groups.");
            }
            this.log.debug("Repository group '{}' accessed by '{}", (Object)repoGroupConfig.getId(), (Object)activePrincipal);
            if (this.getLogicalResource(archivaLocator, null, true).endsWith("/")) {
                try {
                    DavResource davResource = this.getResourceFromGroup(request, repoGroupConfig.getRepositories(), archivaLocator, repoGroupConfig);
                    this.setHeaders(response, locator, davResource, true);
                    return davResource;
                }
                catch (RepositoryAdminException e) {
                    throw new DavException(500, (Throwable)e);
                }
            }
            ArrayList<String> repositories = new ArrayList<String>(repoGroupConfig.getRepositories());
            resource = this.processRepositoryGroup(request, archivaLocator, repositories, activePrincipal, resourcesInAbsolutePath, repoGroupConfig);
        } else {
            try {
                RemoteRepository remoteRepository = this.remoteRepositoryAdmin.getRemoteRepository(archivaLocator.getRepositoryId());
                if (remoteRepository != null) {
                    String logicalResource = this.getLogicalResource(archivaLocator, null, false);
                    IndexingContext indexingContext = this.remoteRepositoryAdmin.createIndexContext(remoteRepository);
                    File resourceFile = StringUtils.equals((String)logicalResource, (String)"/") ? new File(indexingContext.getIndexDirectoryFile().getParent()) : new File(indexingContext.getIndexDirectoryFile().getParent(), logicalResource);
                    ArchivaDavResource resource2 = new ArchivaDavResource(resourceFile.getAbsolutePath(), locator.getResourcePath(), null, request.getRemoteAddr(), activePrincipal, request.getDavSession(), archivaLocator, this, this.mimeTypes, this.auditListeners, this.scheduler, this.fileLockManager);
                    this.setHeaders(response, locator, resource2, false);
                    return resource2;
                }
            }
            catch (RepositoryAdminException e) {
                this.log.debug("RepositoryException remote repository with d'{}' not found, msg: {}", (Object)archivaLocator.getRepositoryId(), (Object)e.getMessage());
            }
            ManagedRepositoryContent managedRepositoryContent = null;
            try {
                managedRepositoryContent = this.repositoryFactory.getManagedRepositoryContent(archivaLocator.getRepositoryId());
            }
            catch (RepositoryNotFoundException e) {
                throw new DavException(404, "Invalid repository: " + archivaLocator.getRepositoryId());
            }
            catch (RepositoryException e) {
                throw new DavException(500, (Throwable)e);
            }
            this.log.debug("Managed repository '{}' accessed by '{}'", (Object)managedRepositoryContent.getId(), (Object)activePrincipal);
            try {
                resource = this.processRepository(request, archivaLocator, activePrincipal, managedRepositoryContent, this.managedRepositoryAdmin.getManagedRepository(archivaLocator.getRepositoryId()));
                String logicalResource = this.getLogicalResource(archivaLocator, null, false);
                resourcesInAbsolutePath.add(new File(managedRepositoryContent.getRepoRoot(), logicalResource).getAbsolutePath());
            }
            catch (RepositoryAdminException e) {
                throw new DavException(500, (Throwable)e);
            }
        }
        String requestedResource = request.getRequestURI();
        if ((this.repositoryRequest.isMetadata(requestedResource) || this.repositoryRequest.isMetadataSupportFile(requestedResource)) && repoGroupConfig != null && this.isProjectReference(requestedResource)) {
            ArchivaDavResource res = (ArchivaDavResource)resource;
            String filePath = StringUtils.substringBeforeLast((String)res.getLocalResource().getAbsolutePath().replace('\\', '/'), (String)"/");
            filePath = filePath + "/maven-metadata-" + repoGroupConfig.getId() + ".xml";
            if (this.repositoryRequest.isSupportFile(requestedResource)) {
                File metadataChecksum = new File(filePath + "." + StringUtils.substringAfterLast((String)requestedResource, (String)"."));
                if (metadataChecksum.exists()) {
                    LogicalResource logicalResource = new LogicalResource(this.getLogicalResource(archivaLocator, null, false));
                    resource = new ArchivaDavResource(metadataChecksum.getAbsolutePath(), logicalResource.getPath(), null, request.getRemoteAddr(), activePrincipal, request.getDavSession(), archivaLocator, this, this.mimeTypes, this.auditListeners, this.scheduler, this.fileLockManager);
                }
            } else if (resourcesInAbsolutePath != null && resourcesInAbsolutePath.size() > 1) {
                ArchivaRepositoryMetadata mergedMetadata = new ArchivaRepositoryMetadata();
                for (String resourceAbsPath : resourcesInAbsolutePath) {
                    try {
                        File metadataFile = new File(resourceAbsPath);
                        ArchivaRepositoryMetadata repoMetadata = MavenMetadataReader.read((File)metadataFile);
                        mergedMetadata = RepositoryMetadataMerge.merge((ArchivaRepositoryMetadata)mergedMetadata, (ArchivaRepositoryMetadata)repoMetadata);
                    }
                    catch (XMLException e) {
                        throw new DavException(500, "Error occurred while reading metadata file.");
                    }
                    catch (RepositoryMetadataException r) {
                        throw new DavException(500, "Error occurred while merging metadata file.");
                    }
                }
                try {
                    File resourceFile = this.writeMergedMetadataToFile(mergedMetadata, filePath);
                    LogicalResource logicalResource = new LogicalResource(this.getLogicalResource(archivaLocator, null, false));
                    resource = new ArchivaDavResource(resourceFile.getAbsolutePath(), logicalResource.getPath(), null, request.getRemoteAddr(), activePrincipal, request.getDavSession(), archivaLocator, this, this.mimeTypes, this.auditListeners, this.scheduler, this.fileLockManager);
                }
                catch (RepositoryMetadataException r) {
                    throw new DavException(500, "Error occurred while writing metadata file.");
                }
                catch (IOException ie) {
                    throw new DavException(500, "Error occurred while generating checksum files.");
                }
                catch (DigesterException de) {
                    throw new DavException(500, "Error occurred while generating checksum files." + de.getMessage());
                }
            }
        }
        this.setHeaders(response, locator, resource, false);
        if (resource.isCollection() && !request.getRequestURI().endsWith("/")) {
            throw new BrowserRedirectException(resource.getHref());
        }
        resource.addLockManager(this.lockManager);
        return resource;
    }

    private DavResource processRepositoryGroup(DavServletRequest request, ArchivaDavResourceLocator archivaLocator, List<String> repositories, String activePrincipal, List<String> resourcesInAbsolutePath, RepositoryGroupConfiguration repoGroupConfig) throws DavException {
        DavResource resource = null;
        ArrayList<DavException> storedExceptions = new ArrayList<DavException>();
        String pathInfo = StringUtils.removeEnd((String)request.getPathInfo(), (String)"/");
        String rootPath = StringUtils.substringBeforeLast((String)pathInfo, (String)"/");
        if (StringUtils.endsWith((String)rootPath, (String)repoGroupConfig.getMergedIndexPath())) {
            String requestedFileName = StringUtils.substringAfterLast((String)pathInfo, (String)"/");
            File temporaryIndexDirectory = this.buildMergedIndexDirectory(repositories, activePrincipal, request, repoGroupConfig);
            File resourceFile = new File(temporaryIndexDirectory, requestedFileName);
            resource = new ArchivaDavResource(resourceFile.getAbsolutePath(), requestedFileName, null, request.getRemoteAddr(), activePrincipal, request.getDavSession(), archivaLocator, this, this.mimeTypes, this.auditListeners, this.scheduler, this.fileLockManager);
        } else {
            for (String repositoryId : repositories) {
                ManagedRepositoryContent managedRepositoryContent;
                try {
                    managedRepositoryContent = this.repositoryFactory.getManagedRepositoryContent(repositoryId);
                }
                catch (RepositoryNotFoundException e) {
                    throw new DavException(500, (Throwable)e);
                }
                catch (RepositoryException e) {
                    throw new DavException(500, (Throwable)e);
                }
                try {
                    String logicalResource;
                    ManagedRepository managedRepository = this.managedRepositoryAdmin.getManagedRepository(repositoryId);
                    DavResource updatedResource = this.processRepository(request, archivaLocator, activePrincipal, managedRepositoryContent, managedRepository);
                    if (resource == null) {
                        resource = updatedResource;
                    }
                    if ((logicalResource = this.getLogicalResource(archivaLocator, null, false)).endsWith("/")) {
                        logicalResource = logicalResource.substring(1);
                    }
                    resourcesInAbsolutePath.add(new File(managedRepositoryContent.getRepoRoot(), logicalResource).getAbsolutePath());
                }
                catch (DavException e) {
                    storedExceptions.add(e);
                }
                catch (RepositoryAdminException e) {
                    storedExceptions.add(new DavException(500, (Throwable)e));
                }
            }
        }
        if (resource == null) {
            if (!storedExceptions.isEmpty()) {
                for (DavException e : storedExceptions) {
                    if (401 != e.getErrorCode()) continue;
                    throw e;
                }
                throw new DavException(404);
            }
            throw new DavException(404);
        }
        return resource;
    }

    private String getLogicalResource(ArchivaDavResourceLocator archivaLocator, ManagedRepository managedRepository, boolean useOrigResourcePath) {
        String layout = managedRepository == null ? new ManagedRepository().getLayout() : managedRepository.getLayout();
        RepositoryStorage repositoryStorage = (RepositoryStorage)this.applicationContext.getBean("repositoryStorage#" + layout, RepositoryStorage.class);
        String path = repositoryStorage.getFilePath(useOrigResourcePath ? archivaLocator.getOrigResourcePath() : archivaLocator.getResourcePath(), managedRepository);
        this.log.debug("found path {} for resourcePath: '{}' with managedRepo '{}' and layout '{}'", new Object[]{path, archivaLocator.getResourcePath(), managedRepository == null ? "null" : managedRepository.getId(), layout});
        return path;
    }

    private String evaluatePathWithVersion(ArchivaDavResourceLocator archivaLocator, ManagedRepositoryContent managedRepositoryContent, String contextPath) throws DavException {
        String layout = managedRepositoryContent.getRepository() == null ? new ManagedRepository().getLayout() : managedRepositoryContent.getRepository().getLayout();
        RepositoryStorage repositoryStorage = (RepositoryStorage)this.applicationContext.getBean("repositoryStorage#" + layout, RepositoryStorage.class);
        try {
            return repositoryStorage.getFilePathWithVersion(archivaLocator.getResourcePath(), managedRepositoryContent);
        }
        catch (RelocationException e) {
            String path = e.getPath();
            this.log.debug("Relocation to {}", (Object)path);
            throw new BrowserRedirectException(contextPath + (StringUtils.startsWith((String)path, (String)"/") ? "" : "/") + path, e.getRelocationType());
        }
        catch (XMLException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new DavException(500, (Throwable)e);
        }
    }

    private DavResource processRepository(DavServletRequest request, ArchivaDavResourceLocator archivaLocator, String activePrincipal, ManagedRepositoryContent managedRepositoryContent, ManagedRepository managedRepository) throws DavException {
        ArchivaDavResource resource = null;
        if (this.isAuthorized(request, managedRepositoryContent.getId())) {
            String path;
            boolean readMethod = WebdavMethodUtil.isReadMethod(request.getMethod());
            String string = path = readMethod ? this.evaluatePathWithVersion(archivaLocator, managedRepositoryContent, request.getContextPath()) : this.getLogicalResource(archivaLocator, managedRepository, false);
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            LogicalResource logicalResource = new LogicalResource(path);
            File resourceFile = new File(managedRepositoryContent.getRepoRoot(), path);
            resource = new ArchivaDavResource(resourceFile.getAbsolutePath(), path, managedRepositoryContent.getRepository(), request.getRemoteAddr(), activePrincipal, request.getDavSession(), archivaLocator, this, this.mimeTypes, this.auditListeners, this.scheduler, this.fileLockManager);
            if (WebdavMethodUtil.isReadMethod(request.getMethod())) {
                if (archivaLocator.getHref(false).endsWith("/") && !resourceFile.isDirectory()) {
                    throw new DavException(404, "Resource does not exist");
                }
                if (!resource.isCollection()) {
                    boolean fromProxy;
                    boolean previouslyExisted;
                    block15: {
                        previouslyExisted = resourceFile.exists();
                        fromProxy = this.fetchContentFromProxies(managedRepositoryContent, request, logicalResource);
                        try {
                            String localResourcePath = this.repositoryRequest.toNativePath(logicalResource.getPath(), managedRepositoryContent);
                            resourceFile = new File(managedRepositoryContent.getRepoRoot(), localResourcePath);
                            resource = new ArchivaDavResource(resourceFile.getAbsolutePath(), logicalResource.getPath(), managedRepositoryContent.getRepository(), request.getRemoteAddr(), activePrincipal, request.getDavSession(), archivaLocator, this, this.mimeTypes, this.auditListeners, this.scheduler, this.fileLockManager);
                        }
                        catch (LayoutException e) {
                            if (resourceFile.exists()) break block15;
                            throw new DavException(404, (Throwable)e);
                        }
                    }
                    if (fromProxy) {
                        String event = (previouslyExisted ? "Modified File" : "Created File") + PROXIED_SUFFIX;
                        this.log.debug("Proxied artifact '{}' in repository '{}' (current user '{}')", new Object[]{resourceFile.getName(), managedRepositoryContent.getId(), activePrincipal});
                        this.triggerAuditEvent(request.getRemoteAddr(), archivaLocator.getRepositoryId(), logicalResource.getPath(), event, activePrincipal);
                    }
                    if (!resourceFile.exists()) {
                        throw new DavException(404, "Resource does not exist");
                    }
                }
            }
            if (request.getMethod().equals(HTTP_PUT_METHOD)) {
                File rootDirectory;
                File destDir;
                String resourcePath = logicalResource.getPath();
                if (managedRepositoryContent.getRepository().isReleases() && !this.repositoryRequest.isMetadata(resourcePath) && !this.repositoryRequest.isSupportFile(resourcePath)) {
                    ArtifactReference artifact = null;
                    try {
                        artifact = managedRepositoryContent.toArtifactReference(resourcePath);
                        if (!VersionUtil.isSnapshot((String)artifact.getVersion()) && managedRepositoryContent.hasContent(artifact) && managedRepositoryContent.getRepository().isBlockRedeployments()) {
                            this.log.warn("Overwriting released artifacts in repository '{}' is not allowed.", (Object)managedRepositoryContent.getId());
                            throw new DavException(409, "Overwriting released artifacts is not allowed.");
                        }
                    }
                    catch (LayoutException e) {
                        this.log.warn("Artifact path '{}' is invalid.", (Object)resourcePath);
                    }
                }
                if (!(destDir = new File(rootDirectory = new File(managedRepositoryContent.getRepoRoot()), logicalResource.getPath()).getParentFile()).exists()) {
                    destDir.mkdirs();
                    String relPath = PathUtil.getRelative((String)rootDirectory.getAbsolutePath(), (File)destDir);
                    this.log.debug("Creating destination directory '{}' (current user '{}')", (Object)destDir.getName(), (Object)activePrincipal);
                    this.triggerAuditEvent(request.getRemoteAddr(), managedRepositoryContent.getId(), relPath, "Created Directory", activePrincipal);
                }
            }
        }
        return resource;
    }

    public DavResource createResource(DavResourceLocator locator, DavSession davSession) throws DavException {
        ManagedRepositoryContent managedRepositoryContent;
        ArchivaDavResourceLocator archivaLocator = this.checkLocatorIsInstanceOfRepositoryLocator(locator);
        try {
            managedRepositoryContent = this.repositoryFactory.getManagedRepositoryContent(archivaLocator.getRepositoryId());
        }
        catch (RepositoryNotFoundException e) {
            throw new DavException(404, "Invalid repository: " + archivaLocator.getRepositoryId());
        }
        catch (RepositoryException e) {
            throw new DavException(500, (Throwable)e);
        }
        ArchivaDavResource resource = null;
        try {
            String logicalResource = this.getLogicalResource(archivaLocator, this.managedRepositoryAdmin.getManagedRepository(archivaLocator.getRepositoryId()), false);
            if (logicalResource.startsWith("/")) {
                logicalResource = logicalResource.substring(1);
            }
            File resourceFile = new File(managedRepositoryContent.getRepoRoot(), logicalResource);
            resource = new ArchivaDavResource(resourceFile.getAbsolutePath(), logicalResource, managedRepositoryContent.getRepository(), davSession, archivaLocator, this, this.mimeTypes, this.auditListeners, this.scheduler, this.fileLockManager);
            resource.addLockManager(this.lockManager);
        }
        catch (RepositoryAdminException e) {
            throw new DavException(500, (Throwable)e);
        }
        return resource;
    }

    private boolean fetchContentFromProxies(ManagedRepositoryContent managedRepository, DavServletRequest request, LogicalResource resource) throws DavException {
        String path = resource.getPath();
        if (this.repositoryRequest.isSupportFile(path)) {
            File proxiedFile = this.connectors.fetchFromProxies(managedRepository, path);
            return proxiedFile != null;
        }
        if (this.repositoryRequest.isDefault(path) && this.repositoryRequest.isMetadata(path)) {
            return this.connectors.fetchMetatadaFromProxies(managedRepository, path) != null;
        }
        if (this.repositoryRequest.isArchetypeCatalog(path)) {
            File proxiedFile = this.connectors.fetchFromProxies(managedRepository, path);
            return proxiedFile != null;
        }
        try {
            ArtifactReference artifact = this.repositoryRequest.toArtifactReference(path);
            if (artifact != null) {
                String repositoryLayout = managedRepository.getRepository().getLayout();
                RepositoryStorage repositoryStorage = (RepositoryStorage)this.applicationContext.getBean("repositoryStorage#" + repositoryLayout, RepositoryStorage.class);
                repositoryStorage.applyServerSideRelocation(managedRepository, artifact);
                File proxiedFile = this.connectors.fetchFromProxies(managedRepository, artifact);
                resource.setPath(managedRepository.toPath(artifact));
                this.log.debug("Proxied artifact '{}:{}:{}'", new Object[]{artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()});
                return proxiedFile != null;
            }
        }
        catch (LayoutException e) {
        }
        catch (ProxyDownloadException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new DavException(500, "Unable to fetch artifact resource.");
        }
        return false;
    }

    private void triggerAuditEvent(String remoteIP, String repositoryId, String resource, String action, String principal) {
        AuditEvent event = new AuditEvent(repositoryId, principal, resource, action);
        event.setRemoteIP(remoteIP);
        for (AuditListener listener : this.auditListeners) {
            listener.auditEvent(event);
        }
    }

    public void addAuditListener(AuditListener listener) {
        this.auditListeners.add(listener);
    }

    public void clearAuditListeners() {
        this.auditListeners.clear();
    }

    public void removeAuditListener(AuditListener listener) {
        this.auditListeners.remove(listener);
    }

    private void setHeaders(DavServletResponse response, DavResourceLocator locator, DavResource resource, boolean group) {
        if (locator.getResourcePath().endsWith("/maven-metadata.xml") || resource instanceof ArchivaDavResource && ((ArchivaDavResource)ArchivaDavResource.class.cast(resource)).getLocalResource().isDirectory()) {
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Last-Modified", new Date().getTime());
        } else if (locator.getResourcePath().endsWith("/maven-metadata.xml") || resource instanceof ArchivaVirtualDavResource && new File(((ArchivaVirtualDavResource)ArchivaVirtualDavResource.class.cast(resource)).getLogicalResource()).isDirectory()) {
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Last-Modified", new Date().getTime());
        } else if (group) {
            if (resource instanceof ArchivaVirtualDavResource) {
                response.setDateHeader("Last-Modified", new Date().getTime());
            }
        } else {
            response.setDateHeader("Last-Modified", resource.getModificationTime());
        }
    }

    private ArchivaDavResourceLocator checkLocatorIsInstanceOfRepositoryLocator(DavResourceLocator locator) throws DavException {
        if (!(locator instanceof ArchivaDavResourceLocator)) {
            throw new DavException(500, "Locator does not implement RepositoryLocator");
        }
        if (locator.getResourcePath().startsWith(".")) {
            throw new DavException(404);
        }
        ArchivaDavResourceLocator archivaLocator = (ArchivaDavResourceLocator)locator;
        if (StringUtils.isEmpty((String)archivaLocator.getRepositoryId())) {
            throw new DavException(204);
        }
        return archivaLocator;
    }

    protected boolean isAuthorized(DavServletRequest request, String repositoryId) throws DavException {
        try {
            AuthenticationResult result = this.httpAuth.getAuthenticationResult((HttpServletRequest)request, null);
            SecuritySession securitySession = this.httpAuth.getSecuritySession(request.getSession(true));
            return this.servletAuth.isAuthenticated((HttpServletRequest)request, result) && this.servletAuth.isAuthorized((HttpServletRequest)request, securitySession, repositoryId, WebdavMethodUtil.getMethodPermission(request.getMethod()));
        }
        catch (AuthenticationException e) {
            String guest = "guest";
            try {
                if (this.servletAuth.isAuthorized(guest, ((ArchivaDavResourceLocator)request.getRequestLocator()).getRepositoryId(), WebdavMethodUtil.getMethodPermission(request.getMethod()))) {
                    return true;
                }
            }
            catch (UnauthorizedException ae) {
                throw new UnauthorizedDavException(repositoryId, "You are not authenticated and authorized to access any repository.");
            }
            throw new UnauthorizedDavException(repositoryId, "You are not authenticated");
        }
        catch (MustChangePasswordException e) {
            throw new UnauthorizedDavException(repositoryId, "You must change your password.");
        }
        catch (AccountLockedException e) {
            throw new UnauthorizedDavException(repositoryId, "User account is locked.");
        }
        catch (AuthorizationException e) {
            throw new DavException(500, "Fatal Authorization Subsystem Error.");
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedDavException(repositoryId, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DavResource getResourceFromGroup(DavServletRequest request, List<String> repositories, ArchivaDavResourceLocator locator, RepositoryGroupConfiguration repositoryGroupConfiguration) throws DavException, RepositoryAdminException {
        if (repositoryGroupConfiguration.getRepositories() == null || repositoryGroupConfiguration.getRepositories().isEmpty()) {
            File file = new File(System.getProperty("appserver.base"), "groups/" + repositoryGroupConfiguration.getId());
            return new ArchivaDavResource(file.getPath(), "groups/" + repositoryGroupConfiguration.getId(), null, request.getDavSession(), locator, this, this.mimeTypes, this.auditListeners, this.scheduler, this.fileLockManager);
        }
        ArrayList<File> mergedRepositoryContents = new ArrayList<File>();
        String firstRepoId = (String)repositoryGroupConfiguration.getRepositories().get(0);
        String path = this.getLogicalResource(locator, this.managedRepositoryAdmin.getManagedRepository(firstRepoId), false);
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        LogicalResource logicalResource = new LogicalResource(path);
        String activePrincipal = this.getActivePrincipal(request);
        boolean allow = this.isAllowedToContinue(request, repositories, activePrincipal);
        String pathInfo = StringUtils.removeEnd((String)request.getPathInfo(), (String)"/");
        if (allow) {
            if (StringUtils.endsWith((String)pathInfo, (String)repositoryGroupConfiguration.getMergedIndexPath())) {
                File mergedRepoDir = this.buildMergedIndexDirectory(repositories, activePrincipal, request, repositoryGroupConfiguration);
                mergedRepositoryContents.add(mergedRepoDir);
            } else {
                if (StringUtils.equalsIgnoreCase((String)pathInfo, (String)("/" + repositoryGroupConfiguration.getId()))) {
                    File tmpDirectory = new File(SystemUtils.getJavaIoTmpDir(), repositoryGroupConfiguration.getId() + "/" + repositoryGroupConfiguration.getMergedIndexPath());
                    if (!tmpDirectory.exists()) {
                        String string = tmpDirectory.getAbsolutePath();
                        synchronized (string) {
                            if (!tmpDirectory.exists()) {
                                tmpDirectory.mkdirs();
                            }
                        }
                    }
                    mergedRepositoryContents.add(tmpDirectory.getParentFile());
                }
                for (String repository : repositories) {
                    ManagedRepositoryContent managedRepository = null;
                    try {
                        managedRepository = this.repositoryFactory.getManagedRepositoryContent(repository);
                    }
                    catch (RepositoryNotFoundException e) {
                        throw new DavException(500, "Invalid managed repository <" + repository + ">: " + e.getMessage());
                    }
                    catch (RepositoryException e) {
                        throw new DavException(500, "Invalid managed repository <" + repository + ">: " + e.getMessage());
                    }
                    File resourceFile = new File(managedRepository.getRepoRoot(), logicalResource.getPath());
                    if (!resourceFile.exists()) continue;
                    String repoIndexDirectory = managedRepository.getRepository().getIndexDirectory();
                    if (StringUtils.isNotEmpty((String)repoIndexDirectory) && !new File(repoIndexDirectory).isAbsolute()) {
                        repoIndexDirectory = new File(managedRepository.getRepository().getLocation(), StringUtils.isEmpty((String)repoIndexDirectory) ? ".indexer" : repoIndexDirectory).getAbsolutePath();
                    }
                    if (StringUtils.isEmpty((String)repoIndexDirectory)) {
                        repoIndexDirectory = new File(managedRepository.getRepository().getLocation(), ".indexer").getAbsolutePath();
                    }
                    if (StringUtils.equals((String)FilenameUtils.normalize((String)repoIndexDirectory), (String)FilenameUtils.normalize((String)resourceFile.getAbsolutePath()))) continue;
                    if (this.httpAuth.getSecuritySession(request.getSession(true)) != null) {
                        try {
                            if (!this.isAuthorized(request, repository)) continue;
                            mergedRepositoryContents.add(resourceFile);
                            this.log.debug("Repository '{}' accessed by '{}'", (Object)repository, (Object)activePrincipal);
                        }
                        catch (DavException e) {
                            this.log.debug("Skipping repository '{}' for user '{}': {}", new Object[]{managedRepository, activePrincipal, e.getMessage()});
                        }
                        continue;
                    }
                    try {
                        if (!this.servletAuth.isAuthorized(activePrincipal, repository, WebdavMethodUtil.getMethodPermission(request.getMethod()))) continue;
                        mergedRepositoryContents.add(resourceFile);
                        this.log.debug("Repository '{}' accessed by '{}'", (Object)repository, (Object)activePrincipal);
                    }
                    catch (UnauthorizedException e) {
                        this.log.debug("Skipping repository '{}' for user '{}': {}", new Object[]{managedRepository, activePrincipal, e.getMessage()});
                    }
                }
            }
        } else {
            throw new UnauthorizedDavException(locator.getRepositoryId(), "User not authorized.");
        }
        ArchivaVirtualDavResource resource = new ArchivaVirtualDavResource(mergedRepositoryContents, logicalResource.getPath(), this.mimeTypes, locator, this);
        if (resource.isCollection() && !request.getRequestURI().endsWith("/")) {
            throw new BrowserRedirectException(resource.getHref());
        }
        return resource;
    }

    protected String getActivePrincipal(DavServletRequest request) {
        User sessionUser = this.httpAuth.getSessionUser(request.getSession());
        return sessionUser != null ? sessionUser.getUsername() : "guest";
    }

    private boolean isAllowedToContinue(DavServletRequest request, List<String> repositories, String activePrincipal) {
        if (repositories == null || repositories.isEmpty()) {
            return true;
        }
        boolean allow = false;
        if (this.httpAuth.getSecuritySession(request.getSession()) != null) {
            for (String repository : repositories) {
                try {
                    if (!this.isAuthorized(request, repository)) continue;
                    allow = true;
                    break;
                }
                catch (DavException e) {
                }
            }
        } else {
            for (String repository : repositories) {
                try {
                    if (!this.servletAuth.isAuthorized(activePrincipal, repository, WebdavMethodUtil.getMethodPermission(request.getMethod()))) continue;
                    allow = true;
                    break;
                }
                catch (UnauthorizedException e) {
                }
            }
        }
        return allow;
    }

    private File writeMergedMetadataToFile(ArchivaRepositoryMetadata mergedMetadata, String outputFilename) throws RepositoryMetadataException, DigesterException, IOException {
        File outputFile = new File(outputFilename);
        if (outputFile.exists()) {
            FileUtils.deleteQuietly((File)outputFile);
        }
        outputFile.getParentFile().mkdirs();
        RepositoryMetadataWriter.write((ArchivaRepositoryMetadata)mergedMetadata, (File)outputFile);
        this.createChecksumFile(outputFilename, this.digestSha1);
        this.createChecksumFile(outputFilename, this.digestMd5);
        return outputFile;
    }

    private void createChecksumFile(String path, Digester digester) throws DigesterException, IOException {
        File checksumFile = new File(path + digester.getFilenameExtension());
        if (!checksumFile.exists()) {
            FileUtils.deleteQuietly((File)checksumFile);
            this.checksum.createChecksum(new File(path), digester);
        } else if (!checksumFile.isFile()) {
            this.log.error("Checksum file is not a file.");
        }
    }

    private boolean isProjectReference(String requestedResource) {
        try {
            this.metadataTools.toVersionedReference(requestedResource);
            return false;
        }
        catch (RepositoryMetadataException re) {
            return true;
        }
    }

    protected File buildMergedIndexDirectory(List<String> repositories, String activePrincipal, DavServletRequest request, RepositoryGroupConfiguration repositoryGroupConfiguration) throws DavException {
        try {
            TemporaryGroupIndex tmp;
            HttpSession session = request.getSession();
            HashMap<String, TemporaryGroupIndex> temporaryGroupIndexMap = (HashMap<String, TemporaryGroupIndex>)session.getAttribute(TemporaryGroupIndexSessionCleaner.TEMPORARY_INDEX_SESSION_KEY);
            if (temporaryGroupIndexMap == null) {
                temporaryGroupIndexMap = new HashMap<String, TemporaryGroupIndex>();
            }
            if ((tmp = (TemporaryGroupIndex)temporaryGroupIndexMap.get(repositoryGroupConfiguration.getId())) != null && tmp.getDirectory() != null && tmp.getDirectory().exists()) {
                if (System.currentTimeMillis() - tmp.getCreationTime() > (long)(repositoryGroupConfiguration.getMergedIndexTtl() * 60 * 1000)) {
                    this.log.debug(MarkerFactory.getMarker((String)"group.merged.index"), "tmp group index '{}' is too old so delete it", (Object)repositoryGroupConfiguration.getId());
                    this.indexMerger.cleanTemporaryGroupIndex(tmp);
                } else {
                    this.log.debug(MarkerFactory.getMarker((String)"group.merged.index"), "merged index for group '{}' found in cache", (Object)repositoryGroupConfiguration.getId());
                    return tmp.getDirectory();
                }
            }
            HashSet<String> authzRepos = new HashSet<String>();
            String permission = WebdavMethodUtil.getMethodPermission(request.getMethod());
            for (String repository : repositories) {
                try {
                    if (!this.servletAuth.isAuthorized(activePrincipal, repository, permission)) continue;
                    authzRepos.add(repository);
                    authzRepos.addAll(this.repositorySearch.getRemoteIndexingContextIds(repository));
                }
                catch (UnauthorizedException e) {
                    this.log.debug("Skipping repository '{}' for user '{}': {}", new Object[]{repository, activePrincipal, e.getMessage()});
                }
            }
            this.log.info("generate temporary merged index for repository group '{}' for repositories '{}'", (Object)repositoryGroupConfiguration.getId(), authzRepos);
            File tempRepoFile = Files.createTempDirectory("temp", new FileAttribute[0]).toFile();
            tempRepoFile.deleteOnExit();
            IndexMergerRequest indexMergerRequest = new IndexMergerRequest(authzRepos, true, repositoryGroupConfiguration.getId(), repositoryGroupConfiguration.getMergedIndexPath(), repositoryGroupConfiguration.getMergedIndexTtl()).mergedIndexDirectory(tempRepoFile).temporary(true);
            MergedRemoteIndexesTaskRequest taskRequest = new MergedRemoteIndexesTaskRequest(indexMergerRequest, this.indexMerger);
            MergedRemoteIndexesTask job = new MergedRemoteIndexesTask(taskRequest);
            IndexingContext indexingContext = job.execute().getIndexingContext();
            File mergedRepoDir = indexingContext.getIndexDirectoryFile();
            TemporaryGroupIndex temporaryGroupIndex = new TemporaryGroupIndex(mergedRepoDir, indexingContext.getId(), repositoryGroupConfiguration.getId(), repositoryGroupConfiguration.getMergedIndexTtl()).setCreationTime(new Date().getTime());
            temporaryGroupIndexMap.put(repositoryGroupConfiguration.getId(), temporaryGroupIndex);
            session.setAttribute(TemporaryGroupIndexSessionCleaner.TEMPORARY_INDEX_SESSION_KEY, temporaryGroupIndexMap);
            return mergedRepoDir;
        }
        catch (RepositoryAdminException e) {
            throw new DavException(500, (Throwable)e);
        }
        catch (IndexMergerException e) {
            throw new DavException(500, (Throwable)e);
        }
        catch (IOException e) {
            throw new DavException(500, (Throwable)e);
        }
    }

    public void setServletAuth(ServletAuthenticator servletAuth) {
        this.servletAuth = servletAuth;
    }

    public void setHttpAuth(HttpAuthenticator httpAuth) {
        this.httpAuth = httpAuth;
    }

    public void setScheduler(RepositoryArchivaTaskScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setArchivaConfiguration(ArchivaConfiguration archivaConfiguration) {
        this.archivaConfiguration = archivaConfiguration;
    }

    public void setRepositoryFactory(RepositoryContentFactory repositoryFactory) {
        this.repositoryFactory = repositoryFactory;
    }

    public void setRepositoryRequest(RepositoryRequest repositoryRequest) {
        this.repositoryRequest = repositoryRequest;
    }

    public void setConnectors(RepositoryProxyConnectors connectors) {
        this.connectors = connectors;
    }

    public RemoteRepositoryAdmin getRemoteRepositoryAdmin() {
        return this.remoteRepositoryAdmin;
    }

    public void setRemoteRepositoryAdmin(RemoteRepositoryAdmin remoteRepositoryAdmin) {
        this.remoteRepositoryAdmin = remoteRepositoryAdmin;
    }

    public ManagedRepositoryAdmin getManagedRepositoryAdmin() {
        return this.managedRepositoryAdmin;
    }

    public void setManagedRepositoryAdmin(ManagedRepositoryAdmin managedRepositoryAdmin) {
        this.managedRepositoryAdmin = managedRepositoryAdmin;
    }

    private static class LogicalResource {
        private String path;

        public LogicalResource(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }
}

