/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.webdav;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.archiva.webdav.ArchivaDavResourceLocator;
import org.apache.archiva.webdav.util.IndexWriter;
import org.apache.archiva.webdav.util.MimeTypes;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.ResourceType;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class ArchivaVirtualDavResource
implements DavResource {
    private static final String COMPLIANCE_CLASS = "1";
    private ArchivaDavResourceLocator locator;
    private DavResourceFactory factory;
    private String logicalResource;
    private DavPropertySet properties;
    private boolean propsInitialized = false;
    private static final String METHODS = "OPTIONS, GET, HEAD, POST, TRACE, PROPFIND, PROPPATCH, MKCOL";
    private final List<File> localResources;

    public ArchivaVirtualDavResource(List<File> localResources, String logicalResource, MimeTypes mimeTypes, ArchivaDavResourceLocator locator, DavResourceFactory factory) {
        this.localResources = localResources;
        this.logicalResource = logicalResource;
        this.locator = locator;
        this.factory = factory;
        this.properties = new DavPropertySet();
    }

    public void spool(OutputContext outputContext) throws IOException {
        if (outputContext.hasStream()) {
            Collections.sort(this.localResources);
            ArrayList<File> localResourceFiles = new ArrayList<File>();
            for (File resourceFile : this.localResources) {
                if (!resourceFile.exists()) continue;
                localResourceFiles.add(resourceFile);
            }
            IndexWriter writer = new IndexWriter((DavResource)this, localResourceFiles, this.logicalResource);
            writer.write(outputContext);
        }
    }

    public void addLockManager(LockManager arg0) {
    }

    public void addMember(DavResource arg0, InputContext arg1) throws DavException {
    }

    public MultiStatusResponse alterProperties(List arg0) throws DavException {
        return null;
    }

    public MultiStatusResponse alterProperties(DavPropertySet arg0, DavPropertyNameSet arg1) throws DavException {
        return null;
    }

    public void copy(DavResource arg0, boolean arg1) throws DavException {
    }

    public boolean exists() {
        return true;
    }

    public ActiveLock getLock(Type arg0, Scope arg1) {
        return null;
    }

    public ActiveLock[] getLocks() {
        return null;
    }

    public DavResourceIterator getMembers() {
        return null;
    }

    public String getSupportedMethods() {
        return METHODS;
    }

    public long getModificationTime() {
        return 0L;
    }

    public boolean hasLock(Type arg0, Scope arg1) {
        return false;
    }

    public boolean isCollection() {
        return true;
    }

    public boolean isLockable(Type arg0, Scope arg1) {
        return false;
    }

    public ActiveLock lock(LockInfo arg0) throws DavException {
        return null;
    }

    public void move(DavResource arg0) throws DavException {
    }

    public ActiveLock refreshLock(LockInfo arg0, String arg1) throws DavException {
        return null;
    }

    public void removeMember(DavResource arg0) throws DavException {
    }

    public void unlock(String arg0) throws DavException {
    }

    public String getComplianceClass() {
        return COMPLIANCE_CLASS;
    }

    public DavResourceLocator getLocator() {
        return this.locator;
    }

    public String getResourcePath() {
        return this.locator.getResourcePath();
    }

    public String getHref() {
        return this.locator.getHref(this.isCollection());
    }

    public DavResourceFactory getFactory() {
        return this.factory;
    }

    public String getDisplayName() {
        String resPath = this.getResourcePath();
        return resPath != null ? Text.getName((String)resPath) : resPath;
    }

    public DavSession getSession() {
        return null;
    }

    public DavPropertyName[] getPropertyNames() {
        return this.getProperties().getPropertyNames();
    }

    public DavProperty getProperty(DavPropertyName name) {
        this.initProperties();
        return this.properties.get(name);
    }

    public DavPropertySet getProperties() {
        this.initProperties();
        return this.properties;
    }

    public void setProperty(DavProperty property) throws DavException {
    }

    public void removeProperty(DavPropertyName propertyName) throws DavException {
    }

    public DavResource getCollection() {
        DavResource parent = null;
        if (this.getResourcePath() != null && !this.getResourcePath().equals("/")) {
            String parentPath = Text.getRelativeParent((String)this.getResourcePath(), (int)1);
            if (parentPath.equals("")) {
                parentPath = "/";
            }
            DavResourceLocator parentloc = this.locator.getFactory().createResourceLocator(this.locator.getPrefix(), parentPath);
            try {
                parent = this.factory.createResource(parentloc, null);
            }
            catch (DavException e) {
                // empty catch block
            }
        }
        return parent;
    }

    protected void initProperties() {
        if (!this.exists() || this.propsInitialized) {
            return;
        }
        if (this.getDisplayName() != null) {
            this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.DISPLAYNAME, (Object)this.getDisplayName()));
        }
        if (this.isCollection()) {
            this.properties.add((DavProperty)new ResourceType(1));
            this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.ISCOLLECTION, (Object)COMPLIANCE_CLASS));
        } else {
            this.properties.add((DavProperty)new ResourceType(0));
            this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.ISCOLLECTION, (Object)"0"));
        }
        DateTime dt = new DateTime(0L);
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        String modifiedDate = fmt.print((ReadableInstant)dt);
        this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETLASTMODIFIED, (Object)modifiedDate));
        this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.CREATIONDATE, (Object)modifiedDate));
        this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLENGTH, (Object)0));
        this.propsInitialized = true;
    }

    public String getLogicalResource() {
        return this.logicalResource;
    }

    public void setLogicalResource(String logicalResource) {
        this.logicalResource = logicalResource;
    }
}

