/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.webdav.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="mimeTpes")
public class MimeTypes {
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private String resource = "org/apache/archiva/webdav/util/mime.types";
    private Map<String, String> mimeMap = new HashMap<String, String>();
    private Logger log = LoggerFactory.getLogger(MimeTypes.class);

    public String getMimeType(String filename) {
        int index;
        String value = null;
        if (!StringUtils.isEmpty((String)filename) && (index = filename.lastIndexOf(46)) >= 0) {
            value = this.mimeMap.get(filename.substring(index + 1).toLowerCase());
        }
        if (value == null) {
            value = DEFAULT_MIME_TYPE;
        }
        return value;
    }

    @PostConstruct
    public void initialize() {
        this.load(this.resource);
    }

    public void load(String resourceName) {
        ClassLoader cloader = this.getClass().getClassLoader();
        URL mimeURL = cloader.getResource(resourceName);
        if (mimeURL == null) {
            throw new IllegalStateException("Unable to find resource " + resourceName);
        }
        try (InputStream mimeStream = mimeURL.openStream();){
            this.load(mimeStream);
        }
        catch (IOException e) {
            this.log.error("Unable to load mime map " + resourceName + " : " + e.getMessage(), (Throwable)e);
        }
    }

    public void load(InputStream mimeStream) {
        this.mimeMap.clear();
        try (InputStreamReader reader = new InputStreamReader(mimeStream);
             BufferedReader buf = new BufferedReader(reader);){
            String line = null;
            while ((line = buf.readLine()) != null) {
                StringTokenizer tokenizer;
                if ((line = line.trim()).length() == 0 || line.startsWith("#") || (tokenizer = new StringTokenizer(line)).countTokens() <= 1) continue;
                String type = tokenizer.nextToken();
                while (tokenizer.hasMoreTokens()) {
                    String extension = tokenizer.nextToken().toLowerCase();
                    this.mimeMap.put(extension, type);
                }
            }
        }
        catch (IOException e) {
            this.log.error("Unable to read mime types from input stream : " + e.getMessage(), (Throwable)e);
        }
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }
}

