/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.web.xmlrpc.security;

import java.util.List;
import org.apache.archiva.web.xmlrpc.security.ServiceMethodsPermissionsMapping;
import org.apache.maven.archiva.security.ArchivaSecurityException;
import org.apache.maven.archiva.security.UserRepositories;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.common.XmlRpcHttpRequestConfigImpl;
import org.apache.xmlrpc.server.AbstractReflectiveHandlerMapping;
import org.codehaus.plexus.redback.authentication.AuthenticationDataSource;
import org.codehaus.plexus.redback.authentication.AuthenticationException;
import org.codehaus.plexus.redback.authentication.PasswordBasedAuthenticationDataSource;
import org.codehaus.plexus.redback.authorization.AuthorizationException;
import org.codehaus.plexus.redback.authorization.AuthorizationResult;
import org.codehaus.plexus.redback.policy.PolicyViolationException;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.redback.users.UserNotFoundException;

public class XmlRpcAuthenticator
implements AbstractReflectiveHandlerMapping.AuthenticationHandler {
    private final SecuritySystem securitySystem;
    private UserRepositories userRepositories;
    private String username;

    public XmlRpcAuthenticator(SecuritySystem securitySystem, UserRepositories userRepositories) {
        this.securitySystem = securitySystem;
        this.userRepositories = userRepositories;
    }

    public boolean isAuthorized(XmlRpcRequest pRequest) throws XmlRpcException {
        if (pRequest.getConfig() instanceof XmlRpcHttpRequestConfigImpl) {
            XmlRpcHttpRequestConfigImpl config = (XmlRpcHttpRequestConfigImpl)pRequest.getConfig();
            this.username = config.getBasicUserName();
            SecuritySession session = this.authenticate(new PasswordBasedAuthenticationDataSource(this.username, config.getBasicPassword()));
            String method = pRequest.getMethodName();
            AuthorizationResult result = this.authorize(session, method, this.username);
            return result.isAuthorized();
        }
        throw new XmlRpcException("Unsupported transport (must be http)");
    }

    private SecuritySession authenticate(PasswordBasedAuthenticationDataSource authenticationDataSource) throws XmlRpcException {
        try {
            return this.securitySystem.authenticate((AuthenticationDataSource)authenticationDataSource);
        }
        catch (PolicyViolationException e) {
            throw new XmlRpcException(401, e.getMessage(), (Throwable)e);
        }
        catch (AuthenticationException e) {
            throw new XmlRpcException(401, e.getMessage(), (Throwable)e);
        }
        catch (UserNotFoundException e) {
            throw new XmlRpcException(401, e.getMessage(), (Throwable)e);
        }
    }

    private AuthorizationResult authorize(SecuritySession session, String methodName, String username) throws XmlRpcException {
        try {
            if (ServiceMethodsPermissionsMapping.SERVICE_METHODS_FOR_OPERATION_MANAGE_CONFIGURATION.contains(methodName)) {
                return this.securitySystem.authorize(session, (Object)"archiva-manage-configuration");
            }
            if (ServiceMethodsPermissionsMapping.SERVICE_METHODS_FOR_OPERATION_RUN_INDEXER.contains(methodName)) {
                return this.securitySystem.authorize(session, (Object)"archiva-run-indexer");
            }
            if (ServiceMethodsPermissionsMapping.SERVICE_METHODS_FOR_OPERATION_REPOSITORY_ACCESS.contains(methodName)) {
                try {
                    List observableRepos = this.userRepositories.getObservableRepositoryIds(username);
                    if (observableRepos != null && observableRepos.size() > 1) {
                        return new AuthorizationResult(true, (Object)username, null);
                    }
                    return new AuthorizationResult(false, (Object)username, null);
                }
                catch (ArchivaSecurityException e) {
                    throw new XmlRpcException(401, e.getMessage());
                }
            }
            if (methodName.equals("PingService.ping")) {
                return new AuthorizationResult(true, (Object)username, null);
            }
            return this.securitySystem.authorize(session, (Object)"Global Repository Manager");
        }
        catch (AuthorizationException e) {
            throw new XmlRpcException(401, e.getMessage(), (Throwable)e);
        }
    }

    public String getActiveUser() {
        return this.username;
    }
}

