/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.web.xmlrpc.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.archiva.web.xmlrpc.api.AdministrationService;
import org.apache.archiva.web.xmlrpc.api.beans.ManagedRepository;
import org.apache.archiva.web.xmlrpc.api.beans.RemoteRepository;
import org.apache.maven.archiva.configuration.ArchivaConfiguration;
import org.apache.maven.archiva.configuration.Configuration;
import org.apache.maven.archiva.configuration.DatabaseScanningConfiguration;
import org.apache.maven.archiva.configuration.IndeterminateConfigurationException;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.configuration.RemoteRepositoryConfiguration;
import org.apache.maven.archiva.configuration.RepositoryScanningConfiguration;
import org.apache.maven.archiva.consumers.KnownRepositoryContentConsumer;
import org.apache.maven.archiva.database.ArchivaDatabaseException;
import org.apache.maven.archiva.database.ArtifactDAO;
import org.apache.maven.archiva.database.Constraint;
import org.apache.maven.archiva.database.constraints.ArtifactVersionsConstraint;
import org.apache.maven.archiva.database.updater.DatabaseCleanupConsumer;
import org.apache.maven.archiva.database.updater.DatabaseConsumers;
import org.apache.maven.archiva.model.ArchivaArtifact;
import org.apache.maven.archiva.model.VersionedReference;
import org.apache.maven.archiva.repository.ContentNotFoundException;
import org.apache.maven.archiva.repository.ManagedRepositoryContent;
import org.apache.maven.archiva.repository.RepositoryContentFactory;
import org.apache.maven.archiva.repository.RepositoryException;
import org.apache.maven.archiva.repository.RepositoryNotFoundException;
import org.apache.maven.archiva.repository.events.RepositoryListener;
import org.apache.maven.archiva.repository.scanner.RepositoryContentConsumers;
import org.apache.maven.archiva.scheduled.ArchivaTaskScheduler;
import org.apache.maven.archiva.scheduled.tasks.DatabaseTask;
import org.apache.maven.archiva.scheduled.tasks.RepositoryTask;
import org.apache.maven.archiva.scheduled.tasks.TaskCreator;
import org.codehaus.plexus.registry.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdministrationServiceImpl
implements AdministrationService {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private ArchivaConfiguration archivaConfiguration;
    private RepositoryContentConsumers repoConsumersUtil;
    private DatabaseConsumers dbConsumersUtil;
    private RepositoryContentFactory repoFactory;
    private ArtifactDAO artifactDAO;
    private ArchivaTaskScheduler taskScheduler;
    private Collection<RepositoryListener> listeners;

    public AdministrationServiceImpl(ArchivaConfiguration archivaConfig, RepositoryContentConsumers repoConsumersUtil, DatabaseConsumers dbConsumersUtil, RepositoryContentFactory repoFactory, ArtifactDAO artifactDAO, ArchivaTaskScheduler taskScheduler, Collection<RepositoryListener> listeners) {
        this.archivaConfiguration = archivaConfig;
        this.repoConsumersUtil = repoConsumersUtil;
        this.dbConsumersUtil = dbConsumersUtil;
        this.repoFactory = repoFactory;
        this.artifactDAO = artifactDAO;
        this.taskScheduler = taskScheduler;
        this.listeners = listeners;
    }

    public Boolean configureDatabaseConsumer(String consumerId, boolean enable) throws Exception {
        List cleanupConsumers = this.dbConsumersUtil.getAvailableCleanupConsumers();
        List unprocessedConsumers = this.dbConsumersUtil.getAvailableUnprocessedConsumers();
        boolean found = false;
        boolean isCleanupConsumer = false;
        for (DatabaseCleanupConsumer consumer : cleanupConsumers) {
            if (!consumer.getId().equals(consumerId)) continue;
            found = true;
            isCleanupConsumer = true;
            break;
        }
        if (!found) {
            for (DatabaseCleanupConsumer consumer : unprocessedConsumers) {
                if (!consumer.getId().equals(consumerId)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            throw new Exception("Invalid database consumer.");
        }
        Configuration config = this.archivaConfiguration.getConfiguration();
        DatabaseScanningConfiguration dbScanningConfig = config.getDatabaseScanning();
        if (isCleanupConsumer) {
            dbScanningConfig.addCleanupConsumer(consumerId);
        } else {
            dbScanningConfig.addUnprocessedConsumer(consumerId);
        }
        config.setDatabaseScanning(dbScanningConfig);
        this.saveConfiguration(config);
        return new Boolean(true);
    }

    public Boolean configureRepositoryConsumer(String repoId, String consumerId, boolean enable) throws Exception {
        List knownConsumers = this.repoConsumersUtil.getAvailableKnownConsumers();
        List invalidConsumers = this.repoConsumersUtil.getAvailableInvalidConsumers();
        boolean found = false;
        boolean isKnownContentConsumer = false;
        for (KnownRepositoryContentConsumer consumer : knownConsumers) {
            if (!consumer.getId().equals(consumerId)) continue;
            found = true;
            isKnownContentConsumer = true;
            break;
        }
        if (!found) {
            for (KnownRepositoryContentConsumer consumer : invalidConsumers) {
                if (!consumer.getId().equals(consumerId)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            throw new Exception("Invalid repository consumer.");
        }
        Configuration config = this.archivaConfiguration.getConfiguration();
        RepositoryScanningConfiguration repoScanningConfig = config.getRepositoryScanning();
        if (isKnownContentConsumer) {
            repoScanningConfig.addKnownContentConsumer(consumerId);
        } else {
            repoScanningConfig.addInvalidContentConsumer(consumerId);
        }
        config.setRepositoryScanning(repoScanningConfig);
        this.saveConfiguration(config);
        return new Boolean(true);
    }

    public Boolean deleteArtifact(String repoId, String groupId, String artifactId, String version) throws Exception {
        Configuration config = this.archivaConfiguration.getConfiguration();
        ManagedRepositoryConfiguration repoConfig = config.findManagedRepositoryById(repoId);
        if (repoConfig == null) {
            throw new Exception("Repository does not exist.");
        }
        try {
            ManagedRepositoryContent repoContent = this.repoFactory.getManagedRepositoryContent(repoId);
            VersionedReference ref = new VersionedReference();
            ref.setGroupId(groupId);
            ref.setArtifactId(artifactId);
            ref.setVersion(version);
            repoContent.deleteVersion(ref);
            ArtifactVersionsConstraint constraint = new ArtifactVersionsConstraint(repoId, groupId, artifactId, false);
            List artifacts = null;
            try {
                artifacts = this.artifactDAO.queryArtifacts((Constraint)constraint);
            }
            catch (ArchivaDatabaseException e) {
                throw new Exception("Error occurred while cleaning up database.");
            }
            if (artifacts != null) {
                for (ArchivaArtifact artifact : artifacts) {
                    if (!artifact.getVersion().equals(version)) continue;
                    for (RepositoryListener listener : this.listeners) {
                        listener.deleteArtifact(repoContent, artifact);
                    }
                }
            }
        }
        catch (ContentNotFoundException e) {
            throw new Exception("Artifact does not exist.");
        }
        catch (RepositoryNotFoundException e) {
            throw new Exception("Repository does not exist.");
        }
        catch (RepositoryException e) {
            throw new Exception("Repository exception occurred.");
        }
        return new Boolean(true);
    }

    public Boolean executeDatabaseScanner() throws Exception {
        if (this.taskScheduler.isProcessingDatabaseTask()) {
            return false;
        }
        this.log.info("Queueing database task on request from administration service");
        DatabaseTask task = new DatabaseTask();
        this.taskScheduler.queueDatabaseTask(task);
        return new Boolean(true);
    }

    public Boolean executeRepositoryScanner(String repoId) throws Exception {
        Configuration config = this.archivaConfiguration.getConfiguration();
        if (config.findManagedRepositoryById(repoId) == null) {
            throw new Exception("Repository does not exist.");
        }
        if (this.taskScheduler.isProcessingRepositoryTask(repoId)) {
            return false;
        }
        RepositoryTask task = TaskCreator.createRepositoryTask((String)repoId);
        this.taskScheduler.queueRepositoryTask(task);
        return new Boolean(true);
    }

    public List<String> getAllDatabaseConsumers() {
        ArrayList<String> consumers = new ArrayList<String>();
        List cleanupConsumers = this.dbConsumersUtil.getAvailableCleanupConsumers();
        List unprocessedConsumers = this.dbConsumersUtil.getAvailableUnprocessedConsumers();
        for (DatabaseCleanupConsumer consumer : cleanupConsumers) {
            consumers.add(consumer.getId());
        }
        for (DatabaseCleanupConsumer consumer : unprocessedConsumers) {
            consumers.add(consumer.getId());
        }
        return consumers;
    }

    public List<String> getAllRepositoryConsumers() {
        ArrayList<String> consumers = new ArrayList<String>();
        List knownConsumers = this.repoConsumersUtil.getAvailableKnownConsumers();
        List invalidConsumers = this.repoConsumersUtil.getAvailableInvalidConsumers();
        for (KnownRepositoryContentConsumer consumer : knownConsumers) {
            consumers.add(consumer.getId());
        }
        for (KnownRepositoryContentConsumer consumer : invalidConsumers) {
            consumers.add(consumer.getId());
        }
        return consumers;
    }

    public List<ManagedRepository> getAllManagedRepositories() {
        ArrayList<ManagedRepository> managedRepos = new ArrayList<ManagedRepository>();
        Configuration config = this.archivaConfiguration.getConfiguration();
        List managedRepoConfigs = config.getManagedRepositories();
        for (ManagedRepositoryConfiguration repoConfig : managedRepoConfigs) {
            ManagedRepository repo = new ManagedRepository(repoConfig.getId(), repoConfig.getName(), "URL", repoConfig.getLayout(), repoConfig.isSnapshots(), repoConfig.isReleases());
            managedRepos.add(repo);
        }
        return managedRepos;
    }

    public List<RemoteRepository> getAllRemoteRepositories() {
        ArrayList<RemoteRepository> remoteRepos = new ArrayList<RemoteRepository>();
        Configuration config = this.archivaConfiguration.getConfiguration();
        List remoteRepoConfigs = config.getRemoteRepositories();
        for (RemoteRepositoryConfiguration repoConfig : remoteRepoConfigs) {
            RemoteRepository repo = new RemoteRepository(repoConfig.getId(), repoConfig.getName(), repoConfig.getUrl(), repoConfig.getLayout());
            remoteRepos.add(repo);
        }
        return remoteRepos;
    }

    private void saveConfiguration(Configuration config) throws Exception {
        try {
            this.archivaConfiguration.save(config);
        }
        catch (RegistryException e) {
            throw new Exception("Error occurred in the registry.");
        }
        catch (IndeterminateConfigurationException e) {
            throw new Exception("Error occurred while saving the configuration.");
        }
    }
}

