/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.web.xmlrpc.services;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.archiva.indexer.search.RepositorySearch;
import org.apache.archiva.indexer.search.SearchResultHit;
import org.apache.archiva.indexer.search.SearchResultLimits;
import org.apache.archiva.indexer.search.SearchResults;
import org.apache.archiva.web.xmlrpc.api.SearchService;
import org.apache.archiva.web.xmlrpc.api.beans.Artifact;
import org.apache.archiva.web.xmlrpc.security.XmlRpcUserRepositories;
import org.apache.maven.archiva.common.utils.VersionUtil;
import org.apache.maven.archiva.database.ArchivaDAO;
import org.apache.maven.archiva.database.ArchivaDatabaseException;
import org.apache.maven.archiva.database.ArtifactDAO;
import org.apache.maven.archiva.database.Constraint;
import org.apache.maven.archiva.database.ObjectNotFoundException;
import org.apache.maven.archiva.database.SimpleConstraint;
import org.apache.maven.archiva.database.browsing.BrowsingResults;
import org.apache.maven.archiva.database.browsing.RepositoryBrowsing;
import org.apache.maven.archiva.database.constraints.ArtifactsByChecksumConstraint;
import org.apache.maven.archiva.database.constraints.UniqueVersionConstraint;
import org.apache.maven.archiva.model.ArchivaArtifact;
import org.apache.maven.archiva.model.ArchivaProjectModel;
import org.apache.maven.archiva.model.Dependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchServiceImpl
implements SearchService {
    private Logger log = LoggerFactory.getLogger(SearchServiceImpl.class);
    private RepositorySearch search;
    private XmlRpcUserRepositories xmlRpcUserRepositories;
    private ArchivaDAO archivaDAO;
    private RepositoryBrowsing repoBrowsing;

    public SearchServiceImpl(XmlRpcUserRepositories xmlRpcUserRepositories, ArchivaDAO archivaDAO, RepositoryBrowsing repoBrowsing, RepositorySearch search) {
        this.xmlRpcUserRepositories = xmlRpcUserRepositories;
        this.archivaDAO = archivaDAO;
        this.repoBrowsing = repoBrowsing;
        this.search = search;
    }

    public List<Artifact> quickSearch(String queryString) throws Exception {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        List observableRepos = this.xmlRpcUserRepositories.getObservableRepositories();
        SearchResultLimits limits = new SearchResultLimits(-1);
        SearchResults results = null;
        results = this.search.search("", observableRepos, queryString, limits, null);
        for (SearchResultHit resultHit : results.getHits()) {
            List resultHitVersions;
            List versions = this.archivaDAO.query((SimpleConstraint)new UniqueVersionConstraint(observableRepos, resultHit.getGroupId(), resultHit.getArtifactId()));
            if (versions != null && !versions.isEmpty()) {
                resultHit.setVersion(null);
                resultHit.setVersions(SearchServiceImpl.filterTimestampedSnapshots(versions));
            }
            if ((resultHitVersions = resultHit.getVersions()) == null) continue;
            for (String version : resultHitVersions) {
                try {
                    ArchivaProjectModel model = this.repoBrowsing.selectVersion("", observableRepos, resultHit.getGroupId(), resultHit.getArtifactId(), version);
                    String repoId = this.repoBrowsing.getRepositoryId("", observableRepos, resultHit.getGroupId(), resultHit.getArtifactId(), version);
                    Artifact artifact = null;
                    artifact = model == null ? new Artifact(repoId, resultHit.getGroupId(), resultHit.getArtifactId(), version, "jar") : new Artifact(repoId, model.getGroupId(), model.getArtifactId(), version, model.getPackaging());
                    artifacts.add(artifact);
                }
                catch (ObjectNotFoundException e) {
                    this.log.debug("Unable to find pom artifact : " + e.getMessage());
                }
                catch (ArchivaDatabaseException e) {
                    this.log.debug("Error occurred while getting pom artifact from database : " + e.getMessage());
                }
            }
        }
        return artifacts;
    }

    private static List<String> filterTimestampedSnapshots(List<String> versions) {
        ArrayList<String> filtered = new ArrayList<String>();
        for (String version : versions) {
            String baseVersion = VersionUtil.getBaseVersion((String)version);
            if (filtered.contains(baseVersion)) continue;
            filtered.add(baseVersion);
        }
        return filtered;
    }

    public List<Artifact> getArtifactByChecksum(String checksum) throws Exception {
        ArrayList<Artifact> results = new ArrayList<Artifact>();
        ArtifactDAO artifactDAO = this.archivaDAO.getArtifactDAO();
        ArtifactsByChecksumConstraint constraint = new ArtifactsByChecksumConstraint(checksum);
        List artifacts = artifactDAO.queryArtifacts((Constraint)constraint);
        for (ArchivaArtifact archivaArtifact : artifacts) {
            Artifact artifact = new Artifact(archivaArtifact.getModel().getRepositoryId(), archivaArtifact.getModel().getGroupId(), archivaArtifact.getModel().getArtifactId(), archivaArtifact.getModel().getVersion(), archivaArtifact.getType());
            results.add(artifact);
        }
        return results;
    }

    public List<Artifact> getArtifactVersions(String groupId, String artifactId) throws Exception {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        List observableRepos = this.xmlRpcUserRepositories.getObservableRepositories();
        BrowsingResults results = this.repoBrowsing.selectArtifactId("", observableRepos, groupId, artifactId);
        for (String version : results.getVersions()) {
            Artifact artifact = new Artifact("", groupId, artifactId, version, "pom");
            artifacts.add(artifact);
        }
        return artifacts;
    }

    public List<Artifact> getArtifactVersionsByDate(String groupId, String artifactId, String version, Date since) throws Exception {
        ArrayList artifacts = new ArrayList();
        throw new UnsupportedOperationException("getArtifactVersionsByDate not yet implemented");
    }

    public List<org.apache.archiva.web.xmlrpc.api.beans.Dependency> getDependencies(String groupId, String artifactId, String version) throws Exception {
        ArrayList<org.apache.archiva.web.xmlrpc.api.beans.Dependency> dependencies = new ArrayList<org.apache.archiva.web.xmlrpc.api.beans.Dependency>();
        List observableRepos = this.xmlRpcUserRepositories.getObservableRepositories();
        try {
            ArchivaProjectModel model = this.repoBrowsing.selectVersion("", observableRepos, groupId, artifactId, version);
            List modelDeps = model.getDependencies();
            for (Dependency dep : modelDeps) {
                org.apache.archiva.web.xmlrpc.api.beans.Dependency dependency = new org.apache.archiva.web.xmlrpc.api.beans.Dependency(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getClassifier(), dep.getType(), dep.getScope());
                dependencies.add(dependency);
            }
        }
        catch (ObjectNotFoundException oe) {
            throw new Exception("Artifact does not exist.");
        }
        return dependencies;
    }

    public List<Artifact> getDependencyTree(String groupId, String artifactId, String version) throws Exception {
        ArrayList a = new ArrayList();
        throw new UnsupportedOperationException("getDependencyTree not yet implemented");
    }

    public List<Artifact> getDependees(String groupId, String artifactId, String version) throws Exception {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        List observableRepos = this.xmlRpcUserRepositories.getObservableRepositories();
        List dependees = this.repoBrowsing.getUsedBy("", observableRepos, groupId, artifactId, version);
        for (ArchivaProjectModel model : dependees) {
            Artifact artifact = new Artifact("", model.getGroupId(), model.getArtifactId(), model.getVersion(), "");
            artifacts.add(artifact);
        }
        return artifacts;
    }
}

