/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.metadata.repository.storage.maven2;

import java.util.HashMap;
import java.util.Map;
import org.apache.archiva.metadata.repository.storage.maven2.ArtifactMappingProvider;
import org.springframework.stereotype.Service;

@Service(value="artifactMappingProvider#default")
public class DefaultArtifactMappingProvider
implements ArtifactMappingProvider {
    private final Map<String, String> classifierAndExtensionToTypeMap = new HashMap<String, String>();
    private final Map<String, String> typeToExtensionMap;

    public DefaultArtifactMappingProvider() {
        this.classifierAndExtensionToTypeMap.put("client:jar", "ejb-client");
        this.classifierAndExtensionToTypeMap.put("sources:jar", "java-source");
        this.classifierAndExtensionToTypeMap.put("javadoc:jar", "javadoc");
        this.classifierAndExtensionToTypeMap.put("tests:jar", "test-jar");
        this.typeToExtensionMap = new HashMap<String, String>();
        this.typeToExtensionMap.put("ejb-client", "jar");
        this.typeToExtensionMap.put("ejb", "jar");
        this.typeToExtensionMap.put("java-source", "jar");
        this.typeToExtensionMap.put("javadoc", "jar");
        this.typeToExtensionMap.put("test-jar", "jar");
        this.typeToExtensionMap.put("maven-plugin", "jar");
        this.typeToExtensionMap.put("maven-archetype", "jar");
        this.typeToExtensionMap.put("maven-one-plugin", "jar");
        this.typeToExtensionMap.put("javadoc.jar", "jar");
        this.typeToExtensionMap.put("uberjar", "jar");
        this.typeToExtensionMap.put("distribution-tgz", "tar.gz");
        this.typeToExtensionMap.put("distribution-zip", "zip");
        this.typeToExtensionMap.put("aspect", "jar");
    }

    public String mapClassifierAndExtensionToType(String classifier, String ext) {
        if (classifier == null) {
            classifier = "";
        }
        if (ext == null) {
            ext = "";
        }
        return this.classifierAndExtensionToTypeMap.get(classifier + ":" + ext);
    }

    public String mapTypeToExtension(String type) {
        return this.typeToExtensionMap.get(type);
    }
}

