/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.metadata.repository.storage.maven2;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.archiva.common.utils.VersionUtil;
import org.apache.archiva.metadata.model.ArtifactMetadata;
import org.apache.archiva.metadata.model.MetadataFacet;
import org.apache.archiva.metadata.repository.storage.RepositoryPathTranslator;
import org.apache.archiva.metadata.repository.storage.maven2.ArtifactMappingProvider;
import org.apache.archiva.metadata.repository.storage.maven2.MavenArtifactFacet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="repositoryPathTranslator#maven2")
public class Maven2RepositoryPathTranslator
implements RepositoryPathTranslator {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final char GROUP_SEPARATOR = '.';
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("([0-9]{8}.[0-9]{6})-([0-9]+).*");
    private static final Pattern MAVEN_PLUGIN_PATTERN = Pattern.compile("^(maven-.*-plugin)|(.*-maven-plugin)$");
    @Inject
    private List<ArtifactMappingProvider> artifactMappingProviders;

    public Maven2RepositoryPathTranslator() {
    }

    @PostConstruct
    public void initialize() {
    }

    public Maven2RepositoryPathTranslator(List<ArtifactMappingProvider> artifactMappingProviders) {
        this.artifactMappingProviders = artifactMappingProviders;
    }

    public File toFile(File basedir, String namespace, String projectId, String projectVersion, String filename) {
        return new File(basedir, this.toPath(namespace, projectId, projectVersion, filename));
    }

    public File toFile(File basedir, String namespace, String projectId, String projectVersion) {
        return new File(basedir, this.toPath(namespace, projectId, projectVersion));
    }

    public String toPath(String namespace, String projectId, String projectVersion, String filename) {
        StringBuilder path = new StringBuilder();
        this.appendNamespaceToProjectVersion(path, namespace, projectId, projectVersion);
        path.append('/');
        path.append(filename);
        return path.toString();
    }

    private void appendNamespaceToProjectVersion(StringBuilder path, String namespace, String projectId, String projectVersion) {
        this.appendNamespaceAndProject(path, namespace, projectId);
        path.append(projectVersion);
    }

    public String toPath(String namespace, String projectId, String projectVersion) {
        StringBuilder path = new StringBuilder();
        this.appendNamespaceToProjectVersion(path, namespace, projectId, projectVersion);
        return path.toString();
    }

    public String toPath(String namespace) {
        StringBuilder path = new StringBuilder();
        this.appendNamespace(path, namespace);
        return path.toString();
    }

    public String toPath(String namespace, String projectId) {
        StringBuilder path = new StringBuilder();
        this.appendNamespaceAndProject(path, namespace, projectId);
        return path.toString();
    }

    private void appendNamespaceAndProject(StringBuilder path, String namespace, String projectId) {
        this.appendNamespace(path, namespace);
        path.append(projectId).append('/');
    }

    private void appendNamespace(StringBuilder path, String namespace) {
        path.append(this.formatAsDirectory(namespace)).append('/');
    }

    public File toFile(File basedir, String namespace, String projectId) {
        return new File(basedir, this.toPath(namespace, projectId));
    }

    public File toFile(File basedir, String namespace) {
        return new File(basedir, this.toPath(namespace));
    }

    private String formatAsDirectory(String directory) {
        return directory.replace('.', '/');
    }

    public ArtifactMetadata getArtifactForPath(String repoId, String relativePath) {
        String[] parts = relativePath.replace('\\', '/').split("/");
        int len = parts.length;
        if (len < 4) {
            throw new IllegalArgumentException("Not a valid artifact path in a Maven 2 repository, not enough directories: " + relativePath);
        }
        String id = parts[--len];
        String baseVersion = parts[--len];
        String artifactId = parts[--len];
        StringBuilder groupIdBuilder = new StringBuilder();
        for (int i = 0; i < len - 1; ++i) {
            groupIdBuilder.append(parts[i]);
            groupIdBuilder.append('.');
        }
        groupIdBuilder.append(parts[len - 1]);
        return this.getArtifactFromId(repoId, groupIdBuilder.toString(), artifactId, baseVersion, id);
    }

    public ArtifactMetadata getArtifactFromId(String repoId, String namespace, String projectId, String projectVersion, String id) {
        ArtifactMappingProvider mapping;
        String ext;
        String classifier;
        String version;
        if (!id.startsWith(projectId + "-")) {
            throw new IllegalArgumentException("Not a valid artifact path in a Maven 2 repository, filename '" + id + "' doesn't start with artifact ID '" + projectId + "'");
        }
        MavenArtifactFacet facet = new MavenArtifactFacet();
        int index = projectId.length() + 1;
        String idSubStrFromVersion = id.substring(index);
        if (idSubStrFromVersion.startsWith(projectVersion) && !VersionUtil.isUniqueSnapshot((String)projectVersion)) {
            version = projectVersion;
        } else if (VersionUtil.isGenericSnapshot((String)projectVersion)) {
            try {
                int mainVersionLength = projectVersion.length() - 8;
                if (mainVersionLength == 0) {
                    throw new IllegalArgumentException("Timestamped snapshots must contain the main version, filename was '" + id + "'");
                }
                Matcher m = TIMESTAMP_PATTERN.matcher(idSubStrFromVersion.substring(mainVersionLength));
                m.matches();
                String timestamp = m.group(1);
                String buildNumber = m.group(2);
                facet.setTimestamp(timestamp);
                facet.setBuildNumber(Integer.parseInt(buildNumber));
                version = idSubStrFromVersion.substring(0, mainVersionLength) + timestamp + "-" + buildNumber;
            }
            catch (IllegalStateException e) {
                throw new IllegalArgumentException("Not a valid artifact path in a Maven 2 repository, filename '" + id + "' doesn't contain a timestamped version matching snapshot '" + projectVersion + "'");
            }
        } else {
            throw new IllegalArgumentException("Not a valid artifact path in a Maven 2 repository, filename '" + id + "' doesn't contain version '" + projectVersion + "'");
        }
        if ((index += version.length()) == id.length()) {
            classifier = null;
            ext = null;
        } else {
            char c = id.charAt(index);
            if (c == '-') {
                int extIndex = id.indexOf(46, index);
                if (extIndex >= 0) {
                    classifier = id.substring(index + 1, extIndex);
                    ext = id.substring(extIndex + 1);
                } else {
                    classifier = id.substring(index + 1);
                    ext = null;
                }
            } else if (c == '.') {
                classifier = null;
                ext = id.substring(index + 1);
            } else {
                throw new IllegalArgumentException("Not a valid artifact path in a Maven 2 repository, filename '" + id + "' expected classifier or extension but got '" + id.substring(index) + "'");
            }
        }
        ArtifactMetadata metadata = new ArtifactMetadata();
        metadata.setId(id);
        metadata.setNamespace(namespace);
        metadata.setProject(projectId);
        metadata.setRepositoryId(repoId);
        metadata.setProjectVersion(projectVersion);
        metadata.setVersion(version);
        facet.setClassifier(classifier);
        String type = null;
        Iterator<ArtifactMappingProvider> i$ = this.artifactMappingProviders.iterator();
        while (i$.hasNext() && (type = (mapping = i$.next()).mapClassifierAndExtensionToType(classifier, ext)) == null) {
        }
        if (type == null && "jar".equals(ext) && this.isArtifactIdValidMavenPlugin(projectId)) {
            type = "maven-plugin";
        }
        if (type == null) {
            type = ext;
        }
        if (type == null) {
            throw new IllegalArgumentException("Not a valid artifact path in a Maven 2 repository, filename '" + id + "' does not have a type");
        }
        facet.setType(type);
        metadata.addFacet((MetadataFacet)facet);
        return metadata;
    }

    public boolean isArtifactIdValidMavenPlugin(String artifactId) {
        return MAVEN_PLUGIN_PATTERN.matcher(artifactId).matches();
    }
}

