/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.metadata.repository.storage.maven2;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.admin.model.beans.NetworkProxy;
import org.apache.archiva.admin.model.beans.ProxyConnector;
import org.apache.archiva.admin.model.beans.RemoteRepository;
import org.apache.archiva.admin.model.managed.ManagedRepositoryAdmin;
import org.apache.archiva.admin.model.networkproxy.NetworkProxyAdmin;
import org.apache.archiva.admin.model.proxyconnector.ProxyConnectorAdmin;
import org.apache.archiva.admin.model.remote.RemoteRepositoryAdmin;
import org.apache.archiva.checksum.ChecksumAlgorithm;
import org.apache.archiva.checksum.ChecksummedFile;
import org.apache.archiva.common.utils.VersionUtil;
import org.apache.archiva.maven2.metadata.MavenMetadataReader;
import org.apache.archiva.metadata.model.ArtifactMetadata;
import org.apache.archiva.metadata.model.IssueManagement;
import org.apache.archiva.metadata.model.MetadataFacet;
import org.apache.archiva.metadata.model.ProjectMetadata;
import org.apache.archiva.metadata.model.ProjectVersionMetadata;
import org.apache.archiva.metadata.model.Scm;
import org.apache.archiva.metadata.repository.filter.Filter;
import org.apache.archiva.metadata.repository.storage.RepositoryPathTranslator;
import org.apache.archiva.metadata.repository.storage.RepositoryStorage;
import org.apache.archiva.metadata.repository.storage.RepositoryStorageMetadataInvalidException;
import org.apache.archiva.metadata.repository.storage.RepositoryStorageMetadataNotFoundException;
import org.apache.archiva.metadata.repository.storage.RepositoryStorageRuntimeException;
import org.apache.archiva.metadata.repository.storage.maven2.MavenProjectFacet;
import org.apache.archiva.metadata.repository.storage.maven2.MavenProjectParent;
import org.apache.archiva.metadata.repository.storage.maven2.RepositoryModelResolver;
import org.apache.archiva.model.ArchivaRepositoryMetadata;
import org.apache.archiva.model.SnapshotVersion;
import org.apache.archiva.proxy.common.WagonFactory;
import org.apache.archiva.reports.RepositoryProblemFacet;
import org.apache.archiva.xml.XMLException;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.resolution.ModelResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="repositoryStorage#maven2")
public class Maven2RepositoryStorage
implements RepositoryStorage {
    private ModelBuilder builder;
    @Inject
    private RemoteRepositoryAdmin remoteRepositoryAdmin;
    @Inject
    private ManagedRepositoryAdmin managedRepositoryAdmin;
    @Inject
    private ProxyConnectorAdmin proxyConnectorAdmin;
    @Inject
    private NetworkProxyAdmin networkProxyAdmin;
    @Inject
    @Named(value="repositoryPathTranslator#maven2")
    private RepositoryPathTranslator pathTranslator;
    @Inject
    private WagonFactory wagonFactory;
    private static final Logger log = LoggerFactory.getLogger(Maven2RepositoryStorage.class);
    private static final String METADATA_FILENAME_START = "maven-metadata";
    private static final String METADATA_FILENAME = "maven-metadata.xml";

    @PostConstruct
    public void initialize() {
        DefaultModelBuilderFactory defaultModelBuilderFactory = new DefaultModelBuilderFactory();
        this.builder = defaultModelBuilderFactory.newInstance();
    }

    public ProjectMetadata readProjectMetadata(String repoId, String namespace, String projectId) {
        return null;
    }

    public ProjectVersionMetadata readProjectVersionMetadata(String repoId, String namespace, String projectId, String projectVersion) throws RepositoryStorageMetadataNotFoundException, RepositoryStorageMetadataInvalidException, RepositoryStorageRuntimeException {
        try {
            Model model;
            String id;
            File file;
            ManagedRepository managedRepository = this.managedRepositoryAdmin.getManagedRepository(repoId);
            String artifactVersion = projectVersion;
            if (VersionUtil.isSnapshot((String)projectVersion)) {
                if (managedRepository.isReleases() && !managedRepository.isSnapshots()) {
                    throw new RepositoryStorageRuntimeException("lookforsnaponreleaseonly", "managed repo is configured for release only");
                }
            } else if (!managedRepository.isReleases() && managedRepository.isSnapshots()) {
                throw new RepositoryStorageRuntimeException("lookforsreleaseonsneponly", "managed repo is configured for snapshot only");
            }
            File basedir = new File(managedRepository.getLocation());
            if (VersionUtil.isSnapshot((String)projectVersion)) {
                File metadataFile = this.pathTranslator.toFile(basedir, namespace, projectId, projectVersion, METADATA_FILENAME);
                try {
                    ArchivaRepositoryMetadata metadata = MavenMetadataReader.read((File)metadataFile);
                    SnapshotVersion snapshotVersion = metadata.getSnapshotVersion();
                    if (snapshotVersion != null) {
                        artifactVersion = artifactVersion.substring(0, artifactVersion.length() - 8);
                        artifactVersion = artifactVersion + snapshotVersion.getTimestamp() + "-" + snapshotVersion.getBuildNumber();
                    }
                }
                catch (XMLException e) {
                    log.warn("Invalid metadata: " + metadataFile + " - " + e.getMessage());
                }
            }
            if (!(file = this.pathTranslator.toFile(basedir, namespace, projectId, projectVersion, id = projectId + "-" + artifactVersion + ".pom")).exists()) {
                throw new RepositoryStorageMetadataNotFoundException("The artifact's POM file '" + file.getAbsolutePath() + "' was missing");
            }
            ArrayList<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
            HashMap<String, NetworkProxy> networkProxies = new HashMap<String, NetworkProxy>();
            Map proxyConnectorsMap = this.proxyConnectorAdmin.getProxyConnectorAsMap();
            List proxyConnectors = (List)proxyConnectorsMap.get(repoId);
            if (proxyConnectors != null) {
                for (ProxyConnector proxyConnector : proxyConnectors) {
                    RemoteRepository remoteRepoConfig = this.remoteRepositoryAdmin.getRemoteRepository(proxyConnector.getTargetRepoId());
                    if (remoteRepoConfig == null) continue;
                    remoteRepositories.add(remoteRepoConfig);
                    NetworkProxy networkProxyConfig = this.networkProxyAdmin.getNetworkProxy(proxyConnector.getProxyId());
                    if (networkProxyConfig == null) continue;
                    networkProxies.put(proxyConnector.getTargetRepoId(), networkProxyConfig);
                }
            }
            DefaultModelBuildingRequest req = new DefaultModelBuildingRequest().setProcessPlugins(false).setPomFile(file).setTwoPhaseBuilding(false).setValidationLevel(0);
            req.setSystemProperties(System.getProperties());
            req.setModelResolver((ModelResolver)new RepositoryModelResolver(managedRepository, this.pathTranslator, this.wagonFactory, remoteRepositories, networkProxies, managedRepository));
            try {
                model = this.builder.build((ModelBuildingRequest)req).getEffectiveModel();
            }
            catch (ModelBuildingException e) {
                String msg = "The artifact's POM file '" + file + "' was invalid: " + e.getMessage();
                List modelProblems = e.getProblems();
                for (ModelProblem problem : modelProblems) {
                    if (!(problem.getException() instanceof FileNotFoundException) || e.getModelId() == null || e.getModelId().equals(problem.getModelId())) continue;
                    log.warn("The artifact's parent POM file '" + file + "' cannot be resolved. " + "Using defaults for project version metadata..");
                    ProjectVersionMetadata metadata = new ProjectVersionMetadata();
                    metadata.setId(projectVersion);
                    MavenProjectFacet facet = new MavenProjectFacet();
                    facet.setGroupId(namespace);
                    facet.setArtifactId(projectId);
                    facet.setPackaging("jar");
                    metadata.addFacet((MetadataFacet)facet);
                    String errMsg = "Error in resolving artifact's parent POM file. " + (problem.getException() == null ? problem.getMessage() : problem.getException().getMessage());
                    RepositoryProblemFacet repoProblemFacet = new RepositoryProblemFacet();
                    repoProblemFacet.setRepositoryId(repoId);
                    repoProblemFacet.setId(repoId);
                    repoProblemFacet.setMessage(errMsg);
                    repoProblemFacet.setProblem(errMsg);
                    repoProblemFacet.setProject(projectId);
                    repoProblemFacet.setVersion(projectVersion);
                    repoProblemFacet.setNamespace(namespace);
                    metadata.addFacet((MetadataFacet)repoProblemFacet);
                    return metadata;
                }
                throw new RepositoryStorageMetadataInvalidException("invalid-pom", msg, (Throwable)e);
            }
            boolean correctGroupId = namespace.equals(model.getGroupId());
            boolean correctArtifactId = projectId.equals(model.getArtifactId());
            boolean correctVersion = projectVersion.equals(model.getVersion());
            if (!(correctGroupId && correctArtifactId && correctVersion)) {
                StringBuilder message = new StringBuilder("Incorrect POM coordinates in '" + file + "':");
                if (!correctGroupId) {
                    message.append("\nIncorrect group ID: ").append(model.getGroupId());
                }
                if (!correctArtifactId) {
                    message.append("\nIncorrect artifact ID: ").append(model.getArtifactId());
                }
                if (!correctVersion) {
                    message.append("\nIncorrect version: ").append(model.getVersion());
                }
                throw new RepositoryStorageMetadataInvalidException("mislocated-pom", message.toString());
            }
            ProjectVersionMetadata metadata = new ProjectVersionMetadata();
            metadata.setCiManagement(this.convertCiManagement(model.getCiManagement()));
            metadata.setDescription(model.getDescription());
            metadata.setId(projectVersion);
            metadata.setIssueManagement(this.convertIssueManagement(model.getIssueManagement()));
            metadata.setLicenses(this.convertLicenses(model.getLicenses()));
            metadata.setMailingLists(this.convertMailingLists(model.getMailingLists()));
            metadata.setDependencies(this.convertDependencies(model.getDependencies()));
            metadata.setName(model.getName());
            metadata.setOrganization(this.convertOrganization(model.getOrganization()));
            metadata.setScm(this.convertScm(model.getScm()));
            metadata.setUrl(model.getUrl());
            MavenProjectFacet facet = new MavenProjectFacet();
            facet.setGroupId(model.getGroupId() != null ? model.getGroupId() : model.getParent().getGroupId());
            facet.setArtifactId(model.getArtifactId());
            facet.setPackaging(model.getPackaging());
            if (model.getParent() != null) {
                MavenProjectParent parent = new MavenProjectParent();
                parent.setGroupId(model.getParent().getGroupId());
                parent.setArtifactId(model.getParent().getArtifactId());
                parent.setVersion(model.getParent().getVersion());
                facet.setParent(parent);
            }
            metadata.addFacet((MetadataFacet)facet);
            return metadata;
        }
        catch (RepositoryAdminException e) {
            throw new RepositoryStorageRuntimeException("repo-admin", e.getMessage());
        }
    }

    public void setWagonFactory(WagonFactory wagonFactory) {
        this.wagonFactory = wagonFactory;
    }

    private List<org.apache.archiva.metadata.model.Dependency> convertDependencies(List<Dependency> dependencies) {
        ArrayList<org.apache.archiva.metadata.model.Dependency> l = new ArrayList<org.apache.archiva.metadata.model.Dependency>();
        for (Dependency dependency : dependencies) {
            org.apache.archiva.metadata.model.Dependency newDependency = new org.apache.archiva.metadata.model.Dependency();
            newDependency.setArtifactId(dependency.getArtifactId());
            newDependency.setClassifier(dependency.getClassifier());
            newDependency.setGroupId(dependency.getGroupId());
            newDependency.setOptional(dependency.isOptional());
            newDependency.setScope(dependency.getScope());
            newDependency.setSystemPath(dependency.getSystemPath());
            newDependency.setType(dependency.getType());
            newDependency.setVersion(dependency.getVersion());
            l.add(newDependency);
        }
        return l;
    }

    private Scm convertScm(org.apache.maven.model.Scm scm) {
        Scm newScm = null;
        if (scm != null) {
            newScm = new Scm();
            newScm.setConnection(scm.getConnection());
            newScm.setDeveloperConnection(scm.getDeveloperConnection());
            newScm.setUrl(scm.getUrl());
        }
        return newScm;
    }

    private org.apache.archiva.metadata.model.Organization convertOrganization(Organization organization) {
        org.apache.archiva.metadata.model.Organization org = null;
        if (organization != null) {
            org = new org.apache.archiva.metadata.model.Organization();
            org.setName(organization.getName());
            org.setUrl(organization.getUrl());
        }
        return org;
    }

    private List<org.apache.archiva.metadata.model.License> convertLicenses(List<License> licenses) {
        ArrayList<org.apache.archiva.metadata.model.License> l = new ArrayList<org.apache.archiva.metadata.model.License>();
        for (License license : licenses) {
            org.apache.archiva.metadata.model.License newLicense = new org.apache.archiva.metadata.model.License();
            newLicense.setName(license.getName());
            newLicense.setUrl(license.getUrl());
            l.add(newLicense);
        }
        return l;
    }

    private List<org.apache.archiva.metadata.model.MailingList> convertMailingLists(List<MailingList> mailingLists) {
        ArrayList<org.apache.archiva.metadata.model.MailingList> l = new ArrayList<org.apache.archiva.metadata.model.MailingList>();
        for (MailingList mailingList : mailingLists) {
            org.apache.archiva.metadata.model.MailingList newMailingList = new org.apache.archiva.metadata.model.MailingList();
            newMailingList.setName(mailingList.getName());
            newMailingList.setMainArchiveUrl(mailingList.getArchive());
            newMailingList.setPostAddress(mailingList.getPost());
            newMailingList.setSubscribeAddress(mailingList.getSubscribe());
            newMailingList.setUnsubscribeAddress(mailingList.getUnsubscribe());
            newMailingList.setOtherArchives(mailingList.getOtherArchives());
            l.add(newMailingList);
        }
        return l;
    }

    private IssueManagement convertIssueManagement(org.apache.maven.model.IssueManagement issueManagement) {
        IssueManagement im = null;
        if (issueManagement != null) {
            im = new IssueManagement();
            im.setSystem(issueManagement.getSystem());
            im.setUrl(issueManagement.getUrl());
        }
        return im;
    }

    private org.apache.archiva.metadata.model.CiManagement convertCiManagement(CiManagement ciManagement) {
        org.apache.archiva.metadata.model.CiManagement ci = null;
        if (ciManagement != null) {
            ci = new org.apache.archiva.metadata.model.CiManagement();
            ci.setSystem(ciManagement.getSystem());
            ci.setUrl(ciManagement.getUrl());
        }
        return ci;
    }

    public Collection<String> listRootNamespaces(String repoId, Filter<String> filter) throws RepositoryStorageRuntimeException {
        File dir = this.getRepositoryBasedir(repoId);
        return Maven2RepositoryStorage.getSortedFiles(dir, filter);
    }

    private static Collection<String> getSortedFiles(File dir, Filter<String> filter) {
        List<String> fileNames;
        String[] files = dir.list(new DirectoryFilter(filter));
        if (files != null) {
            fileNames = new ArrayList<String>(Arrays.asList(files));
            Collections.sort(fileNames);
        } else {
            fileNames = Collections.emptyList();
        }
        return fileNames;
    }

    private File getRepositoryBasedir(String repoId) throws RepositoryStorageRuntimeException {
        try {
            ManagedRepository repositoryConfiguration = this.managedRepositoryAdmin.getManagedRepository(repoId);
            return new File(repositoryConfiguration.getLocation());
        }
        catch (RepositoryAdminException e) {
            throw new RepositoryStorageRuntimeException("repo-admin", e.getMessage());
        }
    }

    public Collection<String> listNamespaces(String repoId, String namespace, Filter<String> filter) throws RepositoryStorageRuntimeException {
        File dir = this.pathTranslator.toFile(this.getRepositoryBasedir(repoId), namespace);
        ArrayList<String> namespaces = new ArrayList<String>();
        File[] files = dir.listFiles(new DirectoryFilter(filter));
        if (files != null) {
            for (File file : files) {
                if (this.isProject(file, filter)) continue;
                namespaces.add(file.getName());
            }
        }
        Collections.sort(namespaces);
        return namespaces;
    }

    public Collection<String> listProjects(String repoId, String namespace, Filter<String> filter) throws RepositoryStorageRuntimeException {
        File dir = this.pathTranslator.toFile(this.getRepositoryBasedir(repoId), namespace);
        ArrayList<String> projects = new ArrayList<String>();
        File[] files = dir.listFiles(new DirectoryFilter(filter));
        if (files != null) {
            for (File file : files) {
                if (!this.isProject(file, filter)) continue;
                projects.add(file.getName());
            }
        }
        Collections.sort(projects);
        return projects;
    }

    public Collection<String> listProjectVersions(String repoId, String namespace, String projectId, Filter<String> filter) throws RepositoryStorageRuntimeException {
        File dir = this.pathTranslator.toFile(this.getRepositoryBasedir(repoId), namespace, projectId);
        return Maven2RepositoryStorage.getSortedFiles(dir, filter);
    }

    public Collection<ArtifactMetadata> readArtifactsMetadata(String repoId, String namespace, String projectId, String projectVersion, Filter<String> filter) throws RepositoryStorageRuntimeException {
        File dir = this.pathTranslator.toFile(this.getRepositoryBasedir(repoId), namespace, projectId, projectVersion);
        File[] files = dir.listFiles(new ArtifactDirectoryFilter(filter));
        ArrayList<ArtifactMetadata> artifacts = new ArrayList<ArtifactMetadata>();
        if (files != null) {
            for (File file : files) {
                ArtifactMetadata metadata = this.getArtifactFromFile(repoId, namespace, projectId, projectVersion, file);
                artifacts.add(metadata);
            }
        }
        return artifacts;
    }

    public ArtifactMetadata readArtifactMetadataFromPath(String repoId, String path) throws RepositoryStorageRuntimeException {
        ArtifactMetadata metadata = this.pathTranslator.getArtifactForPath(repoId, path);
        Maven2RepositoryStorage.populateArtifactMetadataFromFile(metadata, new File(this.getRepositoryBasedir(repoId), path));
        return metadata;
    }

    private ArtifactMetadata getArtifactFromFile(String repoId, String namespace, String projectId, String projectVersion, File file) {
        ArtifactMetadata metadata = this.pathTranslator.getArtifactFromId(repoId, namespace, projectId, projectVersion, file.getName());
        Maven2RepositoryStorage.populateArtifactMetadataFromFile(metadata, file);
        return metadata;
    }

    private static void populateArtifactMetadataFromFile(ArtifactMetadata metadata, File file) {
        metadata.setWhenGathered(new Date());
        metadata.setFileLastModified(file.lastModified());
        ChecksummedFile checksummedFile = new ChecksummedFile(file);
        try {
            metadata.setMd5(checksummedFile.calculateChecksum(ChecksumAlgorithm.MD5));
        }
        catch (IOException e) {
            log.error("Unable to checksum file {}: {},MD5", (Object)file, (Object)e.getMessage());
        }
        try {
            metadata.setSha1(checksummedFile.calculateChecksum(ChecksumAlgorithm.SHA1));
        }
        catch (IOException e) {
            log.error("Unable to checksum file {}: {},SHA1", (Object)file, (Object)e.getMessage());
        }
        metadata.setSize(file.length());
    }

    private boolean isProject(File dir, Filter<String> filter) {
        ArchivaRepositoryMetadata metadata;
        File[] files = dir.listFiles(new DirectoryFilter(filter));
        if (files != null) {
            for (File file : files) {
                if (!this.isProjectVersion(file)) continue;
                return true;
            }
        }
        return (metadata = this.readMetadata(dir)) != null && dir.getName().equals(metadata.getArtifactId());
    }

    private boolean isProjectVersion(File dir) {
        File[] files;
        String artifactId = dir.getParentFile().getName();
        String projectVersion = dir.getName();
        if (VersionUtil.isSnapshot((String)projectVersion)) {
            files = dir.listFiles(new PomFilenameFilter(artifactId, projectVersion));
        } else {
            String pomFile = artifactId + "-" + projectVersion + ".pom";
            files = dir.listFiles(new PomFileFilter(pomFile));
        }
        if (files != null && files.length > 0) {
            return true;
        }
        ArchivaRepositoryMetadata metadata = this.readMetadata(dir);
        return metadata != null && projectVersion.equals(metadata.getVersion());
    }

    private ArchivaRepositoryMetadata readMetadata(File directory) {
        ArchivaRepositoryMetadata metadata = null;
        File metadataFile = new File(directory, METADATA_FILENAME);
        if (metadataFile.exists()) {
            try {
                metadata = MavenMetadataReader.read((File)metadataFile);
            }
            catch (XMLException e) {
                // empty catch block
            }
        }
        return metadata;
    }

    private static class PomFileFilter
    implements FilenameFilter {
        private final String pomFile;

        private PomFileFilter(String pomFile) {
            this.pomFile = pomFile;
        }

        public boolean accept(File dir, String name) {
            return this.pomFile.equals(name);
        }
    }

    private static class PomFilenameFilter
    implements FilenameFilter {
        private final String artifactId;
        private final String projectVersion;

        private PomFilenameFilter(String artifactId, String projectVersion) {
            this.artifactId = artifactId;
            this.projectVersion = projectVersion;
        }

        public boolean accept(File dir, String name) {
            if (name.startsWith(this.artifactId + "-") && name.endsWith(".pom")) {
                String v = name.substring(this.artifactId.length() + 1, name.length() - 4);
                if ((v = VersionUtil.getBaseVersion((String)v)).equals(this.projectVersion)) {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArtifactDirectoryFilter
    implements FilenameFilter {
        private final Filter<String> filter;

        public ArtifactDirectoryFilter(Filter<String> filter) {
            this.filter = filter;
        }

        @Override
        public boolean accept(File dir, String name) {
            if (!this.filter.accept((Object)name)) {
                return false;
            }
            if (name.startsWith(".")) {
                return false;
            }
            if (name.endsWith(".md5") || name.endsWith(".sha1") || name.endsWith(".asc")) {
                return false;
            }
            if (name.equals(Maven2RepositoryStorage.METADATA_FILENAME)) {
                return false;
            }
            if (new File(dir, name).isDirectory()) {
                return false;
            }
            return !StringUtils.startsWith((String)name, (String)Maven2RepositoryStorage.METADATA_FILENAME_START) || !StringUtils.endsWith((String)name, (String)".xml");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DirectoryFilter
    implements FilenameFilter {
        private final Filter<String> filter;

        public DirectoryFilter(Filter<String> filter) {
            this.filter = filter;
        }

        @Override
        public boolean accept(File dir, String name) {
            if (!this.filter.accept((Object)name)) {
                return false;
            }
            if (name.startsWith(".")) {
                return false;
            }
            return new File(dir, name).isDirectory();
        }
    }
}

