/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.dependency.tree.maven2;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.admin.model.beans.NetworkProxy;
import org.apache.archiva.admin.model.beans.ProxyConnector;
import org.apache.archiva.admin.model.beans.RemoteRepository;
import org.apache.archiva.admin.model.managed.ManagedRepositoryAdmin;
import org.apache.archiva.admin.model.networkproxy.NetworkProxyAdmin;
import org.apache.archiva.admin.model.proxyconnector.ProxyConnectorAdmin;
import org.apache.archiva.admin.model.remote.RemoteRepositoryAdmin;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridge;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridgeException;
import org.apache.archiva.dependency.tree.maven2.ArchivaRepositoryConnectorFactory;
import org.apache.archiva.dependency.tree.maven2.DependencyTreeBuilder;
import org.apache.archiva.dependency.tree.maven2.DependencyTreeBuilderException;
import org.apache.archiva.dependency.tree.maven2.TreeDependencyNodeVisitor;
import org.apache.archiva.maven2.metadata.MavenMetadataReader;
import org.apache.archiva.maven2.model.TreeEntry;
import org.apache.archiva.metadata.repository.storage.RepositoryPathTranslator;
import org.apache.archiva.model.ArchivaRepositoryMetadata;
import org.apache.archiva.proxy.common.WagonFactory;
import org.apache.archiva.xml.XMLException;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import org.apache.maven.repository.internal.DefaultVersionRangeResolver;
import org.apache.maven.repository.internal.DefaultVersionResolver;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.CollectResult;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.collection.DependencySelector;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyVisitor;
import org.sonatype.aether.impl.ArtifactDescriptorReader;
import org.sonatype.aether.impl.VersionRangeResolver;
import org.sonatype.aether.impl.VersionResolver;
import org.sonatype.aether.impl.internal.DefaultServiceLocator;
import org.sonatype.aether.impl.internal.SimpleLocalRepositoryManager;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.spi.connector.RepositoryConnectorFactory;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.graph.selector.AndDependencySelector;
import org.sonatype.aether.util.graph.selector.ExclusionDependencySelector;
import org.springframework.stereotype.Service;

@Service(value="dependencyTreeBuilder#maven3")
public class Maven3DependencyTreeBuilder
implements DependencyTreeBuilder {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    private PlexusSisuBridge plexusSisuBridge;
    @Inject
    @Named(value="repositoryPathTranslator#maven2")
    private RepositoryPathTranslator pathTranslator;
    @Inject
    private WagonFactory wagonFactory;
    @Inject
    private ManagedRepositoryAdmin managedRepositoryAdmin;
    @Inject
    private ProxyConnectorAdmin proxyConnectorAdmin;
    @Inject
    private NetworkProxyAdmin networkProxyAdmin;
    @Inject
    private RemoteRepositoryAdmin remoteRepositoryAdmin;
    private ArtifactFactory factory;
    private ModelBuilder builder;

    @PostConstruct
    public void initialize() throws PlexusSisuBridgeException {
        this.factory = (ArtifactFactory)this.plexusSisuBridge.lookup(ArtifactFactory.class, "default");
        DefaultModelBuilderFactory defaultModelBuilderFactory = new DefaultModelBuilderFactory();
        this.builder = defaultModelBuilderFactory.newInstance();
    }

    @Override
    public void buildDependencyTree(List<String> repositoryIds, String groupId, String artifactId, String version, DependencyVisitor dependencyVisitor) throws DependencyTreeBuilderException {
        org.apache.maven.artifact.Artifact projectArtifact = this.factory.createProjectArtifact(groupId, artifactId, version);
        ManagedRepository repository = null;
        try {
            repository = this.findArtifactInRepositories(repositoryIds, projectArtifact);
        }
        catch (RepositoryAdminException e) {
            throw new DependencyTreeBuilderException("Cannot build project dependency tree " + e.getMessage(), e);
        }
        if (repository == null) {
            return;
        }
        try {
            ArrayList<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
            HashMap<String, NetworkProxy> networkProxies = new HashMap<String, NetworkProxy>();
            Map proxyConnectorsMap = this.proxyConnectorAdmin.getProxyConnectorAsMap();
            List proxyConnectors = (List)proxyConnectorsMap.get(repository.getId());
            if (proxyConnectors != null) {
                for (ProxyConnector proxyConnector : proxyConnectors) {
                    remoteRepositories.add(this.remoteRepositoryAdmin.getRemoteRepository(proxyConnector.getTargetRepoId()));
                    NetworkProxy networkProxyConfig = this.networkProxyAdmin.getNetworkProxy(proxyConnector.getProxyId());
                    if (networkProxyConfig == null) continue;
                    networkProxies.put(proxyConnector.getTargetRepoId(), networkProxyConfig);
                }
            }
        }
        catch (RepositoryAdminException e) {
            throw new DependencyTreeBuilderException(e.getMessage(), e);
        }
        this.resolve(repository.getLocation(), groupId, artifactId, version, dependencyVisitor);
    }

    @Override
    public List<TreeEntry> buildDependencyTree(List<String> repositoryIds, String groupId, String artifactId, String version) throws DependencyTreeBuilderException {
        ArrayList<TreeEntry> treeEntries = new ArrayList<TreeEntry>();
        TreeDependencyNodeVisitor treeDependencyNodeVisitor = new TreeDependencyNodeVisitor(treeEntries);
        this.buildDependencyTree(repositoryIds, groupId, artifactId, version, treeDependencyNodeVisitor);
        this.log.debug("treeEntrie: {}", treeEntries);
        return treeEntries;
    }

    private void resolve(String localRepoDir, String groupId, String artifactId, String version, DependencyVisitor dependencyVisitor) {
        RepositorySystem system = Maven3DependencyTreeBuilder.newRepositorySystem();
        RepositorySystemSession session = Maven3DependencyTreeBuilder.newRepositorySystemSession(system, localRepoDir);
        DefaultArtifact artifact = new DefaultArtifact(groupId + ":" + artifactId + ":" + version);
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency((Artifact)artifact, ""));
        collectRequest.setRequestContext("project");
        try {
            CollectResult collectResult = system.collectDependencies(session, collectRequest);
            collectResult.getRoot().accept(dependencyVisitor);
            this.log.debug("test");
        }
        catch (DependencyCollectionException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = new DefaultServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, ArchivaRepositoryConnectorFactory.class);
        locator.addService(VersionResolver.class, DefaultVersionResolver.class);
        locator.addService(VersionRangeResolver.class, DefaultVersionRangeResolver.class);
        locator.addService(ArtifactDescriptorReader.class, DefaultArtifactDescriptorReader.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    public static RepositorySystemSession newRepositorySystemSession(RepositorySystem system, String localRepoDir) {
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        AndDependencySelector depFilter = new AndDependencySelector(new DependencySelector[]{new ExclusionDependencySelector()});
        session.setDependencySelector((DependencySelector)depFilter);
        LocalRepository localRepo = new LocalRepository(localRepoDir);
        session.setLocalRepositoryManager((LocalRepositoryManager)new SimpleLocalRepositoryManager(localRepoDir));
        return session;
    }

    private ManagedRepository findArtifactInRepositories(List<String> repositoryIds, org.apache.maven.artifact.Artifact projectArtifact) throws RepositoryAdminException {
        for (String repoId : repositoryIds) {
            File metadataFile;
            ManagedRepository managedRepository = this.managedRepositoryAdmin.getManagedRepository(repoId);
            File repoDir = new File(managedRepository.getLocation());
            File file = this.pathTranslator.toFile(repoDir, projectArtifact.getGroupId(), projectArtifact.getArtifactId(), projectArtifact.getBaseVersion(), projectArtifact.getArtifactId() + "-" + projectArtifact.getVersion() + ".pom");
            if (file.exists()) {
                return managedRepository;
            }
            if (!StringUtils.endsWith((String)projectArtifact.getBaseVersion(), (String)"SNAPSHOT") || !(metadataFile = new File(file.getParent(), "maven-metadata.xml")).exists()) continue;
            try {
                ArchivaRepositoryMetadata archivaRepositoryMetadata = MavenMetadataReader.read((File)metadataFile);
                int buildNumber = archivaRepositoryMetadata.getSnapshotVersion().getBuildNumber();
                String timeStamp = archivaRepositoryMetadata.getSnapshotVersion().getTimestamp();
                String timeStampFileName = projectArtifact.getArtifactId() + '-' + StringUtils.remove((String)projectArtifact.getBaseVersion(), (String)"-SNAPSHOT") + '-' + timeStamp + '-' + Integer.toString(buildNumber) + ".pom";
                File timeStampFile = new File(file.getParent(), timeStampFileName);
                this.log.debug("try to find timestamped snapshot version file: {}", (Object)timeStampFile.getPath());
                if (!timeStampFile.exists()) continue;
                return managedRepository;
            }
            catch (XMLException e) {
                this.log.warn("skip fail to find timestamped snapshot pom: {}", (Object)e.getMessage());
            }
        }
        return null;
    }
}

