/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.repository.content.maven2;

import java.util.Collections;
import org.apache.archiva.metadata.model.ArtifactMetadata;
import org.apache.archiva.metadata.model.maven2.MavenArtifactFacet;
import org.apache.archiva.metadata.repository.storage.RepositoryPathTranslator;
import org.apache.archiva.metadata.repository.storage.maven2.DefaultArtifactMappingProvider;
import org.apache.archiva.metadata.repository.storage.maven2.Maven2RepositoryPathTranslator;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.repository.content.PathParser;
import org.apache.archiva.repository.layout.LayoutException;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="pathParser#default")
public class DefaultPathParser
implements PathParser {
    private static final String INVALID_ARTIFACT_PATH = "Invalid path to Artifact: ";
    private RepositoryPathTranslator pathTranslator = new Maven2RepositoryPathTranslator(Collections.singletonList(new DefaultArtifactMappingProvider()));

    public ArtifactReference toArtifactReference(String path) throws LayoutException {
        ArtifactMetadata metadata;
        if (StringUtils.isBlank((String)path)) {
            throw new LayoutException("Unable to convert blank path.");
        }
        try {
            metadata = this.pathTranslator.getArtifactForPath(null, path);
        }
        catch (IllegalArgumentException e) {
            throw new LayoutException(e.getMessage(), (Throwable)e);
        }
        ArtifactReference artifact = new ArtifactReference();
        artifact.setGroupId(metadata.getNamespace());
        artifact.setArtifactId(metadata.getProject());
        artifact.setVersion(metadata.getVersion());
        MavenArtifactFacet facet = (MavenArtifactFacet)metadata.getFacet("org.apache.archiva.metadata.repository.storage.maven2.artifact");
        if (facet != null) {
            artifact.setClassifier(facet.getClassifier());
            artifact.setType(facet.getType());
        }
        return artifact;
    }
}

