/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.repository.content.legacy;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.model.ArchivaArtifact;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.repository.content.PathParser;
import org.apache.archiva.repository.content.maven2.ArtifactExtensionMapping;
import org.apache.archiva.repository.layout.LayoutException;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractLegacyRepositoryContent {
    private static final String PATH_SEPARATOR = "/";
    private static final Map<String, String> typeToDirectoryMap = new HashMap<String, String>(5);
    @Inject
    @Named(value="pathParser#legacy")
    private PathParser legacyPathParser;

    public ArtifactReference toArtifactReference(String path) throws LayoutException {
        return this.legacyPathParser.toArtifactReference(path);
    }

    public String toPath(ArchivaArtifact reference) {
        if (reference == null) {
            throw new IllegalArgumentException("Artifact reference cannot be null");
        }
        return this.toPath(reference.getGroupId(), reference.getArtifactId(), reference.getVersion(), reference.getClassifier(), reference.getType());
    }

    public String toPath(ArtifactReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException("Artifact reference cannot be null");
        }
        return this.toPath(reference.getGroupId(), reference.getArtifactId(), reference.getVersion(), reference.getClassifier(), reference.getType());
    }

    private String toPath(String groupId, String artifactId, String version, String classifier, String type) {
        StringBuilder path = new StringBuilder();
        path.append(groupId).append(PATH_SEPARATOR);
        path.append(this.getDirectory(type)).append(PATH_SEPARATOR);
        if (version != null) {
            path.append(artifactId).append('-').append(version);
            if (StringUtils.isNotBlank((String)classifier)) {
                path.append('-').append(classifier);
            }
            path.append('.').append(ArtifactExtensionMapping.getExtension(type));
        }
        return path.toString();
    }

    private String getDirectory(String type) {
        String dirname = typeToDirectoryMap.get(type);
        if (dirname != null) {
            return dirname + "s";
        }
        return type + "s";
    }

    public void setLegacyPathParser(PathParser parser) {
        this.legacyPathParser = parser;
    }

    static {
        typeToDirectoryMap.put("ejb-client", "ejb");
        typeToDirectoryMap.put("maven-one-plugin", "plugin");
        typeToDirectoryMap.put("distribution-tgz", "distribution");
        typeToDirectoryMap.put("distribution-zip", "distribution");
        typeToDirectoryMap.put("javadoc", "javadoc.jar");
    }
}

