/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.metadata.repository.storage.maven2;

import java.util.HashMap;
import java.util.Map;
import org.apache.archiva.metadata.model.MetadataFacet;
import org.apache.archiva.metadata.repository.storage.maven2.MavenProjectParent;

public class MavenProjectFacet
implements MetadataFacet {
    private String groupId;
    private String artifactId;
    private MavenProjectParent parent;
    private String packaging;
    public static final String FACET_ID = "org.apache.archiva.metadata.repository.storage.maven2.project";

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public MavenProjectParent getParent() {
        return this.parent;
    }

    public void setParent(MavenProjectParent parent) {
        this.parent = parent;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public String getFacetId() {
        return FACET_ID;
    }

    public String getName() {
        return null;
    }

    public Map<String, String> toProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("groupId", this.groupId);
        properties.put("artifactId", this.artifactId);
        properties.put("packaging", this.packaging);
        if (this.parent != null) {
            properties.put("parent.groupId", this.parent.getGroupId());
            properties.put("parent.artifactId", this.parent.getArtifactId());
            properties.put("parent.version", this.parent.getVersion());
        }
        return properties;
    }

    public void fromProperties(Map<String, String> properties) {
        this.groupId = properties.get("groupId");
        this.artifactId = properties.get("artifactId");
        this.packaging = properties.get("packaging");
        String parentArtifactId = properties.get("parent.artifactId");
        if (parentArtifactId != null) {
            MavenProjectParent parent = new MavenProjectParent();
            parent.setGroupId(properties.get("parent.groupId"));
            parent.setArtifactId(parentArtifactId);
            parent.setVersion(properties.get("parent.version"));
            this.parent = parent;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MavenProjectFacet)) {
            return false;
        }
        MavenProjectFacet that = (MavenProjectFacet)o;
        if (!this.artifactId.equals(that.artifactId)) {
            return false;
        }
        if (!this.groupId.equals(that.groupId)) {
            return false;
        }
        return this.packaging.equals(that.packaging);
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.packaging.hashCode();
        return result;
    }
}

