/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.repository.content.maven2;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.common.utils.PathUtil;
import org.apache.archiva.configuration.FileTypes;
import org.apache.archiva.metadata.repository.storage.maven2.DefaultArtifactMappingProvider;
import org.apache.archiva.model.ArchivaArtifact;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.model.ProjectReference;
import org.apache.archiva.model.VersionedReference;
import org.apache.archiva.repository.ContentNotFoundException;
import org.apache.archiva.repository.ManagedRepositoryContent;
import org.apache.archiva.repository.RepositoryException;
import org.apache.archiva.repository.content.maven2.AbstractDefaultRepositoryContent;
import org.apache.archiva.repository.layout.LayoutException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="managedRepositoryContent#default")
@Scope(value="prototype")
public class ManagedDefaultRepositoryContent
extends AbstractDefaultRepositoryContent
implements ManagedRepositoryContent {
    @Inject
    @Named(value="fileTypes")
    private FileTypes filetypes;
    private ManagedRepository repository;

    public ManagedDefaultRepositoryContent() {
        this.artifactMappingProviders = Collections.singletonList(new DefaultArtifactMappingProvider());
    }

    public void deleteVersion(VersionedReference reference) {
        String path = this.toMetadataPath(reference);
        File projectPath = new File(this.getRepoRoot(), path);
        File projectDir = projectPath.getParentFile();
        if (projectDir.exists() && projectDir.isDirectory()) {
            FileUtils.deleteQuietly((File)projectDir);
        }
    }

    public void deleteProject(String namespace, String projectId) throws RepositoryException, ContentNotFoundException {
        ArtifactReference artifactReference = new ArtifactReference();
        artifactReference.setGroupId(namespace);
        artifactReference.setArtifactId(projectId);
        String path = this.toPath(artifactReference);
        File directory = new File(this.getRepoRoot(), path);
        if (!directory.exists()) {
            throw new ContentNotFoundException("cannot found project " + namespace + ":" + projectId);
        }
        if (directory.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)directory);
            }
            catch (IOException e) {
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.log.warn("project {}:{} is not a directory", (Object)namespace, (Object)projectId);
        }
    }

    public void deleteArtifact(ArtifactReference artifactReference) {
        File filePathsha1;
        File filePathmd5;
        String path = this.toPath(artifactReference);
        File filePath = new File(this.getRepoRoot(), path);
        if (filePath.exists()) {
            FileUtils.deleteQuietly((File)filePath);
        }
        if ((filePathmd5 = new File(this.getRepoRoot(), path + ".md5")).exists()) {
            FileUtils.deleteQuietly((File)filePathmd5);
        }
        if ((filePathsha1 = new File(this.getRepoRoot(), path + ".sha1")).exists()) {
            FileUtils.deleteQuietly((File)filePathsha1);
        }
    }

    public void deleteGroupId(String groupId) throws ContentNotFoundException {
        String path = StringUtils.replaceChars((String)groupId, (char)'.', (char)'/');
        File directory = new File(this.getRepoRoot(), path);
        if (directory.exists()) {
            try {
                FileUtils.deleteDirectory((File)directory);
            }
            catch (IOException e) {
                this.log.warn("skip error deleting directory {}:", (Object)directory.getPath(), (Object)e);
            }
        }
    }

    public String getId() {
        return this.repository.getId();
    }

    public Set<ArtifactReference> getRelatedArtifacts(ArtifactReference reference) throws ContentNotFoundException {
        File[] repoFiles;
        File artifactFile = this.toFile(reference);
        File repoDir = artifactFile.getParentFile();
        if (!repoDir.exists()) {
            throw new ContentNotFoundException("Unable to get related artifacts using a non-existant directory: " + repoDir.getAbsolutePath());
        }
        if (!repoDir.isDirectory()) {
            throw new ContentNotFoundException("Unable to get related artifacts using a non-directory: " + repoDir.getAbsolutePath());
        }
        HashSet<ArtifactReference> foundArtifacts = new HashSet<ArtifactReference>();
        for (File repoFile : repoFiles = repoDir.listFiles()) {
            String relativePath;
            if (repoFile.isDirectory() || !this.filetypes.matchesArtifactPattern(relativePath = PathUtil.getRelative((String)this.repository.getLocation(), (File)repoFile))) continue;
            try {
                ArtifactReference artifact = this.toArtifactReference(relativePath);
                if (!artifact.getGroupId().equals(reference.getGroupId()) || !artifact.getArtifactId().equals(reference.getArtifactId()) || !artifact.getVersion().equals(reference.getVersion())) continue;
                foundArtifacts.add(artifact);
            }
            catch (LayoutException e) {
                this.log.debug("Not processing file that is not an artifact: {}", (Object)e.getMessage());
            }
        }
        return foundArtifacts;
    }

    public String getRepoRoot() {
        return this.repository.getLocation();
    }

    public ManagedRepository getRepository() {
        return this.repository;
    }

    public Set<String> getVersions(ProjectReference reference) throws ContentNotFoundException, LayoutException {
        File[] repoFiles;
        File repoDir;
        String path = this.toMetadataPath(reference);
        int idx = path.lastIndexOf(47);
        if (idx > 0) {
            path = path.substring(0, idx);
        }
        if (!(repoDir = new File(this.repository.getLocation(), path)).exists()) {
            throw new ContentNotFoundException("Unable to get Versions on a non-existant directory: " + repoDir.getAbsolutePath());
        }
        if (!repoDir.isDirectory()) {
            throw new ContentNotFoundException("Unable to get Versions on a non-directory: " + repoDir.getAbsolutePath());
        }
        HashSet<String> foundVersions = new HashSet<String>();
        VersionedReference versionRef = new VersionedReference();
        versionRef.setGroupId(reference.getGroupId());
        versionRef.setArtifactId(reference.getArtifactId());
        for (File repoFile : repoFiles = repoDir.listFiles()) {
            if (!repoFile.isDirectory()) continue;
            String version = repoFile.getName();
            versionRef.setVersion(version);
            if (!this.hasArtifact(versionRef)) continue;
            foundVersions.add(version);
        }
        return foundVersions;
    }

    public Set<String> getVersions(VersionedReference reference) throws ContentNotFoundException {
        File[] repoFiles;
        File repoDir;
        String path = this.toMetadataPath(reference);
        int idx = path.lastIndexOf(47);
        if (idx > 0) {
            path = path.substring(0, idx);
        }
        if (!(repoDir = new File(this.repository.getLocation(), path)).exists()) {
            throw new ContentNotFoundException("Unable to get versions on a non-existant directory: " + repoDir.getAbsolutePath());
        }
        if (!repoDir.isDirectory()) {
            throw new ContentNotFoundException("Unable to get versions on a non-directory: " + repoDir.getAbsolutePath());
        }
        HashSet<String> foundVersions = new HashSet<String>();
        for (File repoFile : repoFiles = repoDir.listFiles()) {
            String relativePath;
            if (repoFile.isDirectory() || this.filetypes.matchesDefaultExclusions(relativePath = PathUtil.getRelative((String)this.repository.getLocation(), (File)repoFile)) || !this.filetypes.matchesArtifactPattern(relativePath)) continue;
            try {
                ArtifactReference artifact = this.toArtifactReference(relativePath);
                foundVersions.add(artifact.getVersion());
            }
            catch (LayoutException e) {
                this.log.debug("Not processing file that is not an artifact: {}", (Object)e.getMessage());
            }
        }
        return foundVersions;
    }

    public boolean hasContent(ArtifactReference reference) {
        File artifactFile = this.toFile(reference);
        return artifactFile.exists() && artifactFile.isFile();
    }

    public boolean hasContent(ProjectReference reference) {
        try {
            Set<String> versions = this.getVersions(reference);
            return !versions.isEmpty();
        }
        catch (ContentNotFoundException | LayoutException e) {
            return false;
        }
    }

    public boolean hasContent(VersionedReference reference) {
        try {
            return this.getFirstArtifact(reference) != null;
        }
        catch (IOException | LayoutException e) {
            return false;
        }
    }

    public void setRepository(ManagedRepository repository) {
        this.repository = repository;
    }

    @Override
    public ArtifactReference toArtifactReference(String path) throws LayoutException {
        if (path != null && path.startsWith(this.repository.getLocation()) && this.repository.getLocation().length() > 0) {
            return super.toArtifactReference(path.substring(this.repository.getLocation().length() + 1));
        }
        return super.toArtifactReference(path);
    }

    public File toFile(ArtifactReference reference) {
        return new File(this.repository.getLocation(), this.toPath(reference));
    }

    public File toFile(ArchivaArtifact reference) {
        return new File(this.repository.getLocation(), this.toPath(reference));
    }

    private ArtifactReference getFirstArtifact(VersionedReference reference) throws LayoutException, IOException {
        File[] repoFiles;
        File repoDir;
        String path = this.toMetadataPath(reference);
        int idx = path.lastIndexOf(47);
        if (idx > 0) {
            path = path.substring(0, idx);
        }
        if (!(repoDir = new File(this.repository.getLocation(), path)).exists()) {
            throw new IOException("Unable to gather the list of snapshot versions on a non-existant directory: " + repoDir.getAbsolutePath());
        }
        if (!repoDir.isDirectory()) {
            throw new IOException("Unable to gather the list of snapshot versions on a non-directory: " + repoDir.getAbsolutePath());
        }
        for (File repoFile : repoFiles = repoDir.listFiles()) {
            String relativePath;
            if (repoFile.isDirectory() || !this.filetypes.matchesArtifactPattern(relativePath = PathUtil.getRelative((String)this.repository.getLocation(), (File)repoFile))) continue;
            ArtifactReference artifact = this.toArtifactReference(relativePath);
            return artifact;
        }
        return null;
    }

    private boolean hasArtifact(VersionedReference reference) throws LayoutException {
        try {
            return this.getFirstArtifact(reference) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void setFiletypes(FileTypes filetypes) {
        this.filetypes = filetypes;
    }
}

