/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.metadata.repository;

import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataRepositoryException;
import org.apache.archiva.metadata.repository.MetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositorySession {
    private final MetadataRepository repository;
    private final MetadataResolver resolver;
    private boolean dirty;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public RepositorySession(MetadataRepository metadataRepository, MetadataResolver resolver) {
        this.repository = metadataRepository;
        this.resolver = resolver;
    }

    public MetadataRepository getRepository() {
        return this.repository;
    }

    public MetadataResolver getResolver() {
        return this.resolver;
    }

    public void save() {
        this.repository.save();
        this.dirty = false;
    }

    public void revert() {
        this.repository.revert();
        this.dirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.dirty) {
                this.save();
            }
        }
        finally {
            try {
                this.repository.close();
            }
            catch (MetadataRepositoryException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public void markDirty() {
        this.dirty = true;
    }
}

