/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.metadata.repository.cassandra.model;

import java.io.Serializable;
import org.apache.archiva.metadata.repository.cassandra.CassandraUtils;
import org.apache.archiva.metadata.repository.cassandra.model.Repository;

public class Namespace
implements Serializable {
    private String name;
    private String repositoryName;

    public Namespace() {
    }

    public Namespace(String id, Repository repository) {
        this.name = id;
        this.repositoryName = repository.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Repository getRepository() {
        return new Repository(this.repositoryName);
    }

    public void setRepository(Repository repository) {
        this.repositoryName = repository.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Namespace namespace = (Namespace)o;
        if (!this.name.equals(namespace.name)) {
            return false;
        }
        return this.repositoryName.equals(namespace.repositoryName);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.repositoryName.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Namespace{");
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", repository='").append(this.repositoryName).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static class KeyBuilder {
        private String namespace;
        private String repositoryId;

        public KeyBuilder withNamespace(Namespace namespace) {
            this.namespace = namespace.getName();
            this.repositoryId = namespace.getRepository().getName();
            return this;
        }

        public KeyBuilder withNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public KeyBuilder withRepositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public String build() {
            return CassandraUtils.generateKey(this.repositoryId, this.namespace);
        }
    }
}

