/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.plugins.npanday;

import java.util.HashMap;
import java.util.Map;
import org.apache.archiva.metadata.repository.storage.maven2.ArtifactMappingProvider;
import org.springframework.stereotype.Service;

@Service(value="artifactMappingProvider#npanday")
public class NPandayArtifactMappingProvider
implements ArtifactMappingProvider {
    private final Map<String, String> extensionToTypeMap = new HashMap<String, String>();
    private final Map<String, String> typeToExtensionMap;

    public NPandayArtifactMappingProvider() {
        this.extensionToTypeMap.put("dll", "dotnet-library");
        this.extensionToTypeMap.put("netmodule", "dotnet-module");
        this.extensionToTypeMap.put("exe", "dotnet-executable");
        this.typeToExtensionMap = new HashMap<String, String>();
        this.typeToExtensionMap.put("dotnet-library", "dll");
        this.typeToExtensionMap.put("dotnet-library-config", "dll.config");
        this.typeToExtensionMap.put("dotnet-executable", "exe");
        this.typeToExtensionMap.put("dotnet-executable-config", "exe.config");
        this.typeToExtensionMap.put("dotnet-module", "netmodule");
        this.typeToExtensionMap.put("dotnet-maven-plugin", "dll");
        this.typeToExtensionMap.put("asp", "dll");
        this.typeToExtensionMap.put("visual-studio-addin", "dll");
        this.typeToExtensionMap.put("sharp-develop-addin", "dll");
        this.typeToExtensionMap.put("nar", "nar");
        this.typeToExtensionMap.put("dotnet-symbols", "pdb");
        this.typeToExtensionMap.put("ole-type-library", "tlb");
        this.typeToExtensionMap.put("dotnet-vsdocs", "xml");
        this.typeToExtensionMap.put("dotnet-archive", "zip");
        this.typeToExtensionMap.put("dotnet-gac", "dll");
        this.typeToExtensionMap.put("gac", "dll");
        this.typeToExtensionMap.put("gac_msil", "dll");
        this.typeToExtensionMap.put("gac_msil4", "dll");
        this.typeToExtensionMap.put("gac_32", "dll");
        this.typeToExtensionMap.put("gac_32_4", "dll");
        this.typeToExtensionMap.put("gac_64", "dll");
        this.typeToExtensionMap.put("gac_64_4", "dll");
        this.typeToExtensionMap.put("com_reference", "dll");
        this.typeToExtensionMap.put("library", "dll");
        this.typeToExtensionMap.put("gac_generic", "dll");
        this.typeToExtensionMap.put("netplugin", "dll");
        this.typeToExtensionMap.put("module", "netmodule");
        this.typeToExtensionMap.put("exe.config", "exe.config");
        this.typeToExtensionMap.put("winexe", "exe");
        this.typeToExtensionMap.put("exe", "exe");
    }

    public String mapClassifierAndExtensionToType(String classifier, String ext) {
        return this.extensionToTypeMap.get(ext);
    }

    public String mapTypeToExtension(String type) {
        return this.typeToExtensionMap.get(type);
    }
}

