/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.modelling.standalone;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.xml.validation.Schema;
import org.apache.aries.application.modelling.ModelledResourceManager;
import org.apache.aries.application.modelling.ModellingManager;
import org.apache.aries.application.modelling.ParserProxy;
import org.apache.aries.application.modelling.ServiceModeller;
import org.apache.aries.application.modelling.impl.AbstractParserProxy;
import org.apache.aries.application.modelling.impl.ModelledResourceManagerImpl;
import org.apache.aries.application.modelling.impl.ModellingManagerImpl;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.parser.ComponentDefinitionRegistryImpl;
import org.apache.aries.blueprint.parser.NamespaceHandlerSet;
import org.apache.aries.blueprint.parser.Parser;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.NullMetadata;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class OfflineModellingFactory {
    private static final NamespaceHandlerSet DUMMY_HANDLER_SET = new NamespaceHandlerSet(){

        public NamespaceHandler getNamespaceHandler(URI arg0) {
            return new NamespaceHandler(){

                public Metadata parse(Element arg0, ParserContext arg1) {
                    return NullMetadata.NULL;
                }

                public URL getSchemaLocation(String arg0) {
                    return null;
                }

                public Set<Class> getManagedClasses() {
                    return Collections.emptySet();
                }

                public ComponentMetadata decorate(Node arg0, ComponentMetadata arg1, ParserContext arg2) {
                    return arg1;
                }
            };
        }

        public Set<URI> getNamespaces() {
            return Collections.emptySet();
        }

        public Schema getSchema() throws SAXException, IOException {
            return null;
        }

        public boolean isComplete() {
            return true;
        }

        public void addListener(NamespaceHandlerSet.Listener arg0) {
        }

        public void removeListener(NamespaceHandlerSet.Listener arg0) {
        }

        public void destroy() {
        }
    };

    public static ParserProxy getOfflineParserProxy() {
        ModellingManagerImpl modellingManager = new ModellingManagerImpl();
        OfflineParserProxy parserProxy = new OfflineParserProxy();
        parserProxy.setModellingManager((ModellingManager)modellingManager);
        return parserProxy;
    }

    public static ModelledResourceManager getModelledResourceManager() {
        ModellingManagerImpl modellingManager = new ModellingManagerImpl();
        OfflineParserProxy parserProxy = new OfflineParserProxy();
        parserProxy.setModellingManager((ModellingManager)modellingManager);
        ModelledResourceManagerImpl result = new ModelledResourceManagerImpl();
        result.setModellingManager((ModellingManager)modellingManager);
        result.setParserProxy((ParserProxy)parserProxy);
        ArrayList<ServiceModeller> plugins = new ArrayList<ServiceModeller>();
        ClassLoader cl = OfflineModellingFactory.class.getClassLoader();
        try {
            Enumeration<URL> e = cl.getResources("META-INF/services/" + ServiceModeller.class.getName());
            while (e.hasMoreElements()) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(e.nextElement().openStream()));
                try {
                    plugins.add((ServiceModeller)Class.forName(reader.readLine(), true, cl).newInstance());
                }
                catch (Exception e1) {
                    e1.printStackTrace(System.err);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        result.setModellingPlugins(plugins);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OfflineParserProxy
    extends AbstractParserProxy {
        private OfflineParserProxy() {
        }

        protected ComponentDefinitionRegistry parseCDR(List<URL> blueprintsToParse) throws Exception {
            Parser parser = new Parser();
            parser.parse(blueprintsToParse);
            return this.getCDR(parser);
        }

        protected ComponentDefinitionRegistry parseCDR(InputStream blueprintToParse) throws Exception {
            Parser parser = new Parser();
            parser.parse(blueprintToParse);
            return this.getCDR(parser);
        }

        private ComponentDefinitionRegistry getCDR(Parser parser) {
            ComponentDefinitionRegistryImpl cdr = new ComponentDefinitionRegistryImpl();
            parser.populate(DUMMY_HANDLER_SET, (ComponentDefinitionRegistry)cdr);
            return cdr;
        }
    }
}

