/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.utils.filesystem;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.aries.application.filesystem.IDirectory;
import org.apache.aries.application.utils.filesystem.impl.DirectoryImpl;
import org.apache.aries.application.utils.filesystem.impl.ZipDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystem {
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.application.utils");

    public static IDirectory getFSRoot(File fs) {
        Object dir = null;
        if (fs.exists()) {
            if (fs.isDirectory()) {
                dir = new DirectoryImpl(fs, fs);
            } else if (fs.isFile()) {
                try {
                    dir = new ZipDirectory(fs, fs);
                }
                catch (IOException e) {
                    _logger.error("IOException in IDirectory.getFSRoot", (Throwable)e);
                }
            }
        } else {
            _logger.error("File not found in IDirectory.getFSRoot", (Throwable)new FileNotFoundException(fs.getPath()));
        }
        return dir;
    }
}

