/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.utils.filesystem.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.aries.application.filesystem.IDirectory;
import org.apache.aries.application.filesystem.IFile;
import org.apache.aries.application.utils.filesystem.impl.ZipDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipFileImpl
implements IFile {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.apache.aries.application.utils");
    private String name = "";
    private final long size;
    private final long lastModified;
    protected File zip;
    protected ZipEntry entry;
    private ZipDirectory parent;
    private final String url;

    public ZipFileImpl(File zip1, ZipEntry entry1, ZipDirectory parent1) {
        this.zip = zip1;
        this.entry = entry1;
        this.name = entry1.getName();
        if (entry1.isDirectory()) {
            this.name = this.name.substring(0, this.name.length() - 1);
        }
        this.lastModified = entry1.getTime();
        this.size = entry1.getSize();
        this.url = parent1.url;
        this.parent = parent1;
    }

    protected ZipFileImpl(File zip1, File fs) throws MalformedURLException {
        this.zip = zip1;
        this.entry = null;
        this.name = "";
        this.lastModified = fs.lastModified();
        this.size = fs.length();
        this.url = fs.toURI().toURL().toExternalForm();
    }

    public IDirectory convert() {
        return null;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getName() {
        return this.name;
    }

    public IDirectory getParent() {
        return this.parent;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isFile() {
        return true;
    }

    public InputStream open() throws IOException {
        SpecialZipInputStream is = new SpecialZipInputStream(this.entry);
        return is;
    }

    public IDirectory getRoot() {
        IDirectory root = this.parent.getRoot();
        return root;
    }

    public URL toURL() throws MalformedURLException {
        String entryURL = "jar:" + this.url + "!/" + this.getName();
        URL result = new URL(entryURL);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() == this.getClass()) {
            return this.toString().equals(obj.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.url.substring(5) + "/" + this.name;
    }

    ZipFile openZipFile() {
        ZipFile z = null;
        try {
            z = new ZipFile(this.zip);
        }
        catch (ZipException e) {
            logger.error("ZipException in ZipFileImpl.openZipFile", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("IOException in ZipFileImpl.openZipFile", (Throwable)e);
        }
        return z;
    }

    void closeZipFile(ZipFile z) {
        try {
            z.close();
        }
        catch (IOException e) {
            logger.error("IOException in ZipFileImpl.closeZipFile", (Throwable)e);
        }
    }

    private class SpecialZipInputStream
    extends InputStream {
        private ZipFile zipFile;
        private InputStream is;

        public SpecialZipInputStream(ZipEntry anEntry) {
            try {
                this.zipFile = ZipFileImpl.this.openZipFile();
                this.is = this.zipFile.getInputStream(anEntry);
            }
            catch (ZipException e) {
                logger.error("ZipException in SpecialZipInputStream()", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("IOException in SpecialZipInputStream()", (Throwable)e);
            }
        }

        public int read() throws IOException {
            return this.is.read();
        }

        public void close() throws IOException {
            this.is.close();
            ZipFileImpl.this.closeZipFile(this.zipFile);
        }
    }
}

