/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.utils.manifest;

import java.io.File;
import java.util.Map;
import java.util.jar.Manifest;
import org.apache.aries.application.filesystem.IDirectory;
import org.apache.aries.application.filesystem.IFile;
import org.apache.aries.application.utils.filesystem.FileSystem;
import org.apache.aries.application.utils.manifest.BundleManifest;
import org.apache.aries.application.utils.manifest.ManifestProcessor;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestDefaultsInjector {
    public static boolean updateManifest(Manifest mf, String appName, File zip) {
        IDirectory appPathIDir = FileSystem.getFSRoot(zip);
        boolean result = ManifestDefaultsInjector.updateManifest(mf, appName, appPathIDir);
        return result;
    }

    public static boolean updateManifest(Manifest mf, String appName, IDirectory appDir) {
        Map<String, String> props = ManifestProcessor.readManifestIntoMap(mf);
        String[] extracted = ManifestDefaultsInjector.extractAppNameAndVersionFromNameIfPossible(appName);
        String name = extracted[0];
        String version = extracted[1];
        boolean updated = false;
        updated |= ManifestDefaultsInjector.defaultAppSymbolicName(mf, props, name);
        updated |= ManifestDefaultsInjector.defaultAppName(mf, props, name);
        updated |= ManifestDefaultsInjector.defaultVersion(mf, props, version);
        updated |= ManifestDefaultsInjector.defaultAppScope(mf, props, name, version);
        return updated |= ManifestDefaultsInjector.defaultAppContent(mf, props, appDir);
    }

    private static String[] extractAppNameAndVersionFromNameIfPossible(String name) {
        String defaultedVersion;
        String[] retval = new String[2];
        String appName = name;
        int index = name.indexOf(95);
        if (index != -1) {
            appName = name.substring(0, index);
            defaultedVersion = name.substring(index + 1);
            try {
                new Version(defaultedVersion);
            }
            catch (IllegalArgumentException e) {
                defaultedVersion = "0.0.0";
            }
        } else {
            defaultedVersion = "0.0.0";
        }
        retval[0] = appName;
        retval[1] = defaultedVersion;
        return retval;
    }

    private static boolean defaultAppSymbolicName(Manifest mf, Map<String, String> props, String appName) {
        boolean updated = false;
        if (!props.containsKey("Application-SymbolicName")) {
            mf.getMainAttributes().putValue("Application-SymbolicName", appName);
            updated = true;
        }
        return updated;
    }

    private static boolean defaultAppName(Manifest mf, Map<String, String> props, String appName) {
        boolean updated = false;
        if (!props.containsKey("Application-Name")) {
            mf.getMainAttributes().putValue("Application-Name", appName);
            updated = true;
        }
        return updated;
    }

    private static boolean defaultVersion(Manifest mf, Map<String, String> props, String appVersion) {
        boolean updated = false;
        if (!props.containsKey("Application-Version")) {
            mf.getMainAttributes().putValue("Application-Version", appVersion);
            updated = true;
        }
        return updated;
    }

    private static boolean defaultAppScope(Manifest mf, Map<String, String> props, String name, String version) {
        boolean updated = false;
        if (!props.containsKey("Application-Scope")) {
            String appSymbolicName = props.containsKey("Application-SymbolicName") ? props.get("Application-SymbolicName") : name;
            String appVersion = props.containsKey("Application-Version") ? props.get("Application-Version") : version;
            String appScope = appSymbolicName + '_' + appVersion;
            mf.getMainAttributes().putValue("Application-Scope", appScope);
            updated = true;
        }
        return updated;
    }

    private static boolean defaultAppContent(Manifest mf, Map<String, String> props, IDirectory appDir) {
        String appContent;
        boolean updated = false;
        if (!props.containsKey("Application-Content") && (appContent = ManifestDefaultsInjector.calculateAppContent(appDir)) != null) {
            mf.getMainAttributes().putValue("Application-Content", appContent);
            updated = true;
        }
        return updated;
    }

    private static String calculateAppContent(IDirectory appDir) {
        StringBuilder builder = new StringBuilder();
        for (IFile file : appDir) {
            ManifestDefaultsInjector.processPossibleBundle(file, builder);
        }
        String returnVal = null;
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
            returnVal = builder.toString();
        }
        return returnVal;
    }

    private static void processPossibleBundle(IFile file, StringBuilder builder) {
        BundleManifest bundleMf;
        if ((file.isDirectory() || file.isFile() && (file.getName().endsWith(".jar") || file.getName().endsWith(".war"))) && (bundleMf = BundleManifest.fromBundle(file)) != null) {
            String manifestVersion = bundleMf.getManifestVersion();
            String name = bundleMf.getSymbolicName();
            String version = bundleMf.getVersion().toString();
            if ("2".equals(manifestVersion) && name != null) {
                builder.append(name);
                if (version != null) {
                    builder.append(";version=\"[");
                    builder.append(version);
                    builder.append(',');
                    builder.append(version);
                    builder.append("]\"");
                }
                builder.append(",");
            }
        }
    }
}

